/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnchantmentHelper {
    public static int getItemEnchantmentLevel(Holder<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantments = stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return itemEnchantments.getLevel(enchantment);
    }

    public static ItemEnchantments updateEnchantments(ItemStack stack, Consumer<ItemEnchantments.Mutable> applier) {
        DataComponentType<ItemEnchantments> dataComponentType = EnchantmentHelper.getComponentType(stack);
        ItemEnchantments itemEnchantments = stack.get(dataComponentType);
        if (itemEnchantments == null) {
            return ItemEnchantments.EMPTY;
        }
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        applier.accept(mutable);
        ItemEnchantments itemEnchantments2 = mutable.toImmutable();
        stack.set(dataComponentType, itemEnchantments2);
        return itemEnchantments2;
    }

    public static boolean canStoreEnchantments(ItemStack stack) {
        return stack.has(EnchantmentHelper.getComponentType(stack));
    }

    public static void setEnchantments(ItemStack stack, ItemEnchantments enchantments) {
        stack.set(EnchantmentHelper.getComponentType(stack), enchantments);
    }

    public static ItemEnchantments getEnchantmentsForCrafting(ItemStack stack) {
        return stack.getOrDefault(EnchantmentHelper.getComponentType(stack), ItemEnchantments.EMPTY);
    }

    private static DataComponentType<ItemEnchantments> getComponentType(ItemStack stack) {
        return stack.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static boolean hasAnyEnchantments(ItemStack stack) {
        return !stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public static int processDurabilityChange(ServerLevel world, ItemStack stack, int baseItemDamage) {
        MutableFloat mutableFloat = new MutableFloat((float)baseItemDamage);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyDurabilityChange(world, level, stack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int processAmmoUse(ServerLevel world, ItemStack rangedWeaponStack, ItemStack projectileStack, int baseAmmoUse) {
        MutableFloat mutableFloat = new MutableFloat((float)baseAmmoUse);
        EnchantmentHelper.runIterationOnItem(rangedWeaponStack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyAmmoCount(world, level, projectileStack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int processBlockExperience(ServerLevel world, ItemStack stack, int baseBlockExperience) {
        MutableFloat mutableFloat = new MutableFloat((float)baseBlockExperience);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyBlockExperience(world, level, stack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int processMobExperience(ServerLevel world, @Nullable Entity attacker, Entity mob, int baseMobExperience) {
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            MutableFloat mutableFloat = new MutableFloat((float)baseMobExperience);
            EnchantmentHelper.runIterationOnEquipment(livingEntity, (enchantment, level, context) -> ((Enchantment)enchantment.value()).modifyMobExperience(world, level, context.itemStack(), mob, mutableFloat));
            return mutableFloat.intValue();
        }
        return baseMobExperience;
    }

    public static ItemStack createBook(EnchantmentInstance entry) {
        ItemStack itemStack = new ItemStack(Items.ENCHANTED_BOOK);
        itemStack.enchant(entry.enchantment, entry.level);
        return itemStack;
    }

    private static void runIterationOnItem(ItemStack stack, EnchantmentVisitor consumer) {
        ItemEnchantments itemEnchantments = stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.entrySet()) {
            consumer.accept((Holder)entry.getKey(), entry.getIntValue());
        }
    }

    private static void runIterationOnItem(ItemStack stack, EquipmentSlot slot, LivingEntity entity, EnchantmentInSlotVisitor contextAwareConsumer) {
        if (stack.isEmpty()) {
            return;
        }
        ItemEnchantments itemEnchantments = stack.get(DataComponents.ENCHANTMENTS);
        if (itemEnchantments == null || itemEnchantments.isEmpty()) {
            return;
        }
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(stack, slot, entity);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.entrySet()) {
            Holder holder = (Holder)entry.getKey();
            if (!((Enchantment)holder.value()).matchingSlot(slot)) continue;
            contextAwareConsumer.accept(holder, entry.getIntValue(), enchantedItemInUse);
        }
    }

    private static void runIterationOnEquipment(LivingEntity entity, EnchantmentInSlotVisitor contextAwareConsumer) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            EnchantmentHelper.runIterationOnItem(entity.getItemBySlot(equipmentSlot), equipmentSlot, entity, contextAwareConsumer);
        }
    }

    public static boolean isImmuneToDamage(ServerLevel world, LivingEntity user, DamageSource damageSource) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        EnchantmentHelper.runIterationOnEquipment(user, (enchantment, level, context) -> mutableBoolean.setValue(mutableBoolean.isTrue() || ((Enchantment)enchantment.value()).isImmuneToDamage(world, level, user, damageSource)));
        return mutableBoolean.isTrue();
    }

    public static float getDamageProtection(ServerLevel world, LivingEntity user, DamageSource damageSource) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnEquipment(user, (enchantment, level, context) -> ((Enchantment)enchantment.value()).modifyDamageProtection(world, level, context.itemStack(), user, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float modifyDamage(ServerLevel world, ItemStack stack, Entity target, DamageSource damageSource, float baseDamage) {
        MutableFloat mutableFloat = new MutableFloat(baseDamage);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyDamage(world, level, stack, target, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float modifyFallBasedDamage(ServerLevel world, ItemStack stack, Entity target, DamageSource damageSource, float baseSmashDamagePerFallenBlock) {
        MutableFloat mutableFloat = new MutableFloat(baseSmashDamagePerFallenBlock);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyFallBasedDamage(world, level, stack, target, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float modifyArmorEffectiveness(ServerLevel world, ItemStack stack, Entity user, DamageSource damageSource, float baseArmorEffectiveness) {
        MutableFloat mutableFloat = new MutableFloat(baseArmorEffectiveness);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyArmorEffectivness(world, level, stack, user, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float modifyKnockback(ServerLevel world, ItemStack stack, Entity target, DamageSource damageSource, float baseKnockback) {
        MutableFloat mutableFloat = new MutableFloat(baseKnockback);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyKnockback(world, level, stack, target, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static void doPostAttackEffects(ServerLevel world, Entity target, DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EnchantmentHelper.doPostAttackEffectsWithItemSource(world, target, damageSource, livingEntity.getWeaponItem());
        } else {
            EnchantmentHelper.doPostAttackEffectsWithItemSource(world, target, damageSource, null);
        }
    }

    public static void doPostAttackEffectsWithItemSource(ServerLevel world, Entity target, DamageSource damageSource, @Nullable ItemStack weapon) {
        EnchantmentHelper.doPostAttackEffectsWithItemSourceOnBreak(world, target, damageSource, weapon, null);
    }

    public static void doPostAttackEffectsWithItemSourceOnBreak(ServerLevel world, Entity target, DamageSource damageSource, @Nullable ItemStack weapon, @Nullable Consumer<Item> breakCallback) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            EnchantmentHelper.runIterationOnEquipment(livingEntity, (enchantment, level, context) -> ((Enchantment)enchantment.value()).doPostAttack(world, level, context, EnchantmentTarget.VICTIM, target, damageSource));
        }
        if (weapon != null) {
            Entity entity = damageSource.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                EnchantmentHelper.runIterationOnItem(weapon, EquipmentSlot.MAINHAND, livingEntity2, (enchantment, level, context) -> ((Enchantment)enchantment.value()).doPostAttack(world, level, context, EnchantmentTarget.ATTACKER, target, damageSource));
            } else if (breakCallback != null) {
                EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(weapon, null, null, breakCallback);
                EnchantmentHelper.runIterationOnItem(weapon, (enchantment, level) -> ((Enchantment)enchantment.value()).doPostAttack(world, level, enchantedItemInUse, EnchantmentTarget.ATTACKER, target, damageSource));
            }
        }
    }

    public static void runLocationChangedEffects(ServerLevel world, LivingEntity user) {
        EnchantmentHelper.runIterationOnEquipment(user, (enchantment, level, context) -> ((Enchantment)enchantment.value()).runLocationChangedEffects(world, level, context, user));
    }

    public static void runLocationChangedEffects(ServerLevel world, ItemStack stack, LivingEntity user, EquipmentSlot slot) {
        EnchantmentHelper.runIterationOnItem(stack, slot, user, (enchantment, level, context) -> ((Enchantment)enchantment.value()).runLocationChangedEffects(world, level, context, user));
    }

    public static void stopLocationBasedEffects(LivingEntity user) {
        EnchantmentHelper.runIterationOnEquipment(user, (enchantment, level, context) -> ((Enchantment)enchantment.value()).stopLocationBasedEffects(level, context, user));
    }

    public static void stopLocationBasedEffects(ItemStack stack, LivingEntity user, EquipmentSlot slot) {
        EnchantmentHelper.runIterationOnItem(stack, slot, user, (enchantment, level, context) -> ((Enchantment)enchantment.value()).stopLocationBasedEffects(level, context, user));
    }

    public static void tickEffects(ServerLevel world, LivingEntity user) {
        EnchantmentHelper.runIterationOnEquipment(user, (enchantment, level, context) -> ((Enchantment)enchantment.value()).tick(world, level, context, user));
    }

    public static int getEnchantmentLevel(Holder<Enchantment> enchantment, LivingEntity entity) {
        Collection<ItemStack> iterable = enchantment.value().getSlotItems(entity).values();
        int i = 0;
        for (ItemStack itemStack : iterable) {
            int j = EnchantmentHelper.getItemEnchantmentLevel(enchantment, itemStack);
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int processProjectileCount(ServerLevel world, ItemStack stack, Entity user, int baseProjectileCount) {
        MutableFloat mutableFloat = new MutableFloat((float)baseProjectileCount);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyProjectileCount(world, level, stack, user, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float processProjectileSpread(ServerLevel world, ItemStack stack, Entity user, float baseProjectileSpread) {
        MutableFloat mutableFloat = new MutableFloat(baseProjectileSpread);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyProjectileSpread(world, level, stack, user, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static int getPiercingCount(ServerLevel world, ItemStack weaponStack, ItemStack projectileStack) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(weaponStack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyPiercingCount(world, level, projectileStack, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static void onProjectileSpawned(ServerLevel world, ItemStack weaponStack, Projectile projectile, Consumer<Item> onBreak) {
        LivingEntity livingEntity;
        Entity entity = projectile.getOwner();
        LivingEntity livingEntity2 = entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(weaponStack, null, livingEntity2, onBreak);
        EnchantmentHelper.runIterationOnItem(weaponStack, (enchantment, level) -> ((Enchantment)enchantment.value()).onProjectileSpawned(world, level, enchantedItemInUse, projectile));
    }

    public static void onHitBlock(ServerLevel world, ItemStack stack, @Nullable LivingEntity user, Entity enchantedEntity, @Nullable EquipmentSlot slot, Vec3 pos, BlockState state, Consumer<Item> onBreak) {
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(stack, slot, user, onBreak);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).onHitBlock(world, level, enchantedItemInUse, enchantedEntity, pos, state));
    }

    public static int modifyDurabilityToRepairFromXp(ServerLevel world, ItemStack stack, int baseRepairWithXp) {
        MutableFloat mutableFloat = new MutableFloat((float)baseRepairWithXp);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyDurabilityToRepairFromXp(world, level, stack, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float processEquipmentDropChance(ServerLevel world, LivingEntity attacker, DamageSource damageSource, float baseEquipmentDropChance) {
        MutableFloat mutableFloat = new MutableFloat(baseEquipmentDropChance);
        RandomSource randomSource = attacker.getRandom();
        EnchantmentHelper.runIterationOnEquipment(attacker, (enchantment, level, context) -> {
            LootContext lootContext = Enchantment.damageContext(world, level, attacker, damageSource);
            ((Enchantment)enchantment.value()).getEffects(EnchantmentEffectComponents.EQUIPMENT_DROPS).forEach(effect -> {
                if (effect.enchanted() == EnchantmentTarget.VICTIM && effect.affected() == EnchantmentTarget.VICTIM && effect.matches(lootContext)) {
                    mutableFloat.setValue(((EnchantmentValueEffect)effect.effect()).process(level, randomSource, mutableFloat.floatValue()));
                }
            });
        });
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EnchantmentHelper.runIterationOnEquipment(livingEntity, (enchantment, level, context) -> {
                LootContext lootContext = Enchantment.damageContext(world, level, attacker, damageSource);
                ((Enchantment)enchantment.value()).getEffects(EnchantmentEffectComponents.EQUIPMENT_DROPS).forEach(effect -> {
                    if (effect.enchanted() == EnchantmentTarget.ATTACKER && effect.affected() == EnchantmentTarget.VICTIM && effect.matches(lootContext)) {
                        mutableFloat.setValue(((EnchantmentValueEffect)effect.effect()).process(level, randomSource, mutableFloat.floatValue()));
                    }
                });
            });
        }
        return mutableFloat.floatValue();
    }

    public static void forEachModifier(ItemStack stack, EquipmentSlotGroup slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributeModifierConsumer) {
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).getEffects(EnchantmentEffectComponents.ATTRIBUTES).forEach(effect -> {
            if (((Enchantment)enchantment.value()).definition().slots().contains(slot)) {
                attributeModifierConsumer.accept(effect.attribute(), effect.getModifier(level, slot));
            }
        }));
    }

    public static void forEachModifier(ItemStack stack, EquipmentSlot slot, BiConsumer<Holder<Attribute>, AttributeModifier> attributeModifierConsumer) {
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).getEffects(EnchantmentEffectComponents.ATTRIBUTES).forEach(effect -> {
            if (((Enchantment)enchantment.value()).matchingSlot(slot)) {
                attributeModifierConsumer.accept(effect.attribute(), effect.getModifier(level, slot));
            }
        }));
    }

    public static int getFishingLuckBonus(ServerLevel world, ItemStack stack, Entity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyFishingLuckBonus(world, level, stack, user, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float getFishingTimeReduction(ServerLevel world, ItemStack stack, Entity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyFishingTimeReduction(world, level, stack, user, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static int getTridentReturnToOwnerAcceleration(ServerLevel world, ItemStack stack, Entity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyTridentReturnToOwnerAcceleration(world, level, stack, user, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float modifyCrossbowChargingTime(ItemStack stack, LivingEntity user, float baseCrossbowChargeTime) {
        MutableFloat mutableFloat = new MutableFloat(baseCrossbowChargeTime);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyCrossbowChargeTime(user.getRandom(), level, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static float getTridentSpinAttackStrength(ItemStack stack, LivingEntity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyTridentSpinAttackStrength(user.getRandom(), level, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static boolean hasTag(ItemStack stack, TagKey<Enchantment> tag) {
        ItemEnchantments itemEnchantments = stack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.entrySet()) {
            Holder holder = (Holder)entry.getKey();
            if (!holder.is(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean has(ItemStack stack, DataComponentType<?> componentType) {
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> {
            if (((Enchantment)enchantment.value()).effects().has(componentType)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.booleanValue();
    }

    public static <T> Optional<T> pickHighestLevel(ItemStack stack, DataComponentType<List<T>> componentType) {
        Pair<List<T>, Integer> pair = EnchantmentHelper.getHighestLevel(stack, componentType);
        if (pair != null) {
            List list = (List)pair.getFirst();
            int i = (Integer)pair.getSecond();
            return Optional.of(list.get(Math.min(i, list.size()) - 1));
        }
        return Optional.empty();
    }

    @Nullable
    public static <T> Pair<T, Integer> getHighestLevel(ItemStack stack, DataComponentType<T> componentType) {
        MutableObject mutableObject = new MutableObject();
        EnchantmentHelper.runIterationOnItem(stack, (enchantment, level) -> {
            Object object;
            if ((mutableObject.getValue() == null || (Integer)((Pair)mutableObject.getValue()).getSecond() < level) && (object = ((Enchantment)enchantment.value()).effects().get(componentType)) != null) {
                mutableObject.setValue((Object)Pair.of(object, (Object)level));
            }
        });
        return (Pair)mutableObject.getValue();
    }

    public static Optional<EnchantedItemInUse> getRandomItemWith(DataComponentType<?> componentType, LivingEntity entity, Predicate<ItemStack> stackPredicate) {
        ArrayList<EnchantedItemInUse> list = new ArrayList<EnchantedItemInUse>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            ItemStack itemStack = entity.getItemBySlot(equipmentSlot);
            if (!stackPredicate.test(itemStack)) continue;
            ItemEnchantments itemEnchantments = itemStack.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (!((Enchantment)holder.value()).effects().has(componentType) || !((Enchantment)holder.value()).matchingSlot(equipmentSlot)) continue;
                list.add(new EnchantedItemInUse(itemStack, equipmentSlot, entity));
            }
        }
        return Util.getRandomSafe(list, entity.getRandom());
    }

    public static int getEnchantmentCost(RandomSource random, int slotIndex, int bookshelfCount, ItemStack stack) {
        Enchantable enchantable = stack.get(DataComponents.ENCHANTABLE);
        if (enchantable == null) {
            return 0;
        }
        if (bookshelfCount > 15) {
            bookshelfCount = 15;
        }
        int i = random.nextInt(8) + 1 + (bookshelfCount >> 1) + random.nextInt(bookshelfCount + 1);
        if (slotIndex == 0) {
            return Math.max(i / 3, 1);
        }
        if (slotIndex == 1) {
            return i * 2 / 3 + 1;
        }
        return Math.max(i, bookshelfCount * 2);
    }

    public static ItemStack enchantItem(RandomSource random, ItemStack stack, int level, RegistryAccess dynamicRegistryManager, Optional<? extends HolderSet<Enchantment>> enchantments) {
        return EnchantmentHelper.enchantItem(random, stack, level, enchantments.map(HolderSet::stream).orElseGet(() -> dynamicRegistryManager.lookupOrThrow(Registries.ENCHANTMENT).listElements().map(reference -> reference)));
    }

    public static ItemStack enchantItem(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments) {
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(random, stack, level, possibleEnchantments);
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance enchantmentInstance : list) {
            stack.enchant(enchantmentInstance.enchantment, enchantmentInstance.level);
        }
        return stack;
    }

    public static List<EnchantmentInstance> selectEnchantment(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        Enchantable enchantable = stack.get(DataComponents.ENCHANTABLE);
        if (enchantable == null) {
            return list;
        }
        level += 1 + random.nextInt(enchantable.value() / 4 + 1) + random.nextInt(enchantable.value() / 4 + 1);
        float f = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> list2 = EnchantmentHelper.getAvailableEnchantmentResults(level = Mth.clamp(Math.round((float)level + (float)level * f), 1, Integer.MAX_VALUE), stack, possibleEnchantments);
        if (!list2.isEmpty()) {
            WeightedRandom.getRandomItem(random, list2).ifPresent(list::add);
            while (random.nextInt(50) <= level) {
                if (!list.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments(list2, (EnchantmentInstance)Util.lastOf(list));
                }
                if (list2.isEmpty()) break;
                WeightedRandom.getRandomItem(random, list2).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> possibleEntries, EnchantmentInstance pickedEntry) {
        possibleEntries.removeIf(entry -> !Enchantment.areCompatible(enchantmentInstance.enchantment, entry.enchantment));
    }

    public static boolean isEnchantmentCompatible(Collection<Holder<Enchantment>> existing, Holder<Enchantment> candidate) {
        for (Holder<Enchantment> holder : existing) {
            if (Enchantment.areCompatible(holder, candidate)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(int level, ItemStack stack, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        boolean bl = stack.is(Items.BOOK);
        possibleEnchantments.filter(enchantment -> ((Enchantment)enchantment.value()).isPrimaryItem(stack) || bl).forEach(enchantmentx -> {
            Enchantment enchantment = (Enchantment)enchantmentx.value();
            for (int j = enchantment.getMaxLevel(); j >= enchantment.getMinLevel(); --j) {
                if (level < enchantment.getMinCost(j) || level > enchantment.getMaxCost(j)) continue;
                list.add(new EnchantmentInstance((Holder<Enchantment>)enchantmentx, j));
                break;
            }
        });
        return list;
    }

    public static void enchantItemFromProvider(ItemStack stack, RegistryAccess registryManager, ResourceKey<EnchantmentProvider> providerKey, DifficultyInstance localDifficulty, RandomSource random) {
        EnchantmentProvider enchantmentProvider = registryManager.lookupOrThrow(Registries.ENCHANTMENT_PROVIDER).getValue(providerKey);
        if (enchantmentProvider != null) {
            EnchantmentHelper.updateEnchantments(stack, componentBuilder -> enchantmentProvider.enchant(stack, (ItemEnchantments.Mutable)componentBuilder, random, localDifficulty));
        }
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Holder<Enchantment> var1, int var2);
    }

    @FunctionalInterface
    static interface EnchantmentInSlotVisitor {
        public void accept(Holder<Enchantment> var1, int var2, EnchantedItemInUse var3);
    }
}

