/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.equipment.EquipmentModel;

public interface EquipmentModels {
    public static final ResourceLocation LEATHER = ResourceLocation.withDefaultNamespace("leather");
    public static final ResourceLocation CHAINMAIL = ResourceLocation.withDefaultNamespace("chainmail");
    public static final ResourceLocation IRON = ResourceLocation.withDefaultNamespace("iron");
    public static final ResourceLocation GOLD = ResourceLocation.withDefaultNamespace("gold");
    public static final ResourceLocation DIAMOND = ResourceLocation.withDefaultNamespace("diamond");
    public static final ResourceLocation TURTLE_SCUTE = ResourceLocation.withDefaultNamespace("turtle_scute");
    public static final ResourceLocation NETHERITE = ResourceLocation.withDefaultNamespace("netherite");
    public static final ResourceLocation ARMADILLO_SCUTE = ResourceLocation.withDefaultNamespace("armadillo_scute");
    public static final ResourceLocation ELYTRA = ResourceLocation.withDefaultNamespace("elytra");
    public static final Map<DyeColor, ResourceLocation> CARPETS = Util.makeEnumMap(DyeColor.class, color -> ResourceLocation.withDefaultNamespace(color.getSerializedName() + "_carpet"));
    public static final ResourceLocation TRADER_LLAMA = ResourceLocation.withDefaultNamespace("trader_llama");

    public static void bootstrap(BiConsumer<ResourceLocation, EquipmentModel> equipmentModelBiConsumer) {
        equipmentModelBiConsumer.accept(LEATHER, EquipmentModel.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather"), true).addHumanoidLayers(ResourceLocation.withDefaultNamespace("leather_overlay"), false).addLayers(EquipmentModel.LayerType.HORSE_BODY, EquipmentModel.Layer.leatherDyeable(ResourceLocation.withDefaultNamespace("leather"), true)).build());
        equipmentModelBiConsumer.accept(CHAINMAIL, EquipmentModels.onlyHumanoid("chainmail"));
        equipmentModelBiConsumer.accept(IRON, EquipmentModels.humanoidAndHorse("iron"));
        equipmentModelBiConsumer.accept(GOLD, EquipmentModels.humanoidAndHorse("gold"));
        equipmentModelBiConsumer.accept(DIAMOND, EquipmentModels.humanoidAndHorse("diamond"));
        equipmentModelBiConsumer.accept(TURTLE_SCUTE, EquipmentModel.builder().addMainHumanoidLayer(ResourceLocation.withDefaultNamespace("turtle_scute"), false).build());
        equipmentModelBiConsumer.accept(NETHERITE, EquipmentModels.onlyHumanoid("netherite"));
        equipmentModelBiConsumer.accept(ARMADILLO_SCUTE, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.WOLF_BODY, EquipmentModel.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace("armadillo_scute"), false)).addLayers(EquipmentModel.LayerType.WOLF_BODY, EquipmentModel.Layer.onlyIfDyed(ResourceLocation.withDefaultNamespace("armadillo_scute_overlay"), true)).build());
        equipmentModelBiConsumer.accept(ELYTRA, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.WINGS, new EquipmentModel.Layer(ResourceLocation.withDefaultNamespace("elytra"), Optional.empty(), true)).build());
        for (Map.Entry<DyeColor, ResourceLocation> entry : CARPETS.entrySet()) {
            DyeColor dyeColor = entry.getKey();
            ResourceLocation resourceLocation = entry.getValue();
            equipmentModelBiConsumer.accept(resourceLocation, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.LLAMA_BODY, new EquipmentModel.Layer(ResourceLocation.withDefaultNamespace(dyeColor.getSerializedName()))).build());
        }
        equipmentModelBiConsumer.accept(TRADER_LLAMA, EquipmentModel.builder().addLayers(EquipmentModel.LayerType.LLAMA_BODY, new EquipmentModel.Layer(ResourceLocation.withDefaultNamespace("trader_llama"))).build());
    }

    private static EquipmentModel onlyHumanoid(String path) {
        return EquipmentModel.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace(path)).build();
    }

    private static EquipmentModel humanoidAndHorse(String path) {
        return EquipmentModel.builder().addHumanoidLayers(ResourceLocation.withDefaultNamespace(path)).addLayers(EquipmentModel.LayerType.HORSE_BODY, EquipmentModel.Layer.leatherDyeable(ResourceLocation.withDefaultNamespace(path), false)).build();
    }
}

