/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.GameRule;
import org.slf4j.Logger;

public class GameRules {
    private static final boolean DISABLE_LIMITS = Boolean.getBoolean("paper.disableGameRuleLimits");
    public static final int DEFAULT_RANDOM_TICK_SPEED = 3;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Key<?>, Type<?>> GAME_RULE_TYPES = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.id));
    public static final Key<BooleanValue> RULE_DOFIRETICK = GameRules.register("doFireTick", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOBGRIEFING = GameRules.register("mobGriefing", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_KEEPINVENTORY = GameRules.register("keepInventory", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOMOBSPAWNING = GameRules.register("doMobSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOMOBLOOT = GameRules.register("doMobLoot", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_PROJECTILESCANBREAKBLOCKS = GameRules.register("projectilesCanBreakBlocks", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOBLOCKDROPS = GameRules.register("doTileDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DOENTITYDROPS = GameRules.register("doEntityDrops", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_COMMANDBLOCKOUTPUT = GameRules.register("commandBlockOutput", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_NATURAL_REGENERATION = GameRules.register("naturalRegeneration", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DAYLIGHT = GameRules.register("doDaylightCycle", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LOGADMINCOMMANDS = GameRules.register("logAdminCommands", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_SHOWDEATHMESSAGES = GameRules.register("showDeathMessages", Category.CHAT, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_RANDOMTICKING = GameRules.register("randomTickSpeed", Category.UPDATES, IntegerValue.create(3));
    public static final Key<BooleanValue> RULE_SENDCOMMANDFEEDBACK = GameRules.register("sendCommandFeedback", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_REDUCEDDEBUGINFO = GameRules.register("reducedDebugInfo", Category.MISC, BooleanValue.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        int i = gamerules_gameruleboolean.get() ? 22 : 23;
        for (ServerPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new ClientboundEntityEventPacket(entityplayer, (byte)i));
        }
    }));
    public static final Key<BooleanValue> RULE_SPECTATORSGENERATECHUNKS = GameRules.register("spectatorsGenerateChunks", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_SPAWN_RADIUS = GameRules.register("spawnRadius", Category.PLAYER, IntegerValue.create(10));
    public static final Key<BooleanValue> RULE_DISABLE_PLAYER_MOVEMENT_CHECK = GameRules.register("disablePlayerMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DISABLE_ELYTRA_MOVEMENT_CHECK = GameRules.register("disableElytraMovementCheck", Category.PLAYER, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_MAX_ENTITY_CRAMMING = GameRules.register("maxEntityCramming", Category.MOBS, IntegerValue.create(24));
    public static final Key<BooleanValue> RULE_WEATHER_CYCLE = GameRules.register("doWeatherCycle", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LIMITED_CRAFTING = GameRules.register("doLimitedCrafting", Category.PLAYER, BooleanValue.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (ServerPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LIMITED_CRAFTING, gamerules_gameruleboolean.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_CHAIN_LENGTH = GameRules.register("maxCommandChainLength", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_MAX_COMMAND_FORK_COUNT = GameRules.register("maxCommandForkCount", Category.MISC, IntegerValue.create(65536));
    public static final Key<IntegerValue> RULE_COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.register("commandModificationBlockLimit", Category.MISC, IntegerValue.create(32768));
    public static final Key<BooleanValue> RULE_ANNOUNCE_ADVANCEMENTS = GameRules.register("announceAdvancements", Category.CHAT, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DISABLE_RAIDS = GameRules.register("disableRaids", Category.MOBS, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_DOINSOMNIA = GameRules.register("doInsomnia", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_IMMEDIATE_RESPAWN = GameRules.register("doImmediateRespawn", Category.PLAYER, BooleanValue.create(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (ServerPlayer entityplayer : minecraftserver.players()) {
            entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, gamerules_gameruleboolean.get() ? 1.0f : 0.0f));
        }
    }));
    public static final Key<IntegerValue> RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.register("playersNetherPortalDefaultDelay", Category.PLAYER, IntegerValue.create(80));
    public static final Key<IntegerValue> RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.register("playersNetherPortalCreativeDelay", Category.PLAYER, IntegerValue.create(0));
    public static final Key<BooleanValue> RULE_DROWNING_DAMAGE = GameRules.register("drowningDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FALL_DAMAGE = GameRules.register("fallDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FIRE_DAMAGE = GameRules.register("fireDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FREEZE_DAMAGE = GameRules.register("freezeDamage", Category.PLAYER, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_PATROL_SPAWNING = GameRules.register("doPatrolSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_TRADER_SPAWNING = GameRules.register("doTraderSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_WARDEN_SPAWNING = GameRules.register("doWardenSpawning", Category.SPAWNING, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_FORGIVE_DEAD_PLAYERS = GameRules.register("forgiveDeadPlayers", Category.MOBS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_UNIVERSAL_ANGER = GameRules.register("universalAnger", Category.MOBS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_PLAYERS_SLEEPING_PERCENTAGE = GameRules.register("playersSleepingPercentage", Category.PLAYER, IntegerValue.create(100));
    public static final Key<BooleanValue> RULE_BLOCK_EXPLOSION_DROP_DECAY = GameRules.register("blockExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_MOB_EXPLOSION_DROP_DECAY = GameRules.register("mobExplosionDropDecay", Category.DROPS, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_TNT_EXPLOSION_DROP_DECAY = GameRules.register("tntExplosionDropDecay", Category.DROPS, BooleanValue.create(false));
    public static final Key<IntegerValue> RULE_SNOW_ACCUMULATION_HEIGHT = GameRules.register("snowAccumulationHeight", Category.UPDATES, IntegerValue.create(1));
    public static final Key<BooleanValue> RULE_WATER_SOURCE_CONVERSION = GameRules.register("waterSourceConversion", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_LAVA_SOURCE_CONVERSION = GameRules.register("lavaSourceConversion", Category.UPDATES, BooleanValue.create(false));
    public static final Key<BooleanValue> RULE_GLOBAL_SOUND_EVENTS = GameRules.register("globalSoundEvents", Category.MISC, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_DO_VINES_SPREAD = GameRules.register("doVinesSpread", Category.UPDATES, BooleanValue.create(true));
    public static final Key<BooleanValue> RULE_ENDER_PEARLS_VANISH_ON_DEATH = GameRules.register("enderPearlsVanishOnDeath", Category.PLAYER, BooleanValue.create(true));
    public static final Key<IntegerValue> RULE_MINECART_MAX_SPEED = GameRules.register("minecartMaxSpeed", Category.MISC, IntegerValue.create(8, 1, GameRules.limit(1000, Integer.MAX_VALUE), FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS), (minecraftserver, gamerules_gameruleint) -> {}));
    public static final Key<IntegerValue> RULE_SPAWN_CHUNK_RADIUS = GameRules.register("spawnChunkRadius", Category.MISC, IntegerValue.create(2, 0, GameRules.limit(32, Integer.MAX_VALUE), FeatureFlagSet.of(), (minecraftserver, gamerules_gameruleint) -> {
        ServerLevel worldserver = minecraftserver;
        worldserver.setDefaultSpawnPos(worldserver.getSharedSpawnPos(), worldserver.getSharedSpawnAngle());
    }));
    private final Map<Key<?>, Value<?>> rules;
    private final FeatureFlagSet enabledFeatures;
    private final Value<?>[] gameruleArray;

    private static int limit(int limit, int unlimited) {
        return DISABLE_LIMITS ? unlimited : limit;
    }

    private static <T extends Value<T>> Key<T> register(String name, Category category, Type<T> type) {
        Key gamerules_gamerulekey = new Key(name, category);
        Type<T> gamerules_gameruledefinition1 = GAME_RULE_TYPES.put(gamerules_gamerulekey, type);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + name);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(FeatureFlagSet enabledFeatures, DynamicLike<?> values) {
        this(enabledFeatures);
        this.loadFromTag(values);
    }

    public GameRules(FeatureFlagSet enabledFeatures) {
        this((Map)GameRules.availableRules(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Type)entry.getValue()).createRule())), enabledFeatures);
    }

    private static Stream<Map.Entry<Key<?>, Type<?>>> availableRules(FeatureFlagSet enabledFeatures) {
        return GAME_RULE_TYPES.entrySet().stream().filter(entry -> ((Type)entry.getValue()).requiredFeatures.isSubsetOf(enabledFeatures));
    }

    private GameRules(Map<Key<?>, Value<?>> rules, FeatureFlagSet enabledFeatures) {
        this.rules = rules;
        this.enabledFeatures = enabledFeatures;
        int arraySize = Key.lastGameRuleIndex + 1;
        Value[] values = new Value[arraySize];
        for (Map.Entry<Key<?>, Value<?>> entry : rules.entrySet()) {
            values[entry.getKey().gameRuleIndex] = entry.getValue();
        }
        this.gameruleArray = values;
    }

    public <T extends Value<T>> T getRule(Key<T> key) {
        Value<?> t0;
        Value<?> value = t0 = key == null ? null : this.gameruleArray[key.gameRuleIndex];
        if (t0 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return (T)t0;
    }

    public CompoundTag createTag() {
        CompoundTag nbttagcompound = new CompoundTag();
        this.rules.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.putString(gamerules_gamerulekey.id, gamerules_gamerulevalue.serialize()));
        return nbttagcompound;
    }

    private void loadFromTag(DynamicLike<?> values) {
        this.rules.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            DataResult dataresult = values.get(gamerules_gamerulekey.id).asString();
            Objects.requireNonNull(gamerules_gamerulevalue);
            dataresult.ifSuccess(gamerules_gamerulevalue::deserialize);
        });
    }

    public GameRules copy(FeatureFlagSet enabledFeatures) {
        return new GameRules((Map)GameRules.availableRules(enabledFeatures).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.rules.containsKey(entry.getKey()) ? this.rules.get(entry.getKey()) : ((Type)entry.getValue()).createRule())), enabledFeatures);
    }

    public void visitGameRuleTypes(GameRuleTypeVisitor visitor) {
        GAME_RULE_TYPES.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> this.callVisitorCap(visitor, (Key<?>)gamerules_gamerulekey, (Type<?>)gamerules_gameruledefinition));
    }

    private <T extends Value<T>> void callVisitorCap(GameRuleTypeVisitor visitor, Key<?> key, Type<?> type) {
        if (type.requiredFeatures.isSubsetOf(this.enabledFeatures)) {
            visitor.visit(key, type);
            type.callVisitor(visitor, key);
        }
    }

    public void assignFrom(GameRules gamerules, @Nullable ServerLevel minecraftserver) {
        gamerules.rules.keySet().forEach(gamerules_gamerulekey -> this.assignCap((Key)gamerules_gamerulekey, gamerules, minecraftserver));
    }

    private <T extends Value<T>> void assignCap(Key<T> gamerules_gamerulekey, GameRules gamerules, @Nullable ServerLevel minecraftserver) {
        T t0 = gamerules.getRule(gamerules_gamerulekey);
        ((Value)this.getRule(gamerules_gamerulekey)).setFrom(t0, minecraftserver);
    }

    public boolean getBoolean(Key<BooleanValue> rule) {
        return this.getRule(rule).get();
    }

    public int getInt(Key<IntegerValue> rule) {
        return this.getRule(rule).get();
    }

    public static final class Key<T extends Value<T>> {
        public static int lastGameRuleIndex = 0;
        public final int gameRuleIndex = lastGameRuleIndex++;
        final String id;
        private final Category category;

        public Key(String name, Category category) {
            this.id = name;
            this.category = category;
        }

        public String toString() {
            return this.id;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof Key && ((Key)object).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String getId() {
            return this.id;
        }

        public String getDescriptionId() {
            return "gamerule." + this.id;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    public static enum Category {
        PLAYER("gamerule.category.player"),
        MOBS("gamerule.category.mobs"),
        SPAWNING("gamerule.category.spawning"),
        DROPS("gamerule.category.drops"),
        UPDATES("gamerule.category.updates"),
        CHAT("gamerule.category.chat"),
        MISC("gamerule.category.misc");

        private final String descriptionId;

        private Category(String s) {
            this.descriptionId = s;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public static class Type<T extends Value<T>> {
        final Supplier<ArgumentType<?>> argument;
        private final Function<Type<T>, T> constructor;
        final BiConsumer<ServerLevel, T> callback;
        private final VisitorCaller<T> visitorCaller;
        final FeatureFlagSet requiredFeatures;

        Type(Supplier<ArgumentType<?>> argumentType, Function<Type<T>, T> ruleFactory, BiConsumer<ServerLevel, T> changeCallback, VisitorCaller<T> ruleAcceptor, FeatureFlagSet requiredFeatures) {
            this.argument = argumentType;
            this.constructor = ruleFactory;
            this.callback = changeCallback;
            this.visitorCaller = ruleAcceptor;
            this.requiredFeatures = requiredFeatures;
        }

        public RequiredArgumentBuilder<CommandSourceStack, ?> createArgument(String name) {
            return Commands.argument(name, this.argument.get());
        }

        public T createRule() {
            return (T)((Value)this.constructor.apply(this));
        }

        public void callVisitor(GameRuleTypeVisitor consumer, Key<T> key) {
            this.visitorCaller.call(consumer, key, this);
        }

        public FeatureFlagSet requiredFeatures() {
            return this.requiredFeatures;
        }
    }

    public static abstract class Value<T extends Value<T>> {
        protected final Type<T> type;

        public Value(Type<T> type) {
            this.type = type;
        }

        protected abstract void updateFromArgument(CommandContext<CommandSourceStack> var1, String var2, Key<T> var3);

        public void setFromArgument(CommandContext<CommandSourceStack> context, String name, Key<T> gameRuleKey) {
            this.updateFromArgument(context, name, gameRuleKey);
            this.onChanged(((CommandSourceStack)context.getSource()).getLevel());
        }

        public void onChanged(@Nullable ServerLevel minecraftserver) {
            if (minecraftserver != null) {
                this.type.callback.accept(minecraftserver, (ServerLevel)this.getSelf());
            }
        }

        public abstract void deserialize(String var1);

        public abstract String serialize();

        public String toString() {
            return this.serialize();
        }

        public abstract int getCommandResult();

        protected abstract T getSelf();

        protected abstract T copy();

        public abstract void setFrom(T var1, @Nullable ServerLevel var2);
    }

    public static interface GameRuleTypeVisitor {
        default public <T extends Value<T>> void visit(Key<T> key, Type<T> type) {
        }

        default public void visitBoolean(Key<BooleanValue> key, Type<BooleanValue> type) {
        }

        default public void visitInteger(Key<IntegerValue> key, Type<IntegerValue> type) {
        }
    }

    public static class BooleanValue
    extends Value<BooleanValue> {
        private boolean value;

        static Type<BooleanValue> create(boolean initialValue, BiConsumer<ServerLevel, BooleanValue> changeCallback) {
            return new Type<BooleanValue>(BoolArgumentType::bool, gamerules_gameruledefinition -> new BooleanValue((Type<BooleanValue>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleTypeVisitor::visitBoolean, FeatureFlagSet.of());
        }

        static Type<BooleanValue> create(boolean initialValue) {
            return BooleanValue.create(initialValue, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public BooleanValue(Type<BooleanValue> type, boolean initialValue) {
            super(type);
            this.value = initialValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name, Key<BooleanValue> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandSourceStack)context.getSource()).getBukkitWorld(), ((CommandSourceStack)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(BoolArgumentType.getBool(context, (String)name)));
            if (!event.callEvent()) {
                return;
            }
            this.value = Boolean.parseBoolean(event.getValue());
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean flag, @Nullable ServerLevel minecraftserver) {
            this.value = flag;
            this.onChanged(minecraftserver);
        }

        @Override
        public String serialize() {
            return Boolean.toString(this.value);
        }

        @Override
        public void deserialize(String value) {
            this.value = Boolean.parseBoolean(value);
        }

        @Override
        public int getCommandResult() {
            return this.value ? 1 : 0;
        }

        @Override
        protected BooleanValue getSelf() {
            return this;
        }

        @Override
        protected BooleanValue copy() {
            return new BooleanValue(this.type, this.value);
        }

        @Override
        public void setFrom(BooleanValue gamerules_gameruleboolean, @Nullable ServerLevel minecraftserver) {
            this.value = gamerules_gameruleboolean.value;
            this.onChanged(minecraftserver);
        }
    }

    public static class IntegerValue
    extends Value<IntegerValue> {
        private int value;

        private static Type<IntegerValue> create(int initialValue, BiConsumer<ServerLevel, IntegerValue> changeCallback) {
            return new Type<IntegerValue>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new IntegerValue((Type<IntegerValue>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleTypeVisitor::visitInteger, FeatureFlagSet.of());
        }

        static Type<IntegerValue> create(int initialValue, int min, int max, FeatureFlagSet requiredFeatures, BiConsumer<ServerLevel, IntegerValue> changeCallback) {
            return new Type<IntegerValue>(() -> IntegerArgumentType.integer((int)min, (int)max), gamerules_gameruledefinition -> new IntegerValue((Type<IntegerValue>)gamerules_gameruledefinition, initialValue), changeCallback, GameRuleTypeVisitor::visitInteger, requiredFeatures);
        }

        static Type<IntegerValue> create(int initialValue) {
            return IntegerValue.create(initialValue, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public IntegerValue(Type<IntegerValue> rule, int initialValue) {
            super(rule);
            this.value = initialValue;
        }

        @Override
        protected void updateFromArgument(CommandContext<CommandSourceStack> context, String name, Key<IntegerValue> gameRuleKey) {
            WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent(((CommandSourceStack)context.getSource()).getBukkitWorld(), ((CommandSourceStack)context.getSource()).getBukkitSender(), GameRule.getByName((String)gameRuleKey.toString()), String.valueOf(IntegerArgumentType.getInteger(context, (String)name)));
            if (!event.callEvent()) {
                return;
            }
            this.value = Integer.parseInt(event.getValue());
        }

        public int get() {
            return this.value;
        }

        public void set(int i, @Nullable ServerLevel minecraftserver) {
            this.value = i;
            this.onChanged(minecraftserver);
        }

        @Override
        public String serialize() {
            return Integer.toString(this.value);
        }

        @Override
        public void deserialize(String value) {
            this.value = IntegerValue.safeParse(value);
        }

        public boolean tryDeserialize(String input) {
            try {
                StringReader stringreader = new StringReader(input);
                this.value = (Integer)this.type.argument.get().parse(stringreader);
                return !stringreader.canRead();
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        }

        private static int safeParse(String input) {
            if (!input.isEmpty()) {
                try {
                    return Integer.parseInt(input);
                }
                catch (NumberFormatException numberformatexception) {
                    LOGGER.warn("Failed to parse integer {}", (Object)input);
                }
            }
            return 0;
        }

        @Override
        public int getCommandResult() {
            return this.value;
        }

        @Override
        protected IntegerValue getSelf() {
            return this;
        }

        @Override
        protected IntegerValue copy() {
            return new IntegerValue(this.type, this.value);
        }

        @Override
        public void setFrom(IntegerValue gamerules_gameruleint, @Nullable ServerLevel minecraftserver) {
            this.value = gamerules_gameruleint.value;
            this.onChanged(minecraftserver);
        }
    }

    private static interface VisitorCaller<T extends Value<T>> {
        public void call(GameRuleTypeVisitor var1, Key<T> var2, Type<T> var3);
    }
}

