/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.ExplosionBlockCache;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ServerExplosion
implements Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private static final float LARGE_EXPLOSION_RADIUS = 2.0f;
    private final boolean fire;
    private final Explosion.BlockInteraction blockInteraction;
    private final ServerLevel level;
    private final Vec3 center;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final Map<Player, Vec3> hitPlayers = new HashMap<Player, Vec3>();
    public boolean wasCanceled = false;
    public float yield;
    public boolean excludeSourceFromDamage = true;
    private static final double[] CACHED_RAYS;
    private static final int CHUNK_CACHE_SHIFT = 2;
    private static final int CHUNK_CACHE_MASK = 3;
    private static final int CHUNK_CACHE_WIDTH = 4;
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    private static final Float ZERO_RESISTANCE;
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    private long[] chunkPosCache = null;
    private LevelChunk[] chunkCache = null;
    private ExplosionBlockCache[] directMappedBlockCache;
    private BlockPos.MutableBlockPos mutablePos;

    private ExplosionBlockCache getOrCacheExplosionBlock(int x, int y, int z, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!this.level.isInWorldBounds(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            LevelChunk chunk;
            int chunkCacheKey = x >> 4 & 3 | z >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x >> 4, z >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.level.getChunk(x >> 4, z >> 4);
            }
            BlockState blockState = chunk.moonrise$getBlock(x, y, z);
            FluidState fluidState = blockState.getFluidState();
            Optional<Float> resistance = !calculateResistance ? Optional.empty() : this.damageCalculator.getBlockExplosionResistance(this, this.level, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    private boolean clipsAnything(Vec3 from, Vec3 to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos currPos) {
        double adjX = 1.0E-7 * (from.x - to.x);
        double adjY = 1.0E-7 * (from.y - to.y);
        double adjZ = 1.0E-7 * (from.z - to.z);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.x - adjX;
        double toYAdj = to.y - adjY;
        double toZAdj = to.z - adjZ;
        double fromXAdj = from.x + adjX;
        double fromYAdj = from.y + adjY;
        double fromZAdj = from.z + adjZ;
        int currX = Mth.floor(fromXAdj);
        int currY = Mth.floor(fromYAdj);
        int currZ = Mth.floor(fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - Mth.frac(fromXAdj) : Mth.frac(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - Mth.frac(fromYAdj) : Mth.frac(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - Mth.frac(fromZAdj) : Mth.frac(fromZAdj));
        while (true) {
            BlockState blockState;
            currPos.set(currX, currY, currZ);
            long key = BlockPos.asLong(currX, currY, currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !blockState.moonrise$emptyContextCollisionShape()) {
                VoxelShape collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = blockState.moonrise$getConstantContextCollisionShape();
                    if (collision == null) {
                        collision = blockState.getCollisionShape(this.level, currPos, context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.isEmpty() && collision.clip(from, to, currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    private float getSeenFraction(Vec3 source, Entity target, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos blockPos) {
        AABB boundingBox = target.getBoundingBox();
        double diffX = boundingBox.maxX - boundingBox.minX;
        double diffY = boundingBox.maxY - boundingBox.minY;
        double diffZ = boundingBox.maxZ - boundingBox.minZ;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.minX;
        double offY = boundingBox.minY;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.minZ;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    Vec3 from = new Vec3(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    public ServerExplosion(ServerLevel world, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, Vec3 pos, float power, boolean createFire, Explosion.BlockInteraction destructionType) {
        this.level = world;
        this.source = entity;
        this.radius = (float)Math.max((double)power, 0.0);
        this.center = pos;
        this.fire = createFire;
        this.blockInteraction = destructionType;
        this.damageSource = damageSource == null ? world.damageSources().explosion(this) : damageSource;
        this.damageCalculator = behavior == null ? this.makeDamageCalculator(entity) : behavior;
        this.yield = this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY ? 1.0f / this.radius : 1.0f;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public static float getSeenPercent(Vec3 pos, Entity entity) {
        AABB axisalignedbb = entity.getBoundingBox();
        double d0 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.lerp(d5, axisalignedbb.minX, axisalignedbb.maxX);
                        double d9 = Mth.lerp(d6, axisalignedbb.minY, axisalignedbb.maxY);
                        double d10 = Mth.lerp(d7, axisalignedbb.minZ, axisalignedbb.maxZ);
                        Vec3 vec3d1 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (entity.level().clip(new ClipContext(vec3d1, pos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    @Override
    public float radius() {
        return this.radius;
    }

    @Override
    public Vec3 center() {
        return this.center;
    }

    private List<BlockPos> calculateExplodedPositions() {
        ObjectArrayList ret = new ObjectArrayList();
        Vec3 center = this.center;
        ExplosionBlockCache[] blockCache = this.directMappedBlockCache;
        int blockX = Mth.floor(center.x);
        int blockY = Mth.floor(center.y);
        int blockZ = Mth.floor(center.z);
        long key = BlockPos.asLong(blockX, blockY, blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double currX = center.x;
            double currY = center.y;
            double currZ = center.z;
            double incX = CACHED_RAYS[ray];
            double incY = CACHED_RAYS[ray + 1];
            double incZ = CACHED_RAYS[ray + 2];
            ray += 3;
            float power = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f);
            do {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2;
                long key2;
                if (cachedBlock.key != (key2 = BlockPos.asLong(blockX2 = Mth.floor(currX), blockY2 = Mth.floor(currY), blockZ2 = Mth.floor(currZ))) && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                BlockState iblockdata = cachedBlock.blockState;
                if ((power -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = iblockdata.isDestroyable() && this.damageCalculator.shouldBlockExplode(this, this.level, cachedBlock.immutablePos, cachedBlock.blockState, power);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.fire || !cachedBlock.blockState.isAir())) {
                        PistonMovingBlockEntity blockEntity;
                        BlockEntity extension;
                        ret.add((Object)cachedBlock.immutablePos);
                        if (!GlobalConfiguration.get().unsupportedSettings.allowHeadlessPistons && iblockdata.getBlock() == Blocks.MOVING_PISTON && (extension = this.level.getBlockEntity(cachedBlock.immutablePos)) instanceof PistonMovingBlockEntity && (blockEntity = (PistonMovingBlockEntity)extension).isSourcePiston()) {
                            Direction direction = iblockdata.getValue(DirectionalBlock.FACING);
                            ret.add((Object)cachedBlock.immutablePos.relative(direction.getOpposite()));
                        }
                    }
                }
                currX += incX;
                currY += incY;
                currZ += incZ;
            } while ((power -= 0.22500001f) > 0.0f);
        }
        return ret;
    }

    private void hurtEntities() {
        float f = this.radius * 2.0f;
        int i = Mth.floor(this.center.x - (double)f - 1.0);
        int j = Mth.floor(this.center.x + (double)f + 1.0);
        int k = Mth.floor(this.center.y - (double)f - 1.0);
        int l = Mth.floor(this.center.y + (double)f + 1.0);
        int i1 = Mth.floor(this.center.z - (double)f - 1.0);
        int j1 = Mth.floor(this.center.z + (double)f + 1.0);
        List<Entity> list = this.level.getEntities(this.excludeSourceFromDamage ? this.source : null, new AABB(i, k, i1, j, l, j1), (Predicate<? super Entity>)((com.google.common.base.Predicate)entity -> entity.isAlive() && !entity.isSpectator()));
        for (Entity entity2 : list) {
            Player entityhuman;
            double d6;
            float f2;
            double d3;
            double d2;
            double d1;
            double d4;
            double d0;
            if (entity2.ignoreExplosion(this) || !((d0 = Math.sqrt(entity2.distanceToSqr(this.center)) / (double)f) <= 1.0) || (d4 = Math.sqrt((d1 = entity2.getX() - this.center.x) * d1 + (d2 = (entity2 instanceof PrimedTnt ? entity2.getY() : entity2.getEyeY()) - this.center.y) * d2 + (d3 = entity2.getZ() - this.center.z) * d3)) == 0.0) continue;
            d1 /= d4;
            d2 /= d4;
            d3 /= d4;
            boolean flag = this.damageCalculator.shouldDamageEntity(this, entity2);
            float f1 = this.damageCalculator.getKnockbackMultiplier(entity2);
            float f3 = f2 = !flag && f1 == 0.0f ? 0.0f : this.getBlockDensity(this.center, entity2);
            if (flag) {
                if (entity2 instanceof EnderDragonPart) continue;
                entity2.lastDamageCancelled = false;
                if (entity2 instanceof EnderDragon) {
                    for (EnderDragonPart entityComplexPart : ((EnderDragon)entity2).subEntities) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.hurtServer(this.level, this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity2, f2));
                    }
                } else {
                    entity2.hurtServer(this.level, this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity2, f2));
                }
                if (entity2.lastDamageCancelled) continue;
            }
            double d5 = (1.0 - d0) * (double)f2 * (double)f1;
            if (entity2 instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity2;
                d6 = entity2 instanceof Player && this.level.paperConfig().environment.disableExplosionKnockback ? 0.0 : d5 * (1.0 - entityliving.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                d6 = d5;
            }
            Vec3 vec3d = new Vec3(d1 *= d6, d2 *= d6, d3 *= d6);
            if (entity2 instanceof LivingEntity) {
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity2.getBukkitEntity(), this.source, this.damageSource.getEntity() != null ? this.damageSource.getEntity() : this.source, EntityKnockbackEvent.Cause.EXPLOSION, d6, vec3d);
                vec3d = event.isCancelled() ? Vec3.ZERO : CraftVector.toNMS(event.getKnockback());
            }
            entity2.setDeltaMovement(entity2.getDeltaMovement().add(vec3d));
            if (!(!(entity2 instanceof Player) || (entityhuman = (Player)entity2).isSpectator() || entityhuman.isCreative() && entityhuman.getAbilities().flying || this.level.paperConfig().environment.disableExplosionKnockback)) {
                this.hitPlayers.put(entityhuman, vec3d);
            }
            entity2.onExplosionHit(this.source);
        }
    }

    private void interactWithBlocks(List<BlockPos> positions) {
        List bukkitBlocks;
        ArrayList list1 = new ArrayList();
        Util.shuffle(positions, this.level.random);
        CraftWorld bworld = this.level.getWorld();
        Location location = CraftLocation.toBukkit(this.center, (World)bworld);
        ObjectArrayList blockList = new ObjectArrayList();
        for (int i1 = positions.size() - 1; i1 >= 0; --i1) {
            BlockPos cpos = positions.get(i1);
            org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.getX(), cpos.getY(), cpos.getZ());
            if (bblock.getType().isAir()) continue;
            blockList.add(bblock);
        }
        if (this.source != null) {
            EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this.source, (List<org.bukkit.block.Block>)blockList, this.yield, this.getBlockInteraction());
            this.wasCanceled = event.isCancelled();
            bukkitBlocks = event.blockList();
            this.yield = event.getYield();
        } else {
            org.bukkit.block.Block block = location.getBlock();
            org.bukkit.block.BlockState blockState = this.damageSource.getDirectBlockState() != null ? this.damageSource.getDirectBlockState() : block.getState();
            BlockExplodeEvent event = CraftEventFactory.callBlockExplodeEvent(block, blockState, (List<org.bukkit.block.Block>)blockList, this.yield, this.getBlockInteraction());
            this.wasCanceled = event.isCancelled();
            bukkitBlocks = event.blockList();
            this.yield = event.getYield();
        }
        positions.clear();
        for (org.bukkit.block.Block bblock : bukkitBlocks) {
            BlockPos coords = new BlockPos(bblock.getX(), bblock.getY(), bblock.getZ());
            positions.add(coords);
        }
        if (this.wasCanceled) {
            return;
        }
        for (BlockPos blockposition : positions) {
            BlockState iblockdata = this.level.getBlockState(blockposition);
            Block block = iblockdata.getBlock();
            if (block instanceof TntBlock) {
                BlockPos sourceBlock;
                Entity sourceEntity = this.source == null ? null : this.source;
                BlockPos blockPos = sourceBlock = sourceEntity == null ? BlockPos.containing(this.center) : null;
                if (!CraftEventFactory.callTNTPrimeEvent(this.level, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                    this.level.sendBlockUpdated(blockposition, Blocks.AIR.defaultBlockState(), iblockdata, 3);
                    continue;
                }
            }
            this.level.getBlockState(blockposition).onExplosionHit(this.level, blockposition, this, (itemstack, blockposition1) -> ServerExplosion.addOrAppendStack(list1, itemstack, blockposition1));
        }
        for (StackCollector serverexplosion_a : list1) {
            Block.popResource((Level)this.level, serverexplosion_a.pos, serverexplosion_a.stack);
        }
    }

    private void createFire(List<BlockPos> positions) {
        for (BlockPos blockposition : positions) {
            if (this.level.random.nextInt(3) != 0 || !this.level.getBlockState(blockposition).isAir() || !this.level.getBlockState(blockposition.below()).isSolidRender() || CraftEventFactory.callBlockIgniteEvent((Level)this.level, blockposition, this).isCancelled()) continue;
            this.level.setBlockAndUpdate(blockposition, BaseFireBlock.getState(this.level, blockposition));
        }
    }

    public void explode() {
        if (this.radius < 0.1f) {
            return;
        }
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, ChunkPos.INVALID_CHUNK_POS);
        this.chunkCache = new LevelChunk[16];
        this.directMappedBlockCache = new ExplosionBlockCache[512];
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.level.gameEvent(this.source, GameEvent.EXPLODE, this.center);
        List<BlockPos> list = this.calculateExplodedPositions();
        this.hurtEntities();
        if (this.interactsWithBlocks()) {
            ProfilerFiller gameprofilerfiller = Profiler.get();
            gameprofilerfiller.push("explosion_blocks");
            this.interactWithBlocks(list);
            gameprofilerfiller.pop();
        }
        if (this.fire) {
            this.createFire(list);
        }
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
        this.directMappedBlockCache = null;
        this.mutablePos = null;
    }

    private static void addOrAppendStack(List<StackCollector> droppedItemsOut, ItemStack item, BlockPos pos) {
        if (item.isEmpty()) {
            return;
        }
        Iterator<StackCollector> iterator = droppedItemsOut.iterator();
        do {
            if (!iterator.hasNext()) {
                droppedItemsOut.add(new StackCollector(pos, item));
                return;
            }
            StackCollector serverexplosion_a = iterator.next();
            serverexplosion_a.tryMerge(item);
        } while (!item.isEmpty());
    }

    private boolean interactsWithBlocks() {
        return this.blockInteraction != Explosion.BlockInteraction.KEEP;
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.hitPlayers;
    }

    @Override
    public ServerLevel level() {
        return this.level;
    }

    @Override
    @Nullable
    public LivingEntity getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntity(this.source);
    }

    @Override
    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    @Override
    public Explosion.BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    @Override
    public boolean canTriggerBlocks() {
        return this.blockInteraction != Explosion.BlockInteraction.TRIGGER_BLOCK ? false : (this.source != null && this.source.getType() == EntityType.BREEZE_WIND_CHARGE ? this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) : true);
    }

    @Override
    public boolean shouldAffectBlocklikeEntities() {
        boolean flag2;
        boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        boolean flag1 = this.source == null || !this.source.isInWater();
        boolean bl = flag2 = this.source == null || this.source.getType() != EntityType.BREEZE_WIND_CHARGE && this.source.getType() != EntityType.WIND_CHARGE;
        return flag ? flag1 && flag2 : this.blockInteraction.shouldAffectBlocklikeEntities() && flag1 && flag2;
    }

    public boolean isSmall() {
        return this.radius < 2.0f || !this.interactsWithBlocks();
    }

    private float getBlockDensity(Vec3 vec3d, Entity entity) {
        if (!this.level.paperConfig().environment.optimizeExplosions) {
            return this.getSeenFraction(vec3d, entity, this.directMappedBlockCache, this.mutablePos);
        }
        CacheKey key = new CacheKey(this, entity.getBoundingBox());
        Float blockDensity = this.level.explosionDensityCache.get(key);
        if (blockDensity == null) {
            blockDensity = Float.valueOf(this.getSeenFraction(vec3d, entity, this.directMappedBlockCache, this.mutablePos));
            this.level.explosionDensityCache.put(key, blockDensity);
        }
        return blockDensity.floatValue();
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 15; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double xDir = (float)x / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }

    private static class StackCollector {
        final BlockPos pos;
        ItemStack stack;

        StackCollector(BlockPos pos, ItemStack item) {
            this.pos = pos;
            this.stack = item;
        }

        public void tryMerge(ItemStack other) {
            if (ItemEntity.areMergable(this.stack, other)) {
                this.stack = ItemEntity.merge(this.stack, other, 16);
            }
        }
    }

    static class CacheKey {
        private final Level world;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double minX;
        private final double minY;
        private final double minZ;
        private final double maxX;
        private final double maxY;
        private final double maxZ;

        public CacheKey(Explosion explosion, AABB aabb) {
            this.world = explosion.level();
            this.posX = explosion.center().x;
            this.posY = explosion.center().y;
            this.posZ = explosion.center().z;
            this.minX = aabb.minX;
            this.minY = aabb.minY;
            this.minZ = aabb.minZ;
            this.maxX = aabb.maxX;
            this.maxY = aabb.maxY;
            this.maxZ = aabb.maxZ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (Double.compare(cacheKey.posX, this.posX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posY, this.posY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minY, this.minY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
                return false;
            }
            return this.world.equals(cacheKey.world);
        }

        public int hashCode() {
            int result = this.world.hashCode();
            long temp = Double.doubleToLongBits(this.posX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

