/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public class Climate {
    private static final boolean DEBUG_SLOW_BIOME_SEARCH = false;
    private static final float QUANTIZATION_FACTOR = 10000.0f;
    @VisibleForTesting
    protected static final int PARAMETER_COUNT = 7;

    public static TargetPoint target(float temperatureNoise, float humidityNoise, float continentalnessNoise, float erosionNoise, float depth, float weirdnessNoise) {
        return new TargetPoint(Climate.quantizeCoord(temperatureNoise), Climate.quantizeCoord(humidityNoise), Climate.quantizeCoord(continentalnessNoise), Climate.quantizeCoord(erosionNoise), Climate.quantizeCoord(depth), Climate.quantizeCoord(weirdnessNoise));
    }

    public static ParameterPoint parameters(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        return new ParameterPoint(Parameter.point(temperature), Parameter.point(humidity), Parameter.point(continentalness), Parameter.point(erosion), Parameter.point(depth), Parameter.point(weirdness), Climate.quantizeCoord(offset));
    }

    public static ParameterPoint parameters(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, float offset) {
        return new ParameterPoint(temperature, humidity, continentalness, erosion, depth, weirdness, Climate.quantizeCoord(offset));
    }

    public static long quantizeCoord(float value) {
        return (long)(value * 10000.0f);
    }

    public static float unquantizeCoord(long value) {
        return (float)value / 10000.0f;
    }

    public static Sampler empty() {
        DensityFunction densityFunction = DensityFunctions.zero();
        return new Sampler(densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, List.of());
    }

    public static BlockPos findSpawnPosition(List<ParameterPoint> noises, Sampler sampler) {
        return new SpawnFinder(noises, (Sampler)sampler).result.location();
    }

    public record TargetPoint(long temperature, long humidity, long continentalness, long erosion, long depth, long weirdness) {
        @VisibleForTesting
        protected long[] toParameterArray() {
            return new long[]{this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L};
        }
    }

    public record ParameterPoint(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, long offset) {
        public static final Codec<ParameterPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Parameter.CODEC.fieldOf("temperature").forGetter(parameterPoint -> parameterPoint.temperature), (App)Parameter.CODEC.fieldOf("humidity").forGetter(parameterPoint -> parameterPoint.humidity), (App)Parameter.CODEC.fieldOf("continentalness").forGetter(parameterPoint -> parameterPoint.continentalness), (App)Parameter.CODEC.fieldOf("erosion").forGetter(parameterPoint -> parameterPoint.erosion), (App)Parameter.CODEC.fieldOf("depth").forGetter(parameterPoint -> parameterPoint.depth), (App)Parameter.CODEC.fieldOf("weirdness").forGetter(parameterPoint -> parameterPoint.weirdness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::quantizeCoord, Climate::unquantizeCoord).forGetter(parameterPoint -> parameterPoint.offset)).apply((Applicative)instance, ParameterPoint::new));

        long fitness(TargetPoint point) {
            return Mth.square(this.temperature.distance(point.temperature)) + Mth.square(this.humidity.distance(point.humidity)) + Mth.square(this.continentalness.distance(point.continentalness)) + Mth.square(this.erosion.distance(point.erosion)) + Mth.square(this.depth.distance(point.depth)) + Mth.square(this.weirdness.distance(point.weirdness)) + Mth.square(this.offset);
        }

        protected List<Parameter> parameterSpace() {
            return ImmutableList.of((Object)this.temperature, (Object)this.humidity, (Object)this.continentalness, (Object)this.erosion, (Object)this.depth, (Object)this.weirdness, (Object)new Parameter(this.offset, this.offset));
        }
    }

    public record Parameter(long min, long max) {
        public static final Codec<Parameter> CODEC = ExtraCodecs.intervalCodec(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (min, max) -> {
            if (min.compareTo((Float)max) > 0) {
                return DataResult.error(() -> "Cannon construct interval, min > max (" + min + " > " + max + ")");
            }
            return DataResult.success((Object)new Parameter(Climate.quantizeCoord(min.floatValue()), Climate.quantizeCoord(max.floatValue())));
        }, parameter -> Float.valueOf(Climate.unquantizeCoord(parameter.min())), parameter -> Float.valueOf(Climate.unquantizeCoord(parameter.max())));

        public static Parameter point(float point) {
            return Parameter.span(point, point);
        }

        public static Parameter span(float min, float max) {
            if (min > max) {
                throw new IllegalArgumentException("min > max: " + min + " " + max);
            }
            return new Parameter(Climate.quantizeCoord(min), Climate.quantizeCoord(max));
        }

        public static Parameter span(Parameter min, Parameter max) {
            if (min.min() > max.max()) {
                throw new IllegalArgumentException("min > max: " + String.valueOf(min) + " " + String.valueOf(max));
            }
            return new Parameter(min.min(), max.max());
        }

        @Override
        @Override
        public String toString() {
            return this.min == this.max ? String.format(Locale.ROOT, "%d", this.min) : String.format(Locale.ROOT, "[%d-%d]", this.min, this.max);
        }

        public long distance(long noise) {
            long l = noise - this.max;
            long m = this.min - noise;
            if (l > 0L) {
                return l;
            }
            return Math.max(m, 0L);
        }

        public long distance(Parameter other) {
            long l = other.min() - this.max;
            long m = this.min - other.max();
            if (l > 0L) {
                return l;
            }
            return Math.max(m, 0L);
        }

        public Parameter span(@Nullable Parameter other) {
            return other == null ? this : new Parameter(Math.min(this.min, other.min()), Math.max(this.max, other.max()));
        }
    }

    public record Sampler(DensityFunction temperature, DensityFunction humidity, DensityFunction continentalness, DensityFunction erosion, DensityFunction depth, DensityFunction weirdness, List<ParameterPoint> spawnTarget) {
        public TargetPoint sample(int x, int y, int z) {
            int i = QuartPos.toBlock(x);
            int j = QuartPos.toBlock(y);
            int k = QuartPos.toBlock(z);
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(i, j, k);
            return Climate.target((float)this.temperature.compute(singlePointContext), (float)this.humidity.compute(singlePointContext), (float)this.continentalness.compute(singlePointContext), (float)this.erosion.compute(singlePointContext), (float)this.depth.compute(singlePointContext), (float)this.weirdness.compute(singlePointContext));
        }

        public BlockPos findSpawnPosition() {
            if (this.spawnTarget.isEmpty()) {
                return BlockPos.ZERO;
            }
            return Climate.findSpawnPosition(this.spawnTarget, this);
        }
    }

    static class SpawnFinder {
        private static final long MAX_RADIUS = 2048L;
        Result result;

        SpawnFinder(List<ParameterPoint> noises, Sampler sampler) {
            this.result = SpawnFinder.getSpawnPositionAndFitness(noises, sampler, 0, 0);
            this.radialSearch(noises, sampler, 2048.0f, 512.0f);
            this.radialSearch(noises, sampler, 512.0f, 32.0f);
        }

        private void radialSearch(List<ParameterPoint> noises, Sampler sampler, float maxDistance, float step) {
            float f = 0.0f;
            float g = step;
            BlockPos blockPos = this.result.location();
            while (g <= maxDistance) {
                int j;
                int i = blockPos.getX() + (int)(Math.sin(f) * (double)g);
                Result result = SpawnFinder.getSpawnPositionAndFitness(noises, sampler, i, j = blockPos.getZ() + (int)(Math.cos(f) * (double)g));
                if (result.fitness() < this.result.fitness()) {
                    this.result = result;
                }
                if (!((double)(f += step / g) > Math.PI * 2)) continue;
                f = 0.0f;
                g += step;
            }
        }

        private static Result getSpawnPositionAndFitness(List<ParameterPoint> noises, Sampler sampler, int x, int z) {
            TargetPoint targetPoint = sampler.sample(QuartPos.fromBlock(x), 0, QuartPos.fromBlock(z));
            TargetPoint targetPoint2 = new TargetPoint(targetPoint.temperature(), targetPoint.humidity(), targetPoint.continentalness(), targetPoint.erosion(), 0L, targetPoint.weirdness());
            long l = Long.MAX_VALUE;
            for (ParameterPoint parameterPoint : noises) {
                l = Math.min(l, parameterPoint.fitness(targetPoint2));
            }
            long m = Mth.square((long)x) + Mth.square((long)z);
            long n = l * Mth.square(2048L) + m;
            return new Result(new BlockPos(x, 0, z), n);
        }

        record Result(BlockPos location, long fitness) {
        }
    }

    public static class ParameterList<T> {
        private final List<Pair<ParameterPoint, T>> values;
        private final RTree<T> index;

        public static <T> Codec<ParameterList<T>> codec(MapCodec<T> entryCodec) {
            return ExtraCodecs.nonEmptyList(RecordCodecBuilder.create(instance -> instance.group((App)ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)entryCodec.forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(ParameterList::new, ParameterList::values);
        }

        public ParameterList(List<Pair<ParameterPoint, T>> entries) {
            this.values = entries;
            this.index = RTree.create(entries);
        }

        public List<Pair<ParameterPoint, T>> values() {
            return this.values;
        }

        public T findValue(TargetPoint point) {
            return this.findValueIndex(point);
        }

        @VisibleForTesting
        public T findValueBruteForce(TargetPoint point) {
            Iterator<Pair<ParameterPoint, T>> iterator = this.values().iterator();
            Pair<ParameterPoint, T> pair = iterator.next();
            long l = ((ParameterPoint)pair.getFirst()).fitness(point);
            Object object = pair.getSecond();
            while (iterator.hasNext()) {
                Pair<ParameterPoint, T> pair2 = iterator.next();
                long m = ((ParameterPoint)pair2.getFirst()).fitness(point);
                if (m >= l) continue;
                l = m;
                object = pair2.getSecond();
            }
            return (T)object;
        }

        public T findValueIndex(TargetPoint point) {
            return this.findValueIndex(point, RTree.Node::distance);
        }

        protected T findValueIndex(TargetPoint point, DistanceMetric<T> distanceFunction) {
            return this.index.search(point, distanceFunction);
        }
    }

    protected static final class RTree<T> {
        private static final int CHILDREN_PER_NODE = 6;
        private final Node<T> root;
        private final ThreadLocal<Leaf<T>> lastResult = new ThreadLocal();

        private RTree(Node<T> firstNode) {
            this.root = firstNode;
        }

        public static <T> RTree<T> create(List<Pair<ParameterPoint, T>> entries) {
            if (entries.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int i = ((ParameterPoint)entries.get(0).getFirst()).parameterSpace().size();
            if (i != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + i);
            }
            List list = entries.stream().map(entry -> new Leaf<Object>((ParameterPoint)entry.getFirst(), entry.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new RTree<T>(RTree.build(i, list));
        }

        private static <T> Node<T> build(int parameterNumber, List<? extends Node<T>> subTree) {
            if (subTree.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (subTree.size() == 1) {
                return subTree.get(0);
            }
            if (subTree.size() <= 6) {
                subTree.sort(Comparator.comparingLong(node -> {
                    long l = 0L;
                    for (int j = 0; j < parameterNumber; ++j) {
                        Parameter parameter = node.parameterSpace[j];
                        l += Math.abs((parameter.min() + parameter.max()) / 2L);
                    }
                    return l;
                }));
                return new SubTree(subTree);
            }
            long l = Long.MAX_VALUE;
            int i = -1;
            List<SubTree<T>> list = null;
            for (int j = 0; j < parameterNumber; ++j) {
                RTree.sort(subTree, parameterNumber, j, false);
                List<SubTree<T>> list2 = RTree.bucketize(subTree);
                long m = 0L;
                for (SubTree<T> subTree2 : list2) {
                    m += RTree.cost(subTree2.parameterSpace);
                }
                if (l <= m) continue;
                l = m;
                i = j;
                list = list2;
            }
            RTree.sort(list, parameterNumber, i, true);
            return new SubTree(list.stream().map(node -> RTree.build(parameterNumber, Arrays.asList(node.children))).collect(Collectors.toList()));
        }

        private static <T> void sort(List<? extends Node<T>> subTree, int parameterNumber, int currentParameter, boolean abs) {
            Comparator<Node<Node<T>>> comparator = RTree.comparator(currentParameter, abs);
            for (int i = 1; i < parameterNumber; ++i) {
                comparator = comparator.thenComparing(RTree.comparator((currentParameter + i) % parameterNumber, abs));
            }
            subTree.sort(comparator);
        }

        private static <T> Comparator<Node<T>> comparator(int currentParameter, boolean abs) {
            return Comparator.comparingLong(node -> {
                Parameter parameter = node.parameterSpace[currentParameter];
                long l = (parameter.min() + parameter.max()) / 2L;
                return abs ? Math.abs(l) : l;
            });
        }

        private static <T> List<SubTree<T>> bucketize(List<? extends Node<T>> nodes) {
            ArrayList list = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            int i = (int)Math.pow(6.0, Math.floor(Math.log((double)nodes.size() - 0.01) / Math.log(6.0)));
            for (Node<T> node : nodes) {
                list2.add(node);
                if (list2.size() < i) continue;
                list.add(new SubTree(list2));
                list2 = Lists.newArrayList();
            }
            if (!list2.isEmpty()) {
                list.add(new SubTree(list2));
            }
            return list;
        }

        private static long cost(Parameter[] parameters) {
            long l = 0L;
            for (Parameter parameter : parameters) {
                l += Math.abs(parameter.max() - parameter.min());
            }
            return l;
        }

        static <T> List<Parameter> buildParameterSpace(List<? extends Node<T>> subTree) {
            if (subTree.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int i = 7;
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < 7; ++j) {
                list.add(null);
            }
            for (Node<T> node : subTree) {
                for (int k = 0; k < 7; ++k) {
                    list.set(k, node.parameterSpace[k].span((Parameter)list.get(k)));
                }
            }
            return list;
        }

        public T search(TargetPoint point, DistanceMetric<T> distanceFunction) {
            long[] ls = point.toParameterArray();
            Leaf<T> leaf = this.root.search(ls, this.lastResult.get(), distanceFunction);
            this.lastResult.set(leaf);
            return leaf.value;
        }

        static abstract class Node<T> {
            protected final Parameter[] parameterSpace;

            protected Node(List<Parameter> parameters) {
                this.parameterSpace = parameters.toArray(new Parameter[0]);
            }

            protected abstract Leaf<T> search(long[] var1, @Nullable Leaf<T> var2, DistanceMetric<T> var3);

            protected long distance(long[] otherParameters) {
                long l = 0L;
                for (int i = 0; i < 7; ++i) {
                    l += Mth.square(this.parameterSpace[i].distance(otherParameters[i]));
                }
                return l;
            }

            @Override
            public String toString() {
                return Arrays.toString(this.parameterSpace);
            }
        }

        static final class SubTree<T>
        extends Node<T> {
            final Node<T>[] children;

            protected SubTree(List<? extends Node<T>> subTree) {
                this(RTree.buildParameterSpace(subTree), subTree);
            }

            protected SubTree(List<Parameter> parameters, List<? extends Node<T>> subTree) {
                super(parameters);
                this.children = subTree.toArray(new Node[0]);
            }

            @Override
            @Override
            protected Leaf<T> search(long[] otherParameters, @Nullable Leaf<T> alternative, DistanceMetric<T> distanceFunction) {
                long l = alternative == null ? Long.MAX_VALUE : distanceFunction.distance(alternative, otherParameters);
                Leaf<T> leaf = alternative;
                for (Node<T> node : this.children) {
                    long n;
                    long m = distanceFunction.distance(node, otherParameters);
                    if (l <= m) continue;
                    Leaf<T> leaf2 = node.search(otherParameters, leaf, distanceFunction);
                    long l2 = n = node == leaf2 ? m : distanceFunction.distance(leaf2, otherParameters);
                    if (l <= n) continue;
                    l = n;
                    leaf = leaf2;
                }
                return leaf;
            }
        }

        static final class Leaf<T>
        extends Node<T> {
            final T value;

            Leaf(ParameterPoint parameters, T value) {
                super(parameters.parameterSpace());
                this.value = value;
            }

            @Override
            @Override
            protected Leaf<T> search(long[] otherParameters, @Nullable Leaf<T> alternative, DistanceMetric<T> distanceFunction) {
                return this;
            }
        }
    }

    static interface DistanceMetric<T> {
        public long distance(RTree.Node<T> var1, long[] var2);
    }
}

