/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseRailBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape FLAT_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape HALF_BLOCK_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final boolean isStraight;

    public static boolean isRail(Level world, BlockPos pos) {
        return BaseRailBlock.isRail(world.getBlockState(pos));
    }

    public static boolean isRail(BlockState state) {
        return state.is(BlockTags.RAILS) && state.getBlock() instanceof BaseRailBlock;
    }

    protected BaseRailBlock(boolean forbidCurves, BlockBehaviour.Properties settings) {
        super(settings);
        this.isStraight = forbidCurves;
    }

    protected abstract MapCodec<? extends BaseRailBlock> codec();

    public boolean isStraight() {
        return this.isStraight;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        RailShape railShape = state.is(this) ? state.getValue(this.getShapeProperty()) : null;
        return railShape != null && railShape.isSlope() ? HALF_BLOCK_AABB : FLAT_AABB;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return BaseRailBlock.canSupportRigidBlock(world, pos.below());
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock())) {
            this.updateState(state, world, pos, notify);
        }
    }

    protected BlockState updateState(BlockState state, Level world, BlockPos pos, boolean notify) {
        state = this.updateDir(world, pos, state, true);
        if (this.isStraight) {
            world.neighborChanged(state, pos, this, null, notify);
            state = world.getBlockState(pos);
        }
        return state;
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (!world.isClientSide && world.getBlockState(pos).is(this)) {
            RailShape railShape = state.getValue(this.getShapeProperty());
            if (BaseRailBlock.shouldBeRemoved(pos, world, railShape)) {
                BaseRailBlock.dropResources(state, world, pos);
                world.removeBlock(pos, notify);
            } else {
                this.updateState(state, world, pos, sourceBlock);
            }
        }
    }

    private static boolean shouldBeRemoved(BlockPos pos, Level world, RailShape shape) {
        if (!BaseRailBlock.canSupportRigidBlock(world, pos.below())) {
            return true;
        }
        switch (shape) {
            case ASCENDING_EAST: {
                return !BaseRailBlock.canSupportRigidBlock(world, pos.east());
            }
            case ASCENDING_WEST: {
                return !BaseRailBlock.canSupportRigidBlock(world, pos.west());
            }
            case ASCENDING_NORTH: {
                return !BaseRailBlock.canSupportRigidBlock(world, pos.north());
            }
            case ASCENDING_SOUTH: {
                return !BaseRailBlock.canSupportRigidBlock(world, pos.south());
            }
        }
        return false;
    }

    protected void updateState(BlockState state, Level world, BlockPos pos, Block neighbor) {
    }

    protected BlockState updateDir(Level world, BlockPos pos, BlockState state, boolean forceUpdate) {
        if (world.isClientSide) {
            return state;
        }
        RailShape railShape = state.getValue(this.getShapeProperty());
        return new RailState(world, pos, state).place(world.hasNeighborSignal(pos), forceUpdate, railShape).getState();
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved) {
            super.onRemove(state, world, pos, newState, moved);
            if (state.getValue(this.getShapeProperty()).isSlope()) {
                world.updateNeighborsAt(pos.above(), this);
            }
            if (this.isStraight) {
                world.updateNeighborsAt(pos, this);
                world.updateNeighborsAt(pos.below(), this);
            }
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        boolean bl = fluidState.getType() == Fluids.WATER;
        BlockState blockState = super.defaultBlockState();
        Direction direction = ctx.getHorizontalDirection();
        boolean bl2 = direction == Direction.EAST || direction == Direction.WEST;
        return (BlockState)((BlockState)blockState.setValue(this.getShapeProperty(), bl2 ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH)).setValue(WATERLOGGED, bl);
    }

    public abstract Property<RailShape> getShapeProperty();

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (state.getValue(WATERLOGGED).booleanValue()) {
            tickView.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

