/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DoubleBlockCombiner {
    public static <S extends BlockEntity> NeighborCombineResult<S> combineWithNeigbour(BlockEntityType<S> blockEntityType, Function<BlockState, BlockType> typeMapper, Function<BlockState, Direction> directionMapper, Property<Direction> property, BlockState state, LevelAccessor world, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> fallbackTester) {
        BlockType blockType2;
        boolean bl2;
        S blockEntity = blockEntityType.getBlockEntity(world, pos);
        if (blockEntity == null) {
            return Combiner::acceptNone;
        }
        if (fallbackTester.test(world, pos)) {
            return Combiner::acceptNone;
        }
        BlockType blockType = typeMapper.apply(state);
        boolean bl = blockType == BlockType.SINGLE;
        boolean bl3 = bl2 = blockType == BlockType.FIRST;
        if (bl) {
            return new NeighborCombineResult.Single<S>(blockEntity);
        }
        BlockPos blockPos = pos.relative(directionMapper.apply(state));
        BlockState blockState = world.getBlockStateIfLoaded(blockPos);
        if (blockState == null) {
            return new NeighborCombineResult.Single<S>(blockEntity);
        }
        if (blockState.is(state.getBlock()) && (blockType2 = typeMapper.apply(blockState)) != BlockType.SINGLE && blockType != blockType2 && blockState.getValue(property) == state.getValue(property)) {
            if (fallbackTester.test(world, blockPos)) {
                return Combiner::acceptNone;
            }
            S blockEntity2 = blockEntityType.getBlockEntity(world, blockPos);
            if (blockEntity2 != null) {
                S blockEntity3 = bl2 ? blockEntity : blockEntity2;
                S blockEntity4 = bl2 ? blockEntity2 : blockEntity;
                return new NeighborCombineResult.Double<S>(blockEntity3, blockEntity4);
            }
        }
        return new NeighborCombineResult.Single<S>(blockEntity);
    }

    public static interface NeighborCombineResult<S> {
        public <T> T apply(Combiner<? super S, T> var1);

        public static final class Single<S>
        implements NeighborCombineResult<S> {
            private final S single;

            public Single(S single) {
                this.single = single;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> retriever) {
                return retriever.acceptSingle(this.single);
            }
        }

        public static final class Double<S>
        implements NeighborCombineResult<S> {
            private final S first;
            private final S second;

            public Double(S first, S second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> retriever) {
                return retriever.acceptDouble(this.first, this.second);
            }
        }
    }

    public static enum BlockType {
        SINGLE,
        FIRST,
        SECOND;

    }

    public static interface Combiner<S, T> {
        public T acceptDouble(S var1, S var2);

        public T acceptSingle(S var1);

        public T acceptNone();
    }
}

