/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;

public class DragonEggBlock
extends FallingBlock {
    public static final MapCodec<DragonEggBlock> CODEC = DragonEggBlock.simpleCodec(DragonEggBlock::new);
    protected static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<DragonEggBlock> codec() {
        return CODEC;
    }

    public DragonEggBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        this.teleport(state, world, pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState state, Level world, BlockPos pos, Player player) {
        this.teleport(state, world, pos);
    }

    private void teleport(BlockState state, Level world, BlockPos pos) {
        WorldBorder worldborder = world.getWorldBorder();
        for (int i = 0; i < 1000; ++i) {
            BlockPos blockposition1 = pos.offset(world.random.nextInt(16) - world.random.nextInt(16), world.random.nextInt(8) - world.random.nextInt(8), world.random.nextInt(16) - world.random.nextInt(16));
            if (!world.getBlockState(blockposition1).isAir() || !worldborder.isWithinBounds(blockposition1)) continue;
            org.bukkit.block.Block from = world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            org.bukkit.block.Block to = world.getWorld().getBlockAt(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
            BlockFromToEvent event = new BlockFromToEvent(from, to);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            blockposition1 = new BlockPos(event.getToBlock().getX(), event.getToBlock().getY(), event.getToBlock().getZ());
            if (world.isClientSide) {
                for (int j = 0; j < 128; ++j) {
                    double d0 = world.random.nextDouble();
                    float f = (world.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (world.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = Mth.lerp(d0, (double)blockposition1.getX(), (double)pos.getX()) + (world.random.nextDouble() - 0.5) + 0.5;
                    double d2 = Mth.lerp(d0, (double)blockposition1.getY(), (double)pos.getY()) + world.random.nextDouble() - 0.5;
                    double d3 = Mth.lerp(d0, (double)blockposition1.getZ(), (double)pos.getZ()) + (world.random.nextDouble() - 0.5) + 0.5;
                    world.addParticle(ParticleTypes.PORTAL, d1, d2, d3, f, f1, f2);
                }
            } else {
                world.setBlock(blockposition1, state, 2);
                world.removeBlock(pos, false);
            }
            return;
        }
    }

    @Override
    protected int getDelayAfterPlace() {
        return 5;
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

