/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class LeverBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<LeverBlock> CODEC = LeverBlock.simpleCodec(LeverBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final int DEPTH = 6;
    protected static final int WIDTH = 6;
    protected static final int HEIGHT = 8;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 4.0, 10.0, 11.0, 12.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 4.0, 0.0, 11.0, 12.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 4.0, 5.0, 16.0, 12.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 4.0, 5.0, 6.0, 12.0, 11.0);
    protected static final VoxelShape UP_AABB_Z = Block.box(5.0, 0.0, 4.0, 11.0, 6.0, 12.0);
    protected static final VoxelShape UP_AABB_X = Block.box(4.0, 0.0, 5.0, 12.0, 6.0, 11.0);
    protected static final VoxelShape DOWN_AABB_Z = Block.box(5.0, 10.0, 4.0, 11.0, 16.0, 12.0);
    protected static final VoxelShape DOWN_AABB_X = Block.box(4.0, 10.0, 5.0, 12.0, 16.0, 11.0);

    public MapCodec<LeverBlock> codec() {
        return CODEC;
    }

    protected LeverBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(HorizontalDirectionalBlock.FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(FaceAttachedHorizontalDirectionalBlock.FACE, AttachFace.WALL));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch (state.getValue(FaceAttachedHorizontalDirectionalBlock.FACE)) {
            case FLOOR: {
                switch (state.getValue(HorizontalDirectionalBlock.FACING).getAxis()) {
                    case X: {
                        return UP_AABB_X;
                    }
                }
                return UP_AABB_Z;
            }
            case WALL: {
                switch (state.getValue(HorizontalDirectionalBlock.FACING)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        switch (state.getValue(HorizontalDirectionalBlock.FACING).getAxis()) {
            case X: {
                return DOWN_AABB_X;
            }
        }
        return DOWN_AABB_Z;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            BlockState iblockdata1 = (BlockState)state.cycle(POWERED);
            if (iblockdata1.getValue(POWERED).booleanValue()) {
                LeverBlock.makeParticle(iblockdata1, world, pos, 1.0f);
            }
        } else {
            boolean powered = state.getValue(POWERED);
            org.bukkit.block.Block block = world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0 != !powered) {
                return InteractionResult.SUCCESS;
            }
            this.pull(state, world, pos, null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState state, ServerLevel world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        if (explosion.canTriggerBlocks()) {
            this.pull(state, world, pos, null);
        }
        super.onExplosionHit(state, world, pos, explosion, stackMerger);
    }

    public void pull(BlockState state, Level world, BlockPos pos, @Nullable Player player) {
        state = (BlockState)state.cycle(POWERED);
        world.setBlock(pos, state, 3);
        this.updateNeighbours(state, world, pos);
        LeverBlock.playSound(player, world, pos, state);
        world.gameEvent((Entity)player, state.getValue(POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, pos);
    }

    protected static void playSound(@Nullable Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        float f = state.getValue(POWERED) != false ? 0.6f : 0.5f;
        world.playSound(player, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
    }

    private static void makeParticle(BlockState state, LevelAccessor world, BlockPos pos, float alpha) {
        Direction enumdirection = state.getValue(HorizontalDirectionalBlock.FACING).getOpposite();
        Direction enumdirection1 = LeverBlock.getConnectedDirection(state).getOpposite();
        double d0 = (double)pos.getX() + 0.5 + 0.1 * (double)enumdirection.getStepX() + 0.2 * (double)enumdirection1.getStepX();
        double d1 = (double)pos.getY() + 0.5 + 0.1 * (double)enumdirection.getStepY() + 0.2 * (double)enumdirection1.getStepY();
        double d2 = (double)pos.getZ() + 0.5 + 0.1 * (double)enumdirection.getStepZ() + 0.2 * (double)enumdirection1.getStepZ();
        world.addParticle(new DustParticleOptions(0xFF0000, alpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (state.getValue(POWERED).booleanValue() && random.nextFloat() < 0.25f) {
            LeverBlock.makeParticle(state, world, pos, 0.5f);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved && !state.is(newState.getBlock())) {
            if (state.getValue(POWERED).booleanValue()) {
                this.updateNeighbours(state, world, pos);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue(POWERED) != false && LeverBlock.getConnectedDirection(state) == direction ? 15 : 0;
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    private void updateNeighbours(BlockState state, Level world, BlockPos pos) {
        Direction enumdirection;
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, enumdirection, (enumdirection = LeverBlock.getConnectedDirection(state).getOpposite()).getAxis().isHorizontal() ? Direction.UP : state.getValue(HorizontalDirectionalBlock.FACING));
        world.updateNeighborsAt(pos, this, orientation);
        world.updateNeighborsAt(pos.relative(enumdirection), this, orientation);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(FaceAttachedHorizontalDirectionalBlock.FACE, HorizontalDirectionalBlock.FACING, POWERED);
    }
}

