/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MultifaceBlock
extends Block {
    private static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = Util.make(Maps.newEnumMap(Direction.class), shapes -> {
        shapes.put(Direction.NORTH, NORTH_AABB);
        shapes.put(Direction.EAST, EAST_AABB);
        shapes.put(Direction.SOUTH, SOUTH_AABB);
        shapes.put(Direction.WEST, WEST_AABB);
        shapes.put(Direction.UP, UP_AABB);
        shapes.put(Direction.DOWN, DOWN_AABB);
    });
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public MultifaceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState(this.stateDefinition));
        this.shapesCache = this.getShapeForEachState(MultifaceBlock::calculateMultifaceShape);
        this.canRotate = Direction.Plane.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    @Override
    protected abstract MapCodec<? extends MultifaceBlock> codec();

    public static Set<Direction> availableFaces(BlockState state) {
        if (!(state.getBlock() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<Direction> unpack(byte flag) {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if ((flag & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte pack(Collection<Direction> directions) {
        byte b = 0;
        for (Direction direction : directions) {
            b = (byte)(b | 1 << direction.ordinal());
        }
        return b;
    }

    protected boolean isFaceSupported(Direction direction) {
        return true;
    }

    @Override
    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            builder.add(MultifaceBlock.getFaceProperty(direction));
        }
    }

    @Override
    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!MultifaceBlock.hasAnyFace(state)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!MultifaceBlock.hasFace(state, direction) || MultifaceBlock.canAttachTo(world, direction, neighborPos, neighborState)) {
            return state;
        }
        return MultifaceBlock.removeFace(state, MultifaceBlock.getFaceProperty(direction));
    }

    @Override
    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapesCache.get((Object)state);
    }

    @Override
    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        boolean bl = false;
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            BlockPos blockPos = pos.relative(direction);
            if (!MultifaceBlock.canAttachTo(world, direction, blockPos, world.getBlockState(blockPos))) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    @Override
    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return MultifaceBlock.hasAnyVacantFace(state);
    }

    @Override
    @Nullable
    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        return Arrays.stream(ctx.getNearestLookingDirections()).map(direction -> this.getStateForPlacement(blockState, level, blockPos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(BlockGetter world, BlockState state, BlockPos pos, Direction direction) {
        if (!this.isFaceSupported(direction) || state.is(this) && MultifaceBlock.hasFace(state, direction)) {
            return false;
        }
        BlockPos blockPos = pos.relative(direction);
        return MultifaceBlock.canAttachTo(world, direction, blockPos, world.getBlockState(blockPos));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockState blockState3;
        if (!this.isValidStateForPlacement(world, state, pos, direction)) {
            return null;
        }
        if (state.is(this)) {
            BlockState blockState = state;
        } else if (this.isWaterloggable() && state.getFluidState().isSourceOfType(Fluids.WATER)) {
            BlockState blockState2 = (BlockState)this.defaultBlockState().setValue(BlockStateProperties.WATERLOGGED, true);
        } else {
            blockState3 = this.defaultBlockState();
        }
        return (BlockState)blockState3.setValue(MultifaceBlock.getFaceProperty(direction), true);
    }

    @Override
    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        if (!this.canRotate) {
            return state;
        }
        return this.mapDirections(state, rotation::rotate);
    }

    @Override
    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK && !this.canMirrorX) {
            return state;
        }
        if (mirror == Mirror.LEFT_RIGHT && !this.canMirrorZ) {
            return state;
        }
        return this.mapDirections(state, mirror::mirror);
    }

    private BlockState mapDirections(BlockState state, Function<Direction, Direction> mirror) {
        BlockState blockState = state;
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            blockState = (BlockState)blockState.setValue(MultifaceBlock.getFaceProperty(mirror.apply(direction)), state.getValue(MultifaceBlock.getFaceProperty(direction)));
        }
        return blockState;
    }

    public static boolean hasFace(BlockState state, Direction direction) {
        BooleanProperty booleanProperty = MultifaceBlock.getFaceProperty(direction);
        return state.getValueOrElse(booleanProperty, false);
    }

    public static boolean canAttachTo(BlockGetter world, Direction direction, BlockPos pos, BlockState state) {
        return Block.isFaceFull(state.getBlockSupportShape(world, pos), direction.getOpposite()) || Block.isFaceFull(state.getCollisionShape(world, pos), direction.getOpposite());
    }

    private boolean isWaterloggable() {
        return this.stateDefinition.getProperties().contains(BlockStateProperties.WATERLOGGED);
    }

    private static BlockState removeFace(BlockState state, BooleanProperty direction) {
        BlockState blockState = (BlockState)state.setValue(direction, false);
        if (MultifaceBlock.hasAnyFace(blockState)) {
            return blockState;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static BooleanProperty getFaceProperty(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    private static BlockState getDefaultMultifaceState(StateDefinition<Block, BlockState> stateManager) {
        BlockState blockState = stateManager.any();
        for (BooleanProperty booleanProperty : PROPERTY_BY_DIRECTION.values()) {
            blockState = (BlockState)blockState.trySetValue(booleanProperty, false);
        }
        return blockState;
    }

    private static VoxelShape calculateMultifaceShape(BlockState state) {
        VoxelShape voxelShape = Shapes.empty();
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            voxelShape = Shapes.or(voxelShape, SHAPE_BY_DIRECTION.get(direction));
        }
        return voxelShape.isEmpty() ? Shapes.block() : voxelShape;
    }

    protected static boolean hasAnyFace(BlockState state) {
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(state, direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyVacantFace(BlockState state) {
        for (Direction direction : DIRECTIONS) {
            if (MultifaceBlock.hasFace(state, direction)) continue;
            return true;
        }
        return false;
    }

    public abstract MultifaceSpreader getSpreader();
}

