/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class MultifaceSpreader {
    public static final SpreadType[] DEFAULT_SPREAD_ORDER = new SpreadType[]{SpreadType.SAME_POSITION, SpreadType.SAME_PLANE, SpreadType.WRAP_AROUND};
    private final SpreadConfig config;

    public MultifaceSpreader(MultifaceBlock lichen) {
        this(new DefaultSpreaderConfig(lichen));
    }

    public MultifaceSpreader(SpreadConfig growChecker) {
        this.config = growChecker;
    }

    public boolean canSpreadInAnyDirection(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return Direction.stream().anyMatch(enumdirection1 -> {
            SpreadConfig multifacespreader_b = this.config;
            Objects.requireNonNull(this.config);
            return this.getSpreadFromFaceTowardDirection(state, world, pos, direction, (Direction)enumdirection1, multifacespreader_b::canSpreadInto).isPresent();
        });
    }

    public Optional<SpreadPos> spreadFromRandomFaceTowardRandomDirection(BlockState state, LevelAccessor world, BlockPos pos, RandomSource random) {
        return Direction.allShuffled(random).stream().filter(enumdirection -> this.config.canSpreadFrom(state, (Direction)enumdirection)).map(enumdirection -> this.spreadFromFaceTowardRandomDirection(state, world, pos, (Direction)enumdirection, random, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long spreadAll(BlockState state, LevelAccessor world, BlockPos pos, boolean markForPostProcessing) {
        return Direction.stream().filter(enumdirection -> this.config.canSpreadFrom(state, (Direction)enumdirection)).map(enumdirection -> this.spreadFromFaceTowardAllDirections(state, world, pos, (Direction)enumdirection, markForPostProcessing)).reduce(0L, Long::sum);
    }

    public Optional<SpreadPos> spreadFromFaceTowardRandomDirection(BlockState state, LevelAccessor world, BlockPos pos, Direction direction, RandomSource random, boolean markForPostProcessing) {
        return Direction.allShuffled(random).stream().map(enumdirection1 -> this.spreadFromFaceTowardDirection(state, world, pos, direction, (Direction)enumdirection1, markForPostProcessing)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long spreadFromFaceTowardAllDirections(BlockState state, LevelAccessor world, BlockPos pos, Direction direction, boolean markForPostProcessing) {
        return Direction.stream().map(enumdirection1 -> this.spreadFromFaceTowardDirection(state, world, pos, direction, (Direction)enumdirection1, markForPostProcessing)).filter(Optional::isPresent).count();
    }

    @VisibleForTesting
    public Optional<SpreadPos> spreadFromFaceTowardDirection(BlockState state, LevelAccessor world, BlockPos pos, Direction oldDirection, Direction newDirection, boolean markForPostProcessing) {
        SpreadConfig multifacespreader_b = this.config;
        Objects.requireNonNull(this.config);
        return this.getSpreadFromFaceTowardDirection(state, world, pos, oldDirection, newDirection, multifacespreader_b::canSpreadInto).flatMap(multifacespreader_c -> this.spreadToFace(world, (SpreadPos)multifacespreader_c, markForPostProcessing));
    }

    public Optional<SpreadPos> getSpreadFromFaceTowardDirection(BlockState state, BlockGetter world, BlockPos pos, Direction oldDirection, Direction newDirection, SpreadPredicate predicate) {
        if (newDirection.getAxis() == oldDirection.getAxis()) {
            return Optional.empty();
        }
        if (!(this.config.isOtherBlockValidAsSource(state) || this.config.hasFace(state, oldDirection) && !this.config.hasFace(state, newDirection))) {
            return Optional.empty();
        }
        for (SpreadType multifacespreader_e : this.config.getSpreadTypes()) {
            SpreadPos multifacespreader_c = multifacespreader_e.getSpreadPos(pos, newDirection, oldDirection);
            if (!predicate.test(world, pos, multifacespreader_c)) continue;
            return Optional.of(multifacespreader_c);
        }
        return Optional.empty();
    }

    public Optional<SpreadPos> spreadToFace(LevelAccessor world, SpreadPos pos, boolean markForPostProcessing) {
        BlockState iblockdata = world.getBlockState(pos.pos());
        return this.config.placeBlock(world, pos, iblockdata, markForPostProcessing) ? Optional.of(pos) : Optional.empty();
    }

    public static class DefaultSpreaderConfig
    implements SpreadConfig {
        protected MultifaceBlock block;

        public DefaultSpreaderConfig(MultifaceBlock lichen) {
            this.block = lichen;
        }

        @Override
        @Nullable
        public BlockState getStateForPlacement(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
            return this.block.getStateForPlacement(state, world, pos, direction);
        }

        protected boolean stateCanBeReplaced(BlockGetter world, BlockPos pos, BlockPos growPos, Direction direction, BlockState state) {
            return state.isAir() || state.is(this.block) || state.is(Blocks.WATER) && state.getFluidState().isSource();
        }

        @Override
        public boolean canSpreadInto(BlockGetter world, BlockPos pos, SpreadPos growPos) {
            BlockState iblockdata = world.getBlockState(growPos.pos());
            return this.stateCanBeReplaced(world, pos, growPos.pos(), growPos.face(), iblockdata) && this.block.isValidStateForPlacement(world, iblockdata, growPos.pos(), growPos.face());
        }
    }

    public static interface SpreadConfig {
        @Nullable
        public BlockState getStateForPlacement(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4);

        public boolean canSpreadInto(BlockGetter var1, BlockPos var2, SpreadPos var3);

        default public SpreadType[] getSpreadTypes() {
            return DEFAULT_SPREAD_ORDER;
        }

        default public boolean hasFace(BlockState state, Direction direction) {
            return MultifaceBlock.hasFace(state, direction);
        }

        default public boolean isOtherBlockValidAsSource(BlockState state) {
            return false;
        }

        default public boolean canSpreadFrom(BlockState state, Direction direction) {
            return this.isOtherBlockValidAsSource(state) || this.hasFace(state, direction);
        }

        default public boolean placeBlock(LevelAccessor world, SpreadPos growPos, BlockState state, boolean markForPostProcessing) {
            BlockState iblockdata1 = this.getStateForPlacement(state, world, growPos.pos(), growPos.face());
            if (iblockdata1 != null) {
                if (markForPostProcessing) {
                    world.getChunk(growPos.pos()).markPosForPostprocessing(growPos.pos());
                }
                return CraftEventFactory.handleBlockSpreadEvent(world, growPos.source(), growPos.pos(), iblockdata1, 2);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface SpreadPredicate {
        public boolean test(BlockGetter var1, BlockPos var2, SpreadPos var3);
    }

    public static enum SpreadType {
        SAME_POSITION{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction newDirection, Direction oldDirection) {
                return new SpreadPos(pos, newDirection, pos);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction newDirection, Direction oldDirection) {
                return new SpreadPos(pos.relative(newDirection), oldDirection, pos);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public SpreadPos getSpreadPos(BlockPos pos, Direction newDirection, Direction oldDirection) {
                return new SpreadPos(pos.relative(newDirection).relative(oldDirection), newDirection.getOpposite(), pos);
            }
        };


        public abstract SpreadPos getSpreadPos(BlockPos var1, Direction var2, Direction var3);
    }

    public record SpreadPos(BlockPos pos, Direction face, BlockPos source) {
    }
}

