/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class NoteBlock
extends Block {
    public static final MapCodec<NoteBlock> CODEC = NoteBlock.simpleCodec(NoteBlock::new);
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.NOTEBLOCK_INSTRUMENT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty NOTE = BlockStateProperties.NOTE;
    public static final int NOTE_VOLUME = 3;

    public MapCodec<NoteBlock> codec() {
        return CODEC;
    }

    public NoteBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(INSTRUMENT, NoteBlockInstrument.HARP)).setValue(NOTE, 0)).setValue(POWERED, false));
    }

    private BlockState setInstrument(LevelReader world, BlockPos pos, BlockState state) {
        NoteBlockInstrument blockpropertyinstrument = world.getBlockState(pos.above()).instrument();
        if (blockpropertyinstrument.worksAboveNoteBlock()) {
            return (BlockState)state.setValue(INSTRUMENT, blockpropertyinstrument);
        }
        NoteBlockInstrument blockpropertyinstrument1 = world.getBlockState(pos.below()).instrument();
        NoteBlockInstrument blockpropertyinstrument2 = blockpropertyinstrument1.worksAboveNoteBlock() ? NoteBlockInstrument.HARP : blockpropertyinstrument1;
        return (BlockState)state.setValue(INSTRUMENT, blockpropertyinstrument2);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return this.defaultBlockState();
        }
        return this.setInstrument(ctx.getLevel(), ctx.getClickedPos(), this.defaultBlockState());
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return state;
        }
        boolean flag = direction.getAxis() == Direction.Axis.Y;
        return flag ? this.setInstrument(world, pos, state) : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
            return;
        }
        boolean flag1 = world.hasNeighborSignal(pos);
        if (flag1 != state.getValue(POWERED)) {
            if (flag1) {
                this.playNote(null, state, world, pos);
                state = world.getBlockState(pos);
            }
            world.setBlock(pos, (BlockState)state.setValue(POWERED, flag1), 3);
        }
    }

    private void playNote(@Nullable Entity entity, BlockState state, Level world, BlockPos pos) {
        if (state.getValue(INSTRUMENT).worksAboveNoteBlock() || world.getBlockState(pos.above()).isAir()) {
            world.blockEvent(pos, this, 0, 0);
            world.gameEvent(entity, GameEvent.NOTE_BLOCK_PLAY, pos);
        }
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return stack.is(ItemTags.NOTE_BLOCK_TOP_INSTRUMENTS) && hit.getDirection() == Direction.UP ? InteractionResult.PASS : super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (!GlobalConfiguration.get().blockUpdates.disableNoteblockUpdates) {
                state = (BlockState)state.cycle(NOTE);
            }
            world.setBlock(pos, state, 3);
            this.playNote(player, state, world, pos);
            player.awardStat(Stats.TUNE_NOTEBLOCK);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (!world.isClientSide) {
            this.playNote(player, state, world, pos);
            player.awardStat(Stats.PLAY_NOTEBLOCK);
        }
    }

    public static float getPitchFromNote(int note) {
        return (float)Math.pow(2.0, (double)(note - 12) / 12.0);
    }

    @Override
    protected boolean triggerEvent(BlockState state, Level world, BlockPos pos, int type, int data) {
        Holder<SoundEvent> holder;
        float f;
        NoteBlockInstrument blockpropertyinstrument = state.getValue(INSTRUMENT);
        NotePlayEvent event = CraftEventFactory.callNotePlayEvent(world, pos, blockpropertyinstrument, state.getValue(NOTE));
        if (event.isCancelled()) {
            return false;
        }
        if (blockpropertyinstrument.isTunable()) {
            byte k = event.getNote().getId();
            f = NoteBlock.getPitchFromNote(k);
            world.addParticle(ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)k / 24.0, 0.0, 0.0);
        } else {
            f = 1.0f;
        }
        if (blockpropertyinstrument.hasCustomSound()) {
            ResourceLocation minecraftkey = this.getCustomSoundId(world, pos);
            if (minecraftkey == null) {
                return false;
            }
            holder = Holder.direct(SoundEvent.createVariableRangeEvent(minecraftkey));
        } else {
            holder = CraftBlockData.toNMS(event.getInstrument(), NoteBlockInstrument.class).getSoundEvent();
        }
        world.playSeededSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, holder, SoundSource.RECORDS, 3.0f, f, world.random.nextLong());
        return true;
    }

    @Nullable
    private ResourceLocation getCustomSoundId(Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos.above());
        if (tileentity instanceof SkullBlockEntity) {
            SkullBlockEntity tileentityskull = (SkullBlockEntity)tileentity;
            return tileentityskull.getNoteBlockSound();
        }
        return null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(INSTRUMENT, POWERED, NOTE);
    }
}

