/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final MapCodec<PointedDripstoneBlock> CODEC = PointedDripstoneBlock.simpleCodec(PointedDripstoneBlock::new);
    public static final EnumProperty<Direction> TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape BASE_SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public MapCodec<PointedDripstoneBlock> codec() {
        return CODEC;
    }

    public PointedDripstoneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(TIP_DIRECTION, Direction.UP)).setValue(THICKNESS, DripstoneThickness.TIP)).setValue(WATERLOGGED, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(TIP_DIRECTION, THICKNESS, WATERLOGGED);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return PointedDripstoneBlock.isValidPointedDripstonePlacement(world, pos, state.getValue(TIP_DIRECTION));
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (state.getValue(WATERLOGGED).booleanValue()) {
            tickView.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction enumdirection1 = state.getValue(TIP_DIRECTION);
        if (enumdirection1 == Direction.DOWN && tickView.getBlockTicks().hasScheduledTick(pos, this)) {
            return state;
        }
        if (direction == enumdirection1.getOpposite() && !this.canSurvive(state, world, pos)) {
            if (enumdirection1 == Direction.DOWN) {
                tickView.scheduleTick(pos, this, 2);
            } else {
                tickView.scheduleTick(pos, this, 1);
            }
            return state;
        }
        boolean flag = state.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.calculateDripstoneThickness(world, pos, enumdirection1, flag);
        return (BlockState)state.setValue(THICKNESS, dripstonethickness);
    }

    @Override
    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!world.isClientSide) {
            ServerLevel worldserver;
            BlockPos blockposition = hit.getBlockPos();
            if (world instanceof ServerLevel && projectile.mayInteract(worldserver = (ServerLevel)world, blockposition) && projectile.mayBreak(worldserver) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, state.getFluidState().createLegacyBlock())) {
                    return;
                }
                world.destroyBlock(blockposition, true);
            }
        }
    }

    @Override
    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue(TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, world.damageSources().stalagmite().directBlock(world, pos));
        } else {
            super.fallOn(world, state, pos, entity, fallDistance);
        }
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        float f;
        if (PointedDripstoneBlock.canDrip(state) && (f = random.nextFloat()) <= 0.12f) {
            PointedDripstoneBlock.getFluidAboveStalactite(world, pos, state).filter(pointeddripstoneblock_a -> f < 0.02f || PointedDripstoneBlock.canFillCauldron(pointeddripstoneblock_a.fluid)).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.spawnDripParticle(world, pos, state, pointeddripstoneblock_a.fluid));
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (PointedDripstoneBlock.isStalagmite(state) && !this.canSurvive(state, world, pos)) {
            world.destroyBlock(pos, true);
        } else {
            PointedDripstoneBlock.spawnFallingStalactite(state, world, pos);
        }
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        PointedDripstoneBlock.maybeTransferFluid(state, world, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && PointedDripstoneBlock.isStalactiteStartPos(state, world, pos)) {
            PointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(state, world, pos, random);
        }
    }

    @VisibleForTesting
    public static void maybeTransferFluid(BlockState state, ServerLevel world, BlockPos pos, float dripChance) {
        Optional<FluidInfo> optional;
        if ((dripChance <= 0.17578125f || dripChance <= 0.05859375f) && PointedDripstoneBlock.isStalactiteStartPos(state, world, pos) && !(optional = PointedDripstoneBlock.getFluidAboveStalactite(world, pos, state)).isEmpty()) {
            BlockPos blockposition1;
            float f1;
            Fluid fluidtype = optional.get().fluid;
            if (fluidtype == Fluids.WATER) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != Fluids.LAVA) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (dripChance < f1 && (blockposition1 = PointedDripstoneBlock.findTip(state, world, pos, 11, false)) != null) {
                if (optional.get().sourceState.is(Blocks.MUD) && fluidtype == Fluids.WATER) {
                    BlockState iblockdata1 = Blocks.CLAY.defaultBlockState();
                    if (CraftEventFactory.handleBlockFormEvent(world, optional.get().pos, iblockdata1)) {
                        Block.pushEntitiesUp(optional.get().sourceState, iblockdata1, world, optional.get().pos);
                        world.gameEvent(GameEvent.BLOCK_CHANGE, optional.get().pos, GameEvent.Context.of(iblockdata1));
                        world.levelEvent(1504, blockposition1, 0);
                    }
                } else {
                    BlockPos blockposition2 = PointedDripstoneBlock.findFillableCauldronBelowStalactiteTip(world, blockposition1, fluidtype);
                    if (blockposition2 != null) {
                        world.levelEvent(1504, blockposition1, 0);
                        int i = blockposition1.getY() - blockposition2.getY();
                        int j = 50 + i;
                        BlockState iblockdata2 = world.getBlockState(blockposition2);
                        world.scheduleTick(blockposition2, iblockdata2.getBlock(), j);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction enumdirection;
        BlockPos blockposition;
        Level world = ctx.getLevel();
        Direction enumdirection1 = PointedDripstoneBlock.calculateTipDirection(world, blockposition = ctx.getClickedPos(), enumdirection = ctx.getNearestLookingVerticalDirection().getOpposite());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !ctx.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.calculateDripstoneThickness(world, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TIP_DIRECTION, enumdirection1)).setValue(THICKNESS, dripstonethickness)).setValue(WATERLOGGED, world.getFluidState(blockposition).getType() == Fluids.WATER);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState state) {
        return Shapes.empty();
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DripstoneThickness dripstonethickness = state.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.getValue(TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3d = state.getOffset(pos);
        return voxelshape.move(vec3d.x, 0.0, vec3d.z);
    }

    @Override
    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Override
    protected float getMaxHorizontalOffset() {
        return 0.125f;
    }

    @Override
    public void onBrokenAfterFall(Level world, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.isSilent()) {
            world.levelEvent(1045, pos, 0);
        }
    }

    @Override
    public DamageSource getFallDamageSource(Entity attacker) {
        return attacker.damageSources().fallingStalactite(attacker);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        BlockState iblockdata1 = state;
        while (PointedDripstoneBlock.isStalactite(iblockdata1)) {
            FallingBlockEntity entityfallingblock = FallingBlockEntity.fall(world, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.isTip(iblockdata1, true)) {
                int i = Math.max(1 + pos.getY() - blockposition_mutableblockposition.getY(), 6);
                float f = 1.0f * (float)i;
                entityfallingblock.setHurtsEntities(f, 40);
                break;
            }
            blockposition_mutableblockposition.move(Direction.DOWN);
            iblockdata1 = world.getBlockState(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockState iblockdata3;
        BlockPos blockposition1;
        BlockState iblockdata2;
        BlockState iblockdata1 = world.getBlockState(pos.above(1));
        if (PointedDripstoneBlock.canGrow(iblockdata1, iblockdata2 = world.getBlockState(pos.above(2))) && (blockposition1 = PointedDripstoneBlock.findTip(state, world, pos, 7, false)) != null && PointedDripstoneBlock.canDrip(iblockdata3 = world.getBlockState(blockposition1)) && PointedDripstoneBlock.canTipGrow(iblockdata3, world, blockposition1)) {
            if (random.nextBoolean()) {
                PointedDripstoneBlock.grow(world, blockposition1, Direction.DOWN);
            } else {
                PointedDripstoneBlock.growStalagmiteBelow(world, blockposition1);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            blockposition_mutableblockposition.move(Direction.DOWN);
            BlockState iblockdata = world.getBlockState(blockposition_mutableblockposition);
            if (!iblockdata.getFluidState().isEmpty()) {
                return;
            }
            if (PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata, Direction.UP) && PointedDripstoneBlock.canTipGrow(iblockdata, world, blockposition_mutableblockposition)) {
                PointedDripstoneBlock.grow(world, blockposition_mutableblockposition, Direction.UP);
                return;
            }
            if (PointedDripstoneBlock.isValidPointedDripstonePlacement(world, blockposition_mutableblockposition, Direction.UP) && !world.isWaterAt((BlockPos)blockposition_mutableblockposition.below())) {
                PointedDripstoneBlock.grow(world, (BlockPos)blockposition_mutableblockposition.below(), Direction.UP);
                return;
            }
            if (PointedDripstoneBlock.canDripThrough(world, blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void grow(ServerLevel world, BlockPos pos, Direction direction) {
        BlockPos blockposition1 = pos.relative(direction);
        BlockState iblockdata = world.getBlockState(blockposition1);
        if (PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata, direction.getOpposite())) {
            PointedDripstoneBlock.createMergedTips(iblockdata, world, blockposition1);
        } else if (iblockdata.isAir() || iblockdata.is(Blocks.WATER)) {
            PointedDripstoneBlock.createDripstone(world, blockposition1, direction, DripstoneThickness.TIP, pos);
        }
    }

    private static void createDripstone(LevelAccessor generatoraccess, BlockPos blockposition, Direction enumdirection, DripstoneThickness dripstonethickness, BlockPos source) {
        BlockState iblockdata = (BlockState)((BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue(TIP_DIRECTION, enumdirection)).setValue(THICKNESS, dripstonethickness)).setValue(WATERLOGGED, generatoraccess.getFluidState(blockposition).getType() == Fluids.WATER);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockPos blockposition2;
        BlockPos blockposition1;
        if (state.getValue(TIP_DIRECTION) == Direction.UP) {
            blockposition1 = pos;
            blockposition2 = pos.above();
        } else {
            blockposition2 = pos;
            blockposition1 = pos.below();
        }
        PointedDripstoneBlock.createDripstone(world, blockposition2, Direction.DOWN, DripstoneThickness.TIP_MERGE, pos);
        PointedDripstoneBlock.createDripstone(world, blockposition1, Direction.UP, DripstoneThickness.TIP_MERGE, pos);
    }

    public static void spawnDripParticle(Level world, BlockPos pos, BlockState state) {
        PointedDripstoneBlock.getFluidAboveStalactite(world, pos, state).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.spawnDripParticle(world, pos, state, pointeddripstoneblock_a.fluid));
    }

    private static void spawnDripParticle(Level world, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3d = state.getOffset(pos);
        double d0 = 0.0625;
        double d1 = (double)pos.getX() + 0.5 + vec3d.x;
        double d2 = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.getZ() + 0.5 + vec3d.z;
        Fluid fluidtype1 = PointedDripstoneBlock.getDripFluid(world, fluid);
        SimpleParticleType particletype = fluidtype1.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        world.addParticle(particletype, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor world, BlockPos pos, int range, boolean allowMerged) {
        if (PointedDripstoneBlock.isTip(state, allowMerged)) {
            return pos;
        }
        Direction enumdirection = state.getValue(TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.is(Blocks.POINTED_DRIPSTONE) && iblockdata1.getValue(TIP_DIRECTION) == enumdirection;
        return PointedDripstoneBlock.findBlockVertical(world, pos, enumdirection.getAxisDirection(), bipredicate, iblockdata1 -> PointedDripstoneBlock.isTip(iblockdata1, allowMerged), range).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader world, BlockPos pos, Direction direction) {
        Direction enumdirection1;
        if (PointedDripstoneBlock.isValidPointedDripstonePlacement(world, pos, direction)) {
            enumdirection1 = direction;
        } else {
            if (!PointedDripstoneBlock.isValidPointedDripstonePlacement(world, pos, direction.getOpposite())) {
                return null;
            }
            enumdirection1 = direction.getOpposite();
        }
        return enumdirection1;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader world, BlockPos pos, Direction direction, boolean tryMerge) {
        Direction enumdirection1 = direction.getOpposite();
        BlockState iblockdata = world.getBlockState(pos.relative(direction));
        if (PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, enumdirection1)) {
            return !tryMerge && iblockdata.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = iblockdata.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState iblockdata1 = world.getBlockState(pos.relative(enumdirection1));
            return !PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata1, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedDripstoneBlock.isStalactite(state) && state.getValue(THICKNESS) == DripstoneThickness.TIP && state.getValue(WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel world, BlockPos pos) {
        Direction enumdirection = state.getValue(TIP_DIRECTION);
        BlockPos blockposition1 = pos.relative(enumdirection);
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        return !iblockdata1.getFluidState().isEmpty() ? false : (iblockdata1.isAir() ? true : PointedDripstoneBlock.isUnmergedTipWithDirection(iblockdata1, enumdirection.getOpposite()));
    }

    private static Optional<BlockPos> findRootBlock(Level world, BlockPos pos, BlockState state, int range) {
        Direction enumdirection = state.getValue(TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.is(Blocks.POINTED_DRIPSTONE) && iblockdata1.getValue(TIP_DIRECTION) == enumdirection;
        return PointedDripstoneBlock.findBlockVertical(world, pos, enumdirection.getOpposite().getAxisDirection(), bipredicate, iblockdata1 -> !iblockdata1.is(Blocks.POINTED_DRIPSTONE), range);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader world, BlockPos pos, Direction direction) {
        BlockPos blockposition1 = pos.relative(direction.getOpposite());
        BlockState iblockdata = world.getBlockState(blockposition1);
        return iblockdata.isFaceSturdy(world, blockposition1, direction) || PointedDripstoneBlock.isPointedDripstoneWithDirection(iblockdata, direction);
    }

    private static boolean isTip(BlockState state, boolean allowMerged) {
        if (!state.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        DripstoneThickness dripstonethickness = state.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || allowMerged && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction direction) {
        return PointedDripstoneBlock.isTip(state, false) && state.getValue(TIP_DIRECTION) == direction;
    }

    private static boolean isStalactite(BlockState state) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return PointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader world, BlockPos pos) {
        return PointedDripstoneBlock.isStalactite(state) && !world.getBlockState(pos.above()).is(Blocks.POINTED_DRIPSTONE);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction direction) {
        return state.is(Blocks.POINTED_DRIPSTONE) && state.getValue(TIP_DIRECTION) == direction;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level world, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = iblockdata -> iblockdata.getBlock() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.getBlock()).canReceiveStalactiteDrip(fluid);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.canDripThrough(world, blockposition1, iblockdata);
        return PointedDripstoneBlock.findBlockVertical(world, pos, Direction.DOWN.getAxisDirection(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos findStalactiteTipAboveCauldron(Level world, BlockPos pos) {
        BiPredicate<BlockPos, BlockState> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.canDripThrough(world, blockposition1, iblockdata);
        return PointedDripstoneBlock.findBlockVertical(world, pos, Direction.UP.getAxisDirection(), bipredicate, PointedDripstoneBlock::canDrip, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(ServerLevel world, BlockPos pos) {
        return PointedDripstoneBlock.getFluidAboveStalactite(world, pos, world.getBlockState(pos)).map(pointeddripstoneblock_a -> pointeddripstoneblock_a.fluid).filter(PointedDripstoneBlock::canFillCauldron).orElse(Fluids.EMPTY);
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level world, BlockPos pos, BlockState state) {
        return !PointedDripstoneBlock.isStalactite(state) ? Optional.empty() : PointedDripstoneBlock.findRootBlock(world, pos, state, 11).map(blockposition1 -> {
            BlockPos blockposition2 = blockposition1.above();
            BlockState iblockdata1 = world.getBlockState(blockposition2);
            Fluid object = iblockdata1.is(Blocks.MUD) && !world.dimensionType().ultraWarm() ? Fluids.WATER : world.getFluidState(blockposition2).getType();
            return new FluidInfo(blockposition2, object, iblockdata1);
        });
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.LAVA || fluid == Fluids.WATER;
    }

    private static boolean canGrow(BlockState dripstoneBlockState, BlockState waterState) {
        return dripstoneBlockState.is(Blocks.DRIPSTONE_BLOCK) && waterState.is(Blocks.WATER) && waterState.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level world, Fluid fluid) {
        return fluid.isSame(Fluids.EMPTY) ? (world.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER) : fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor world, BlockPos pos, Direction.AxisDirection direction, BiPredicate<BlockPos, BlockState> continuePredicate, Predicate<BlockState> stopPredicate, int range) {
        Direction enumdirection = Direction.get(direction, Direction.Axis.Y);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        for (int j = 1; j < range; ++j) {
            blockposition_mutableblockposition.move(enumdirection);
            BlockState iblockdata = world.getBlockState(blockposition_mutableblockposition);
            if (stopPredicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.immutable());
            }
            if (!world.isOutsideBuildHeight(blockposition_mutableblockposition.getY()) && continuePredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter world, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender()) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelshape = state.getCollisionShape(world, pos);
        return !Shapes.joinIsNotEmpty(REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, voxelshape, BooleanOp.AND);
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState sourceState) {
    }
}

