/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.util.RedstoneWireTurbo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.WorldConfiguration;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class RedStoneWireBlock
extends Block {
    public static final MapCodec<RedStoneWireBlock> CODEC = RedStoneWireBlock.simpleCodec(RedStoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final int H = 1;
    protected static final int W = 3;
    protected static final int E = 13;
    protected static final int N = 3;
    protected static final int S = 13;
    private static final VoxelShape SHAPE_DOT = Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), (Object)Direction.SOUTH, (Object)Block.box(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), (Object)Direction.EAST, (Object)Block.box(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), (Object)Direction.WEST, (Object)Block.box(0.0, 0.0, 3.0, 13.0, 1.0, 13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.NORTH), Block.box(3.0, 0.0, 0.0, 13.0, 16.0, 1.0)), (Object)Direction.SOUTH, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.SOUTH), Block.box(3.0, 0.0, 15.0, 13.0, 16.0, 16.0)), (Object)Direction.EAST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.EAST), Block.box(15.0, 0.0, 3.0, 16.0, 16.0, 13.0)), (Object)Direction.WEST, (Object)Shapes.or(SHAPES_FLOOR.get(Direction.WEST), Block.box(0.0, 0.0, 3.0, 1.0, 16.0, 13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final int[] COLORS = Util.make(new int[16], colors -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float g = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float h = Mth.clamp(f * f * 0.7f - 0.5f, 0.0f, 1.0f);
            float j = Mth.clamp(f * f * 0.6f - 0.7f, 0.0f, 1.0f);
            colors[i] = ARGB.colorFromFloat(1.0f, g, h, j);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final BlockState crossState;
    private final RedstoneWireEvaluator evaluator = new DefaultRedstoneWireEvaluator(this);
    public boolean shouldSignal = true;
    RedstoneWireTurbo turbo = new RedstoneWireTurbo(this);

    public MapCodec<RedStoneWireBlock> codec() {
        return CODEC;
    }

    public RedStoneWireBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(NORTH, RedstoneSide.NONE)).setValue(EAST, RedstoneSide.NONE)).setValue(SOUTH, RedstoneSide.NONE)).setValue(WEST, RedstoneSide.NONE)).setValue(POWER, 0));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, RedstoneSide.SIDE)).setValue(EAST, RedstoneSide.SIDE)).setValue(SOUTH, RedstoneSide.SIDE)).setValue(WEST, RedstoneSide.SIDE);
        for (BlockState blockState : this.getStateDefinition().getPossibleStates()) {
            if (blockState.getValue(POWER) != 0) continue;
            SHAPES_CACHE.put(blockState, this.calculateShape(blockState));
        }
    }

    private VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelShape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneSide = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneSide == RedstoneSide.SIDE) {
                voxelShape = Shapes.or(voxelShape, SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneSide != RedstoneSide.UP) continue;
            voxelShape = Shapes.or(voxelShape, SHAPES_UP.get(direction));
        }
        return voxelShape;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES_CACHE.get(state.setValue(POWER, 0));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getConnectionState(ctx.getLevel(), this.crossState, ctx.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter world, BlockState state, BlockPos pos) {
        boolean bl7;
        boolean bl = RedStoneWireBlock.isDot(state);
        state = this.getMissingConnections(world, (BlockState)this.defaultBlockState().setValue(POWER, state.getValue(POWER)), pos);
        if (bl && RedStoneWireBlock.isDot(state)) {
            return state;
        }
        boolean bl2 = state.getValue(NORTH).isConnected();
        boolean bl3 = state.getValue(SOUTH).isConnected();
        boolean bl4 = state.getValue(EAST).isConnected();
        boolean bl5 = state.getValue(WEST).isConnected();
        boolean bl6 = !bl2 && !bl3;
        boolean bl8 = bl7 = !bl4 && !bl5;
        if (!bl5 && bl6) {
            state = (BlockState)state.setValue(WEST, RedstoneSide.SIDE);
        }
        if (!bl4 && bl6) {
            state = (BlockState)state.setValue(EAST, RedstoneSide.SIDE);
        }
        if (!bl2 && bl7) {
            state = (BlockState)state.setValue(NORTH, RedstoneSide.SIDE);
        }
        if (!bl3 && bl7) {
            state = (BlockState)state.setValue(SOUTH, RedstoneSide.SIDE);
        }
        return state;
    }

    private BlockState getMissingConnections(BlockGetter world, BlockState state, BlockPos pos) {
        boolean bl = !world.getBlockState(pos.above()).isRedstoneConductor(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected()) continue;
            RedstoneSide redstoneSide = this.getConnectingSide(world, pos, direction, bl);
            state = (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(direction), redstoneSide);
        }
        return state;
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction == Direction.DOWN) {
            return !this.canSurviveOn(world, neighborPos, neighborState) ? Blocks.AIR.defaultBlockState() : state;
        }
        if (direction == Direction.UP) {
            return this.getConnectionState(world, state, pos);
        }
        RedstoneSide redstoneSide = this.getConnectingSide(world, pos, direction);
        return redstoneSide.isConnected() == ((RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() && !RedStoneWireBlock.isCross(state) ? (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(direction), redstoneSide) : this.getConnectionState(world, (BlockState)((BlockState)this.crossState.setValue(POWER, state.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(direction), redstoneSide), pos);
    }

    private static boolean isCross(BlockState state) {
        return state.getValue(NORTH).isConnected() && state.getValue(SOUTH).isConnected() && state.getValue(EAST).isConnected() && state.getValue(WEST).isConnected();
    }

    private static boolean isDot(BlockState state) {
        return !state.getValue(NORTH).isConnected() && !state.getValue(SOUTH).isConnected() && !state.getValue(EAST).isConnected() && !state.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(BlockState state, LevelAccessor world, BlockPos pos, int flags, int maxUpdateDepth) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneSide = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneSide == RedstoneSide.NONE || world.getBlockState(mutableBlockPos.setWithOffset((Vec3i)pos, direction)).is(this)) continue;
            mutableBlockPos.move(Direction.DOWN);
            BlockState blockState = world.getBlockState(mutableBlockPos);
            if (blockState.is(this)) {
                Vec3i blockPos = mutableBlockPos.relative(direction.getOpposite());
                world.neighborShapeChanged(direction.getOpposite(), mutableBlockPos, (BlockPos)blockPos, world.getBlockState((BlockPos)blockPos), flags, maxUpdateDepth);
            }
            mutableBlockPos.setWithOffset((Vec3i)pos, direction).move(Direction.UP);
            BlockState blockState2 = world.getBlockState(mutableBlockPos);
            if (!blockState2.is(this)) continue;
            Vec3i blockPos2 = mutableBlockPos.relative(direction.getOpposite());
            world.neighborShapeChanged(direction.getOpposite(), mutableBlockPos, (BlockPos)blockPos2, world.getBlockState((BlockPos)blockPos2), flags, maxUpdateDepth);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction direction) {
        return this.getConnectingSide(world, pos, direction, !world.getBlockState(pos.above()).isRedstoneConductor(world, pos));
    }

    private RedstoneSide getConnectingSide(BlockGetter world, BlockPos pos, Direction direction, boolean bl) {
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = world.getBlockState(blockPos);
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = blockState.getBlock() instanceof TrapDoorBlock || this.canSurviveOn(world, blockPos, blockState);
            if (bl2 && RedStoneWireBlock.shouldConnectTo(world.getBlockState(blockPos.above()))) {
                if (blockState.isFaceSturdy(world, blockPos, direction.getOpposite())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !RedStoneWireBlock.shouldConnectTo(blockState, direction) && (blockState.isRedstoneConductor(world, blockPos) || !RedStoneWireBlock.shouldConnectTo(world.getBlockState(blockPos.below()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        return this.canSurviveOn(world, blockPos, blockState);
    }

    private boolean canSurviveOn(BlockGetter world, BlockPos pos, BlockState floor) {
        return floor.isFaceSturdy(world, pos, Direction.UP) || floor.is(Blocks.HOPPER);
    }

    private void updateSurroundingRedstone(Level worldIn, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean blockAdded) {
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT) {
            BlockPos source = null;
            if (orientation != null) {
                source = pos.relative(orientation.getFront().getOpposite());
            }
            this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
            return;
        }
        this.updatePowerStrength(worldIn, pos, state, orientation, blockAdded);
    }

    public BlockState calculateCurrentChanges(Level level, BlockPos pos, BlockState state) {
        int newPower;
        int oldPower = state.getValue(POWER);
        if (oldPower != (newPower = ((DefaultRedstoneWireEvaluator)this.evaluator).calculateTargetStrength(level, pos))) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), oldPower, newPower);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            newPower = event.getNewCurrent();
            if (level.getBlockState(pos) == state && level.setBlock(pos, state = (BlockState)state.setValue(POWER, newPower), 18)) {
                this.turbo.updateNeighborShapes(level, pos, state);
            }
        }
        return state;
    }

    private void updatePowerStrength(Level world, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean blockAdded) {
        if (RedStoneWireBlock.useExperimentalEvaluator(world)) {
            new ExperimentalRedstoneWireEvaluator(this).updatePowerStrength(world, pos, state, orientation, blockAdded);
        } else {
            this.evaluator.updatePowerStrength(world, pos, state, orientation, blockAdded);
        }
    }

    public int getBlockSignal(Level world, BlockPos pos) {
        this.shouldSignal = false;
        int i = world.getBestNeighborSignal(pos);
        this.shouldSignal = true;
        return i;
    }

    private void checkCornerChangeAt(Level world, BlockPos pos) {
        if (world.getBlockState(pos).is(this)) {
            world.updateNeighborsAt(pos, this);
            for (Direction direction : Direction.values()) {
                world.updateNeighborsAt(pos.relative(direction), this);
            }
        }
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock()) && !world.isClientSide) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireAdded(pos, state);
            } else {
                this.updateSurroundingRedstone(world, pos, state, null, true);
            }
            for (Direction direction : Direction.Plane.VERTICAL) {
                world.updateNeighborsAt(pos.relative(direction), this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!moved && !state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, moved);
            if (!world.isClientSide) {
                for (Direction direction : Direction.values()) {
                    world.updateNeighborsAt(pos.relative(direction), this);
                }
                if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                    world.getWireHandler().onWireRemoved(pos, state);
                } else {
                    this.updateSurroundingRedstone(world, pos, state, null, false);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(world, pos.relative(direction));
        }
        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction2);
            if (world.getBlockState(blockPos).isRedstoneConductor(world, blockPos)) {
                this.checkCornerChangeAt(world, blockPos.above());
                continue;
            }
            this.checkCornerChangeAt(world, blockPos.below());
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (!world.isClientSide) {
            if (world.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                world.getWireHandler().onWireUpdated(pos, state, wireOrientation);
            } else if (sourceBlock != this || !RedStoneWireBlock.useExperimentalEvaluator(world)) {
                if (state.canSurvive(world, pos)) {
                    this.updateSurroundingRedstone(world, pos, state, wireOrientation, false);
                } else {
                    RedStoneWireBlock.dropResources(state, world, pos);
                    world.removeBlock(pos, false);
                }
            }
        }
    }

    private static boolean useExperimentalEvaluator(Level world) {
        return world.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS);
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return !this.shouldSignal ? 0 : state.getSignal(world, pos, direction);
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        if (this.shouldSignal && direction != Direction.DOWN) {
            int i = state.getValue(POWER);
            if (i == 0) {
                return 0;
            }
            return direction != Direction.UP && !((RedstoneSide)this.getConnectionState(world, state, pos).getValue(PROPERTY_BY_DIRECTION.get(direction.getOpposite()))).isConnected() ? 0 : i;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState state) {
        return RedStoneWireBlock.shouldConnectTo(state, null);
    }

    protected static boolean shouldConnectTo(BlockState state, @Nullable Direction dir) {
        if (state.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (state.is(Blocks.REPEATER)) {
            Direction direction = state.getValue(HorizontalDirectionalBlock.FACING);
            return direction == dir || direction.getOpposite() == dir;
        }
        return state.is(Blocks.OBSERVER) ? dir == state.getValue(DirectionalBlock.FACING) : state.isSignalSource() && dir != null;
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int powerLevel) {
        return COLORS[powerLevel];
    }

    private static void spawnParticlesAlongLine(Level world, RandomSource random, BlockPos pos, int color, Direction perpendicular, Direction direction, float minOffset, float maxOffset) {
        float f = maxOffset - minOffset;
        if (!(random.nextFloat() >= 0.2f * f)) {
            float g = 0.4375f;
            float h = minOffset + f * random.nextFloat();
            double d = 0.5 + (double)(0.4375f * (float)perpendicular.getStepX()) + (double)(h * (float)direction.getStepX());
            double e = 0.5 + (double)(0.4375f * (float)perpendicular.getStepY()) + (double)(h * (float)direction.getStepY());
            double i = 0.5 + (double)(0.4375f * (float)perpendicular.getStepZ()) + (double)(h * (float)direction.getStepZ());
            world.addParticle(new DustParticleOptions(color, 1.0f), (double)pos.getX() + d, (double)pos.getY() + e, (double)pos.getZ() + i, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int i = state.getValue(POWER);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneSide = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneSide) {
                    case UP: {
                        RedStoneWireBlock.spawnParticlesAlongLine(world, random, pos, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        RedStoneWireBlock.spawnParticlesAlongLine(world, random, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                RedStoneWireBlock.spawnParticlesAlongLine(world, random, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(EAST, state.getValue(WEST))).setValue(SOUTH, state.getValue(NORTH))).setValue(WEST, state.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(EAST))).setValue(EAST, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(WEST))).setValue(WEST, state.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(WEST))).setValue(EAST, state.getValue(NORTH))).setValue(SOUTH, state.getValue(EAST))).setValue(WEST, state.getValue(SOUTH));
            }
        }
        return state;
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, state.getValue(WEST))).setValue(WEST, state.getValue(EAST));
            }
        }
        return super.mirror(state, mirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(state) || RedStoneWireBlock.isDot(state)) {
            BlockState blockState = RedStoneWireBlock.isCross(state) ? this.defaultBlockState() : this.crossState;
            blockState = (BlockState)blockState.setValue(POWER, state.getValue(POWER));
            if ((blockState = this.getConnectionState(world, blockState, pos)) != state) {
                world.setBlock(pos, blockState, 3);
                this.updatesOnShapeChange(world, pos, state, blockState);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level world, BlockPos pos, BlockState oldState, BlockState newState) {
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, null, Direction.UP);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            if (((RedstoneSide)oldState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() == ((RedstoneSide)newState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() || !world.getBlockState(blockPos).isRedstoneConductor(world, blockPos)) continue;
            world.updateNeighborsAtExceptFromFacing(blockPos, newState.getBlock(), direction.getOpposite(), ExperimentalRedstoneUtils.withFront(orientation, direction));
        }
    }
}

