/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;

public class RepeaterBlock
extends DiodeBlock {
    public static final MapCodec<RepeaterBlock> CODEC = RepeaterBlock.simpleCodec(RepeaterBlock::new);
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final IntegerProperty DELAY = BlockStateProperties.DELAY;

    @Override
    public MapCodec<RepeaterBlock> codec() {
        return CODEC;
    }

    protected RepeaterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(HorizontalDirectionalBlock.FACING, Direction.NORTH)).setValue(DELAY, 1)).setValue(LOCKED, false)).setValue(DiodeBlock.POWERED, false));
    }

    @Override
    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        world.setBlock(pos, (BlockState)state.cycle(DELAY), 3);
        return InteractionResult.SUCCESS;
    }

    @Override
    @Override
    protected int getDelay(BlockState state) {
        return state.getValue(DELAY) * 2;
    }

    @Override
    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = super.getStateForPlacement(ctx);
        return (BlockState)blockState.setValue(LOCKED, this.isLocked(ctx.getLevel(), ctx.getClickedPos(), blockState));
    }

    @Override
    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction == Direction.DOWN && !this.canSurviveOn(world, neighborPos, neighborState)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!world.isClientSide() && direction.getAxis() != state.getValue(HorizontalDirectionalBlock.FACING).getAxis()) {
            return (BlockState)state.setValue(LOCKED, this.isLocked(world, pos, state));
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Override
    public boolean isLocked(LevelReader world, BlockPos pos, BlockState state) {
        return this.getAlternateSignal(world, pos, state) > 0;
    }

    @Override
    @Override
    protected boolean sideInputDiodesOnly() {
        return true;
    }

    @Override
    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!state.getValue(DiodeBlock.POWERED).booleanValue()) {
            return;
        }
        Direction direction = state.getValue(HorizontalDirectionalBlock.FACING);
        double d = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
        double e = (double)pos.getY() + 0.4 + (random.nextDouble() - 0.5) * 0.2;
        double f = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.2;
        float g = -5.0f;
        if (random.nextBoolean()) {
            g = state.getValue(DELAY) * 2 - 1;
        }
        double h = (g /= 16.0f) * (float)direction.getStepX();
        double i = g * (float)direction.getStepZ();
        world.addParticle(DustParticleOptions.REDSTONE, d + h, e, f + i, 0.0, 0.0, 0.0);
    }

    @Override
    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(HorizontalDirectionalBlock.FACING, DELAY, LOCKED, DiodeBlock.POWERED);
    }
}

