/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.event.Event;
import org.bukkit.event.block.SpongeAbsorbEvent;

public class SpongeBlock
extends Block {
    public static final MapCodec<SpongeBlock> CODEC = SpongeBlock.simpleCodec(SpongeBlock::new);
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public MapCodec<SpongeBlock> codec() {
        return CODEC;
    }

    protected SpongeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock())) {
            this.tryAbsorbWater(world, pos);
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        this.tryAbsorbWater(world, pos);
        super.neighborChanged(state, world, pos, sourceBlock, wireOrientation, notify);
    }

    protected void tryAbsorbWater(Level world, BlockPos pos) {
        if (this.removeWaterBreadthFirstSearch(world, pos)) {
            world.setBlock(pos, Blocks.WET_SPONGE.defaultBlockState(), 2);
            world.playSound((Player)null, pos, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level world, BlockPos pos) {
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        BlockPos.breadthFirstTraversal(pos, 6, 65, (blockposition1, consumer) -> {
            for (Direction enumdirection : ALL_DIRECTIONS) {
                consumer.accept(blockposition1.relative(enumdirection));
            }
        }, blockposition1 -> {
            BucketPickup ifluidsource;
            if (blockposition1.equals(pos)) {
                return true;
            }
            BlockState iblockdata = blockList.getBlockState((BlockPos)blockposition1);
            FluidState fluid = blockList.getFluidState((BlockPos)blockposition1);
            if (!fluid.is(FluidTags.WATER)) {
                return false;
            }
            Block block = iblockdata.getBlock();
            if (block instanceof BucketPickup && !(ifluidsource = (BucketPickup)((Object)block)).pickupBlock(null, blockList, (BlockPos)blockposition1, iblockdata).isEmpty()) {
                return true;
            }
            if (iblockdata.getBlock() instanceof LiquidBlock) {
                blockList.setBlock((BlockPos)blockposition1, Blocks.AIR.defaultBlockState(), 3);
            } else {
                if (!(iblockdata.is(Blocks.KELP) || iblockdata.is(Blocks.KELP_PLANT) || iblockdata.is(Blocks.SEAGRASS) || iblockdata.is(Blocks.TALL_SEAGRASS))) {
                    return false;
                }
                blockList.setBlock((BlockPos)blockposition1, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        });
        List<CraftBlockState> blocks = blockList.getList();
        if (!blocks.isEmpty()) {
            org.bukkit.block.Block bblock = world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            SpongeAbsorbEvent event = new SpongeAbsorbEvent(bblock, blocks);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            for (CraftBlockState block : blocks) {
                BlockPos blockposition12 = block.getPosition();
                BlockState iblockdata = world.getBlockState(blockposition12);
                FluidState fluid = world.getFluidState(blockposition12);
                if (fluid.is(FluidTags.WATER) && (!(iblockdata.getBlock() instanceof BucketPickup) || ((BucketPickup)((Object)iblockdata.getBlock())).pickupBlock(null, blockList, blockposition12, iblockdata).isEmpty()) && !(iblockdata.getBlock() instanceof LiquidBlock) && (iblockdata.is(Blocks.KELP) || iblockdata.is(Blocks.KELP_PLANT) || iblockdata.is(Blocks.SEAGRASS) || iblockdata.is(Blocks.TALL_SEAGRASS))) {
                    BlockEntity tileentity;
                    BlockEntity blockEntity = tileentity = iblockdata.hasBlockEntity() ? world.getBlockEntity(blockposition12) : null;
                    if (block.getHandle().isAir()) {
                        SpongeBlock.dropResources(iblockdata, world, blockposition12, tileentity);
                    }
                }
                world.setBlock(blockposition12, block.getHandle(), block.getFlag());
            }
            return true;
        }
        return false;
    }
}

