/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public abstract class SpreadingSnowyDirtBlock
extends SnowyDirtBlock {
    protected SpreadingSnowyDirtBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    private static boolean canBeGrass(BlockState state, LevelReader world, BlockPos pos) {
        return SpreadingSnowyDirtBlock.canBeGrass(world.getChunk(pos), state, world, pos);
    }

    private static boolean canBeGrass(ChunkAccess chunk, BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockposition1 = pos.above();
        BlockState iblockdata1 = chunk.getBlockState(blockposition1);
        if (iblockdata1.is(Blocks.SNOW) && iblockdata1.getValue(SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (iblockdata1.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto(state, iblockdata1, Direction.UP, iblockdata1.getLightBlock());
        return i < 15;
    }

    protected abstract MapCodec<? extends SpreadingSnowyDirtBlock> codec();

    private static boolean canPropagate(BlockState state, LevelReader world, BlockPos pos) {
        return SpreadingSnowyDirtBlock.canPropagate(world.getChunk(pos), state, world, pos);
    }

    private static boolean canPropagate(ChunkAccess chunk, BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockposition1 = pos.above();
        return SpreadingSnowyDirtBlock.canBeGrass(chunk, state, world, pos) && !chunk.getFluidState(blockposition1).is(FluidTags.WATER);
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this instanceof GrassBlock && world.paperConfig().tickRates.grassSpread != 1 && (world.paperConfig().tickRates.grassSpread < 1 || (MinecraftServer.currentTick + pos.hashCode()) % world.paperConfig().tickRates.grassSpread != 0)) {
            return;
        }
        LevelChunk cachedBlockChunk = world.getChunkIfLoaded(pos);
        if (cachedBlockChunk == null) {
            return;
        }
        if (!SpreadingSnowyDirtBlock.canBeGrass(cachedBlockChunk, state, world, pos)) {
            if (CraftEventFactory.callBlockFadeEvent(world, pos, Blocks.DIRT.defaultBlockState()).isCancelled()) {
                return;
            }
            world.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        } else if (world.getMaxLocalRawBrightness(pos.above()) >= 9) {
            BlockState iblockdata1 = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                LevelChunk access;
                BlockPos blockposition1 = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (pos.getX() == blockposition1.getX() && pos.getY() == blockposition1.getY() && pos.getZ() == blockposition1.getZ() || !(access = cachedBlockChunk.locX == blockposition1.getX() >> 4 && cachedBlockChunk.locZ == blockposition1.getZ() >> 4 ? cachedBlockChunk : world.getChunkAt(blockposition1)).getBlockState(blockposition1).is(Blocks.DIRT) || !SpreadingSnowyDirtBlock.canPropagate(access, iblockdata1, world, blockposition1)) continue;
                CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, (BlockState)iblockdata1.setValue(SnowyDirtBlock.SNOWY, access.getBlockState(blockposition1.above()).is(Blocks.SNOW)));
            }
        }
    }
}

