/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class StemBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<StemBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec(Registries.BLOCK).fieldOf("fruit").forGetter(blockstem -> blockstem.fruit), (App)ResourceKey.codec(Registries.BLOCK).fieldOf("attached_stem").forGetter(blockstem -> blockstem.attachedStem), (App)ResourceKey.codec(Registries.ITEM).fieldOf("seed").forGetter(blockstem -> blockstem.seed), StemBlock.propertiesCodec()).apply((Applicative)instance, StemBlock::new));
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final ResourceKey<Block> fruit;
    private final ResourceKey<Block> attachedStem;
    private final ResourceKey<Item> seed;

    public MapCodec<StemBlock> codec() {
        return CODEC;
    }

    protected StemBlock(ResourceKey<Block> gourdBlock, ResourceKey<Block> attachedStemBlock, ResourceKey<Item> pickBlockItem, BlockBehaviour.Properties settings) {
        super(settings);
        this.fruit = gourdBlock;
        this.attachedStem = attachedStemBlock;
        this.seed = pickBlockItem;
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(AGE, 0));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[state.getValue(AGE)];
    }

    @Override
    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(Blocks.FARMLAND);
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.getRawBrightness(pos, 0) >= 9) {
            float f = CropBlock.getGrowthSpeed(this, world, pos);
            double d = random.nextFloat();
            int n = this == Blocks.PUMPKIN_STEM ? world.spigotConfig.pumpkinModifier : world.spigotConfig.melonModifier;
            if (d < (double)n / (100.0 * Math.floor(25.0f / f + 1.0f))) {
                int i = state.getValue(AGE);
                if (i < 7) {
                    state = (BlockState)state.setValue(AGE, i + 1);
                    CraftEventFactory.handleBlockGrowEvent(world, pos, state, 2);
                } else {
                    Direction enumdirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                    BlockPos blockposition1 = pos.relative(enumdirection);
                    BlockState iblockdata1 = world.getBlockState(blockposition1.below());
                    if (world.getBlockState(blockposition1).isAir() && (iblockdata1.is(Blocks.FARMLAND) || iblockdata1.is(BlockTags.DIRT))) {
                        HolderLookup.RegistryLookup iregistry = world.registryAccess().lookupOrThrow(Registries.BLOCK);
                        Optional<Block> optional = iregistry.getOptional(this.fruit);
                        Optional<Block> optional1 = iregistry.getOptional(this.attachedStem);
                        if (optional.isPresent() && optional1.isPresent()) {
                            if (!CraftEventFactory.handleBlockGrowEvent(world, blockposition1, optional.get().defaultBlockState())) {
                                return;
                            }
                            world.setBlockAndUpdate(pos, (BlockState)optional1.get().defaultBlockState().setValue(HorizontalDirectionalBlock.FACING, enumdirection));
                        }
                    }
                }
            }
        }
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)DataFixUtils.orElse(world.registryAccess().lookupOrThrow(Registries.ITEM).getOptional(this.seed), (Object)this));
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return state.getValue(AGE) != 7;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(7, state.getValue(AGE) + Mth.nextInt(world.random, 2, 5));
        BlockState iblockdata1 = (BlockState)state.setValue(AGE, i);
        CraftEventFactory.handleBlockGrowEvent(world, pos, iblockdata1, 2);
        if (i == 7) {
            iblockdata1.randomTick(world, pos, world.random);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AGE);
    }
}

