/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.TNTPrimeEvent;

public class TntBlock
extends Block {
    public static final MapCodec<TntBlock> CODEC = TntBlock.simpleCodec(TntBlock::new);
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public MapCodec<TntBlock> codec() {
        return CODEC;
    }

    public TntBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(UNSTABLE, false));
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock()) && world.hasNeighborSignal(pos) && CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null)) {
            CraftBlock tntBlock = CraftBlock.at(world, pos);
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.REDSTONE, null).callEvent()) {
                return;
            }
            TntBlock.explode(world, pos);
            world.removeBlock(pos, false);
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (world.hasNeighborSignal(pos) && CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null)) {
            CraftBlock tntBlock = CraftBlock.at(world, pos);
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.REDSTONE, null).callEvent()) {
                return;
            }
            TntBlock.explode(world, pos);
            world.removeBlock(pos, false);
        }
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide() && !player.isCreative() && state.getValue(UNSTABLE).booleanValue() && CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, player, null)) {
            TntBlock.explode(world, pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Override
    public void wasExploded(ServerLevel world, BlockPos pos, Explosion explosion) {
        CraftEntity source;
        CraftBlock tntBlock = CraftBlock.at(world, pos);
        CraftEntity craftEntity = source = explosion.getDirectSourceEntity() != null ? explosion.getDirectSourceEntity().getBukkitEntity() : null;
        if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.EXPLOSION, (Entity)source).callEvent()) {
            return;
        }
        PrimedTnt entitytntprimed = new PrimedTnt(world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity());
        int i = entitytntprimed.getFuse();
        entitytntprimed.setFuse((short)(world.random.nextInt(i / 4) + i / 8));
        world.addFreshEntity(entitytntprimed);
    }

    public static void explode(Level world, BlockPos pos) {
        TntBlock.explode(world, pos, null);
    }

    private static void explode(Level world, BlockPos pos, @Nullable LivingEntity igniter) {
        if (!world.isClientSide) {
            PrimedTnt entitytntprimed = new PrimedTnt(world, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, igniter);
            world.addFreshEntity(entitytntprimed);
            world.playSound((Player)null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((net.minecraft.world.entity.Entity)igniter, GameEvent.PRIME_FUSE, pos);
        }
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!stack.is(Items.FLINT_AND_STEEL) && !stack.is(Items.FIRE_CHARGE)) {
            return super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        if (!CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.PLAYER, player, null)) {
            return InteractionResult.CONSUME;
        }
        CraftBlock tntBlock = CraftBlock.at(world, pos);
        if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.ITEM, (Entity)player.getBukkitEntity()).callEvent()) {
            return InteractionResult.FAIL;
        }
        TntBlock.explode(world, pos, player);
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        Item item = stack.getItem();
        if (stack.is(Items.FLINT_AND_STEEL)) {
            stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand(hand));
        } else {
            stack.consume(1, player);
        }
        player.awardStat(Stats.ITEM_USED.get(item));
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition = hit.getBlockPos();
            net.minecraft.world.entity.Entity entity = projectile.getOwner();
            if (projectile.isOnFire() && projectile.mayInteract(worldserver, blockposition)) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, state.getFluidState().createLegacyBlock()) || !CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PROJECTILE, projectile, null)) {
                    return;
                }
                CraftBlock tntBlock = CraftBlock.at(world, blockposition);
                if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.PROJECTILE, (Entity)projectile.getBukkitEntity()).callEvent()) {
                    return;
                }
                TntBlock.explode(world, blockposition, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                world.removeBlock(blockposition, false);
            }
        }
    }

    @Override
    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(UNSTABLE);
    }
}

