/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class TripWireBlock
extends Block {
    public static final MapCodec<TripWireBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("hook").forGetter(blocktripwire -> blocktripwire.hook), TripWireBlock.propertiesCodec()).apply((Applicative)instance, TripWireBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty DISARMED = BlockStateProperties.DISARMED;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = CrossCollisionBlock.PROPERTY_BY_DIRECTION;
    protected static final VoxelShape AABB = Block.box(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int RECHECK_PERIOD = 10;
    private final Block hook;

    public MapCodec<TripWireBlock> codec() {
        return CODEC;
    }

    public TripWireBlock(Block hookBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = hookBlock;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(ATTACHED) != false ? AABB : NOT_ATTACHED_AABB;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return this.defaultBlockState();
        }
        Level world = ctx.getLevel();
        BlockPos blockposition = ctx.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo(world.getBlockState(blockposition.north()), Direction.NORTH))).setValue(EAST, this.shouldConnectTo(world.getBlockState(blockposition.east()), Direction.EAST))).setValue(SOUTH, this.shouldConnectTo(world.getBlockState(blockposition.south()), Direction.SOUTH))).setValue(WEST, this.shouldConnectTo(world.getBlockState(blockposition.west()), Direction.WEST));
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(direction), this.shouldConnectTo(neighborState, direction)) : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!oldState.is(state.getBlock())) {
            this.updateSource(world, pos, state);
        }
    }

    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!moved && !state.is(newState.getBlock())) {
            this.updateSource(world, pos, (BlockState)state.setValue(POWERED, true));
        }
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        if (!world.isClientSide && !player.getMainHandItem().isEmpty() && player.getMainHandItem().is(Items.SHEARS)) {
            world.setBlock(pos, (BlockState)state.setValue(DISARMED, true), 4);
            world.gameEvent((net.minecraft.world.entity.Entity)player, GameEvent.SHEAR, pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    private void updateSource(Level world, BlockPos pos, BlockState state) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        block0: for (Direction enumdirection : new Direction[]{Direction.SOUTH, Direction.WEST}) {
            for (int k = 1; k < 42; ++k) {
                BlockPos blockposition1 = pos.relative(enumdirection, k);
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                if (iblockdata1.is(this.hook)) {
                    if (iblockdata1.getValue(TripWireHookBlock.FACING) != enumdirection.getOpposite()) continue block0;
                    TripWireHookBlock.calculateState(world, blockposition1, iblockdata1, false, true, k, state);
                    continue block0;
                }
                if (!iblockdata1.is(this)) continue block0;
            }
        }
    }

    @Override
    protected VoxelShape getEntityInsideCollisionShape(BlockState state, Level world, BlockPos pos) {
        return state.getShape(world, pos);
    }

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.isClientSide && !state.getValue(POWERED).booleanValue()) {
            this.checkPressed(world, pos, List.of(entity));
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (world.getBlockState(pos).getValue(POWERED).booleanValue()) {
            this.checkPressed(world, pos);
        }
    }

    private void checkPressed(Level world, BlockPos pos) {
        BlockState iblockdata = world.getBlockState(pos);
        List<net.minecraft.world.entity.Entity> list = world.getEntities(null, iblockdata.getShape(world, pos).bounds().move(pos));
        this.checkPressed(world, pos, list);
    }

    private void checkPressed(Level world, BlockPos pos, List<? extends net.minecraft.world.entity.Entity> entities) {
        BlockState iblockdata = world.getBlockState(pos);
        boolean flag = iblockdata.getValue(POWERED);
        boolean flag1 = false;
        if (!entities.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : entities) {
                if (entity.isIgnoringBlockTriggers()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag != flag1 && flag1 && iblockdata.getValue(ATTACHED).booleanValue()) {
            CraftWorld bworld = world.getWorld();
            PluginManager pluginManager = world.getCraftServer().getPluginManager();
            org.bukkit.block.Block block = bworld.getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            boolean allowed = false;
            for (net.minecraft.world.entity.Entity entity : entities) {
                PlayerInteractEvent cancellable;
                if (entity == null) continue;
                if (entity instanceof Player) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, pos, null, null, null);
                } else {
                    if (!(entity instanceof net.minecraft.world.entity.Entity)) continue;
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), block);
                    pluginManager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag1 != flag) {
            iblockdata = (BlockState)iblockdata.setValue(POWERED, flag1);
            world.setBlock(pos, iblockdata, 3);
            this.updateSource(world, pos, iblockdata);
        }
        if (flag1) {
            world.scheduleTick(new BlockPos(pos), this, 10);
        }
    }

    public boolean shouldConnectTo(BlockState state, Direction facing) {
        return state.is(this.hook) ? state.getValue(TripWireHookBlock.FACING) == facing.getOpposite() : state.is(this);
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(EAST, state.getValue(WEST))).setValue(SOUTH, state.getValue(NORTH))).setValue(WEST, state.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(EAST))).setValue(EAST, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(WEST))).setValue(WEST, state.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(WEST))).setValue(EAST, state.getValue(NORTH))).setValue(SOUTH, state.getValue(EAST))).setValue(WEST, state.getValue(SOUTH));
            }
        }
        return state;
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, state.getValue(WEST))).setValue(WEST, state.getValue(EAST));
            }
        }
        return super.mirror(state, mirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

