/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WitherSkullBlock
extends SkullBlock {
    public static final MapCodec<WitherSkullBlock> CODEC = WitherSkullBlock.simpleCodec(WitherSkullBlock::new);
    @Nullable
    private static BlockPattern witherPatternFull;
    @Nullable
    private static BlockPattern witherPatternBase;

    public MapCodec<WitherSkullBlock> codec() {
        return CODEC;
    }

    protected WitherSkullBlock(BlockBehaviour.Properties settings) {
        super(SkullBlock.Types.WITHER_SKELETON, settings);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        WitherSkullBlock.checkSpawn(world, pos);
    }

    public static void checkSpawn(Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SkullBlockEntity) {
            SkullBlockEntity tileentityskull = (SkullBlockEntity)tileentity;
            WitherSkullBlock.checkSpawn(world, pos, tileentityskull);
        }
    }

    public static void checkSpawn(Level world, BlockPos pos, SkullBlockEntity blockEntity) {
        if (world.captureBlockStates) {
            return;
        }
        if (!world.isClientSide) {
            WitherBoss entitywither;
            BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection;
            boolean flag;
            BlockState iblockdata = blockEntity.getBlockState();
            boolean bl = flag = iblockdata.is(Blocks.WITHER_SKELETON_SKULL) || iblockdata.is(Blocks.WITHER_SKELETON_WALL_SKULL);
            if (flag && pos.getY() >= world.getMinY() && world.getDifficulty() != Difficulty.PEACEFUL && (shapedetector_shapedetectorcollection = WitherSkullBlock.getOrCreateWitherFull().find(world, pos)) != null && (entitywither = EntityType.WITHER.create(world, EntitySpawnReason.TRIGGERED)) != null) {
                BlockPos blockposition1 = shapedetector_shapedetectorcollection.getBlock(1, 2, 0).getPos();
                entitywither.moveTo((double)blockposition1.getX() + 0.5, (double)blockposition1.getY() + 0.55, (double)blockposition1.getZ() + 0.5, shapedetector_shapedetectorcollection.getForwards().getAxis() == Direction.Axis.X ? 0.0f : 90.0f, 0.0f);
                entitywither.yBodyRot = shapedetector_shapedetectorcollection.getForwards().getAxis() == Direction.Axis.X ? 0.0f : 90.0f;
                entitywither.makeInvulnerable();
                if (!world.addFreshEntity(entitywither, CreatureSpawnEvent.SpawnReason.BUILD_WITHER)) {
                    return;
                }
                CarvedPumpkinBlock.clearPatternBlocks(world, shapedetector_shapedetectorcollection);
                for (ServerPlayer entityplayer : world.getEntitiesOfClass(ServerPlayer.class, entitywither.getBoundingBox().inflate(50.0))) {
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(entityplayer, entitywither);
                }
                CarvedPumpkinBlock.updatePatternBlocks(world, shapedetector_shapedetectorcollection);
            }
        }
    }

    public static boolean canSpawnMob(Level world, BlockPos pos, ItemStack stack) {
        return stack.is(Items.WITHER_SKELETON_SKULL) && pos.getY() >= world.getMinY() + 2 && world.getDifficulty() != Difficulty.PEACEFUL && !world.isClientSide ? WitherSkullBlock.getOrCreateWitherBase().find(world, pos) != null : false;
    }

    private static BlockPattern getOrCreateWitherFull() {
        if (witherPatternFull == null) {
            witherPatternFull = BlockPatternBuilder.start().aisle("^^^", "###", "~#~").where('#', shapedetectorblock -> shapedetectorblock.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('^', BlockInWorld.hasState(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_SKULL).or(BlockStatePredicate.forBlock(Blocks.WITHER_SKELETON_WALL_SKULL)))).where('~', shapedetectorblock -> shapedetectorblock.getState().isAir()).build();
        }
        return witherPatternFull;
    }

    private static BlockPattern getOrCreateWitherBase() {
        if (witherPatternBase == null) {
            witherPatternBase = BlockPatternBuilder.start().aisle("   ", "###", "~#~").where('#', shapedetectorblock -> shapedetectorblock.getState().is(BlockTags.WITHER_SUMMON_BASE_BLOCKS)).where('~', shapedetectorblock -> shapedetectorblock.getState().isAir()).build();
        }
        return witherPatternBase;
    }
}

