/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    public static final int UNKNOWN_LIT_DURATION = 0;
    protected NonNullList<net.minecraft.world.item.ItemStack> items;
    public int litTime;
    int litDuration = 0;
    public double cookSpeedMultiplier = 1.0;
    public int cookingProgress;
    public int cookingTotalTime;
    protected final ContainerData dataAccess;
    public final Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    public final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        super(blockEntityType, pos, state);
        this.items = NonNullList.withSize(3, net.minecraft.world.item.ItemStack.EMPTY);
        this.dataAccess = new ContainerData(){

            @Override
            public int get(int index) {
                switch (index) {
                    case 0: {
                        return AbstractFurnaceBlockEntity.this.litTime;
                    }
                    case 1: {
                        return AbstractFurnaceBlockEntity.this.litDuration;
                    }
                    case 2: {
                        return AbstractFurnaceBlockEntity.this.cookingProgress;
                    }
                    case 3: {
                        return AbstractFurnaceBlockEntity.this.cookingTotalTime;
                    }
                }
                return 0;
            }

            @Override
            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractFurnaceBlockEntity.this.litTime = value;
                        break;
                    }
                    case 1: {
                        AbstractFurnaceBlockEntity.this.litDuration = value;
                        break;
                    }
                    case 2: {
                        AbstractFurnaceBlockEntity.this.cookingProgress = value;
                        break;
                    }
                    case 3: {
                        AbstractFurnaceBlockEntity.this.cookingTotalTime = value;
                    }
                }
            }

            @Override
            public int getCount() {
                return 4;
            }
        };
        this.recipesUsed = new Reference2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck(recipeType);
        this.recipeType = recipeType;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerHelper.loadAllItems(nbt, this.items, registries);
        this.litTime = nbt.getShort("BurnTime");
        this.cookingProgress = nbt.getShort("CookTime");
        this.cookingTotalTime = nbt.getShort("CookTimeTotal");
        this.litDuration = 0;
        CompoundTag nbttagcompound1 = nbt.getCompound("RecipesUsed");
        for (String s : nbttagcompound1.getAllKeys()) {
            ResourceLocation resourceLocation = ResourceLocation.tryParse(s);
            if (resourceLocation == null) continue;
            this.recipesUsed.put(ResourceKey.create(Registries.RECIPE, resourceLocation), nbttagcompound1.getInt(s));
        }
        if (nbt.contains("Paper.CookSpeedMultiplier")) {
            this.cookSpeedMultiplier = nbt.getDouble("Paper.CookSpeedMultiplier");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putShort("BurnTime", (short)this.litTime);
        nbt.putShort("CookTime", (short)this.cookingProgress);
        nbt.putShort("CookTimeTotal", (short)this.cookingTotalTime);
        nbt.putDouble("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerHelper.saveAllItems(nbt, this.items, registries);
        CompoundTag nbttagcompound1 = new CompoundTag();
        this.recipesUsed.forEach((resourcekey, integer) -> nbttagcompound1.putInt(resourcekey.location().toString(), (int)integer));
        nbt.put("RecipesUsed", nbttagcompound1);
    }

    public static void serverTick(ServerLevel world, BlockPos pos, BlockState state, AbstractFurnaceBlockEntity blockEntity) {
        boolean flag3;
        boolean flag = blockEntity.isLit();
        boolean flag1 = false;
        if (blockEntity.isLit()) {
            --blockEntity.litTime;
        }
        net.minecraft.world.item.ItemStack itemstack = blockEntity.items.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = blockEntity.items.get(0);
        boolean flag2 = !itemstack1.isEmpty();
        boolean bl = flag3 = !itemstack.isEmpty();
        if (blockEntity.litDuration == 0) {
            blockEntity.litDuration = blockEntity.getBurnDuration(world.fuelValues(), itemstack);
        }
        if (!(blockEntity.isLit() || flag3 && flag2)) {
            if (!blockEntity.isLit() && blockEntity.cookingProgress > 0) {
                blockEntity.cookingProgress = Mth.clamp(blockEntity.cookingProgress - 2, 0, blockEntity.cookingTotalTime);
            }
        } else {
            SingleRecipeInput singlerecipeinput = new SingleRecipeInput(itemstack1);
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)blockEntity.quickCheck.getRecipeFor(singlerecipeinput, world).orElse(null) : null;
            int i = blockEntity.getMaxStackSize();
            if (!blockEntity.isLit() && AbstractFurnaceBlockEntity.canBurn(world.registryAccess(), recipeholder, singlerecipeinput, blockEntity.items, i)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, pos), (ItemStack)fuel, blockEntity.getBurnDuration(world.fuelValues(), itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                blockEntity.litDuration = blockEntity.litTime = furnaceBurnEvent.getBurnTime();
                if (blockEntity.isLit() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3 && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemstack.getItem();
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            blockEntity.items.set(1, item.getCraftingRemainder());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && AbstractFurnaceBlockEntity.canBurn(world.registryAccess(), recipeholder, singlerecipeinput, blockEntity.items, i)) {
                if (recipeholder != null && blockEntity.cookingProgress == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(blockEntity.items.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, pos), (ItemStack)source, recipe, AbstractFurnaceBlockEntity.getTotalCookTime(world, blockEntity, blockEntity.recipeType, blockEntity.cookSpeedMultiplier));
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    blockEntity.cookingTotalTime = event.getTotalCookTime();
                }
                ++blockEntity.cookingProgress;
                if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = 0;
                    blockEntity.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(world, blockEntity, blockEntity.recipeType, blockEntity.cookSpeedMultiplier);
                    if (AbstractFurnaceBlockEntity.burn(blockEntity.level, blockEntity.worldPosition, world.registryAccess(), recipeholder, singlerecipeinput, blockEntity.items, i)) {
                        blockEntity.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.cookingProgress = 0;
            }
        }
        if (flag != blockEntity.isLit()) {
            flag1 = true;
            state = (BlockState)state.setValue(AbstractFurnaceBlock.LIT, blockEntity.isLit());
            world.setBlock(pos, state, 3);
        }
        if (flag1) {
            AbstractFurnaceBlockEntity.setChanged(world, pos, state);
        }
    }

    private static boolean canBurn(RegistryAccess dynamicRegistryManager, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, SingleRecipeInput input, NonNullList<net.minecraft.world.item.ItemStack> inventory, int maxCount) {
        if (!inventory.get(0).isEmpty() && recipe != null) {
            net.minecraft.world.item.ItemStack itemstack = recipe.value().assemble(input, (HolderLookup.Provider)dynamicRegistryManager);
            if (itemstack.isEmpty()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = inventory.get(2);
            return itemstack1.isEmpty() ? true : (!net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack1, itemstack) ? false : (itemstack1.getCount() < maxCount && itemstack1.getCount() < itemstack1.getMaxStackSize() ? true : itemstack1.getCount() < itemstack.getMaxStackSize()));
        }
        return false;
    }

    private static boolean burn(Level world, BlockPos blockposition, RegistryAccess iregistrycustom, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipeholder, SingleRecipeInput singlerecipeinput, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i) {
        if (recipeholder != null && AbstractFurnaceBlockEntity.canBurn(iregistrycustom, recipeholder, singlerecipeinput, nonnulllist, i)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.value().assemble(singlerecipeinput, (HolderLookup.Provider)iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result, (CookingRecipe)recipeholder.toBukkitRecipe());
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.isEmpty()) {
                if (itemstack2.isEmpty()) {
                    nonnulllist.set(2, itemstack1.copy());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.grow(itemstack1.getCount());
                } else {
                    return false;
                }
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !nonnulllist.get(1).isEmpty() && nonnulllist.get(1).is(Items.BUCKET)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(FuelValues fuelRegistry, net.minecraft.world.item.ItemStack stack) {
        return fuelRegistry.burnDuration(stack);
    }

    public static int getTotalCookTime(@Nullable ServerLevel world, AbstractFurnaceBlockEntity furnace, RecipeType<? extends AbstractCookingRecipe> recipeType, double cookSpeedMultiplier) {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(furnace.getItem(0));
        int cookTime = world != null ? furnace.quickCheck.getRecipeFor(singlerecipeinput, world).map(holder -> ((AbstractCookingRecipe)holder.value()).cookingTime()).orElse(200) : MinecraftServer.getServer().getRecipeManager().getRecipeFor(recipeType, singlerecipeinput, world).map(holder -> ((AbstractCookingRecipe)holder.value()).cookingTime()).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    @Override
    public int[] getSlotsForFace(Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : (side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, net.minecraft.world.item.ItemStack stack, @Nullable Direction dir) {
        return this.canPlaceItem(slot, stack);
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, net.minecraft.world.item.ItemStack stack, Direction dir) {
        return dir == Direction.DOWN && slot == 1 ? stack.is(Items.WATER_BUCKET) || stack.is(Items.BUCKET) : true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> inventory) {
        this.items = inventory;
    }

    @Override
    public void setItem(int slot, net.minecraft.world.item.ItemStack stack) {
        Level world;
        net.minecraft.world.item.ItemStack itemstack1 = this.items.get(slot);
        boolean flag = !stack.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack1, stack);
        this.items.set(slot, stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (slot == 0 && !flag && (world = this.level) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(worldserver, this, this.recipeType, this.cookSpeedMultiplier);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.items.get(1);
        return this.level.fuelValues().isFuel(stack) || stack.is(Items.BUCKET) && !itemstack1.is(Items.BUCKET);
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceKey<Recipe<?>> resourcekey = recipe.id();
            this.recipesUsed.addTo(resourcekey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(Player player, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.serverLevel(), entityplayer.position(), this.worldPosition, entityplayer, itemstack, amount);
        entityplayer.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel world, Vec3 pos) {
        return this.getRecipesToAwardAndPopExperience(world, pos, this.worldPosition, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel worldserver, Vec3 vec3d, BlockPos blockposition, ServerPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry entry : this.recipesUsed.reference2IntEntrySet()) {
            worldserver.recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(recipeholder -> {
                if (!(recipeholder.value() instanceof AbstractCookingRecipe)) {
                    return;
                }
                list.add(recipeholder);
                AbstractFurnaceBlockEntity.createExperience(worldserver, vec3d, entry.getIntValue(), ((AbstractCookingRecipe)recipeholder.value()).experience(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel worldserver, Vec3 vec3d, int i, float f, BlockPos blockposition, Player entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j = Mth.floor((float)i * f);
        float f1 = Mth.frac((float)i * f);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.getItem()), amount, j) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j = event.getExpToDrop();
        ExperienceOrb.award(worldserver, vec3d, j, ExperienceOrb.SpawnReason.FURNACE, entityhuman);
    }

    @Override
    public void fillStackedContents(StackedItemContents finder) {
        finder.accountStack(this.items.get(0));
        finder.accountStack(this.items.get(2));
    }
}

