/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.block.BlockLockCheckEvent;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;

public abstract class BaseContainerBlockEntity
extends BlockEntity
implements Container,
MenuProvider,
Nameable {
    public LockCode lockKey = LockCode.NO_LOCK;
    @Nullable
    public net.minecraft.network.chat.Component name;

    protected BaseContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.lockKey = LockCode.fromTag(nbt, registries);
        if (nbt.contains("CustomName", 8)) {
            this.name = BaseContainerBlockEntity.parseCustomNameSafe(nbt.getString("CustomName"), registries);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.lockKey.addToTag(nbt, registries);
        if (this.name != null) {
            nbt.putString("CustomName", Component.Serializer.toJson(this.name, registries));
        }
    }

    @Override
    public net.minecraft.network.chat.Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    @Override
    public net.minecraft.network.chat.Component getDisplayName() {
        return this.getName();
    }

    @Override
    @Nullable
    public net.minecraft.network.chat.Component getCustomName() {
        return this.name;
    }

    protected abstract net.minecraft.network.chat.Component getDefaultName();

    public boolean canOpen(Player player) {
        return BaseContainerBlockEntity.canUnlock(player, this.lockKey, this.getDisplayName(), this);
    }

    @Deprecated
    @DoNotUse
    public static boolean canUnlock(Player player, LockCode lock, net.minecraft.network.chat.Component containerName) {
        return BaseContainerBlockEntity.canUnlock(player, lock, containerName, null);
    }

    public static boolean canUnlock(Player player, LockCode lock, net.minecraft.network.chat.Component containerName, @Nullable BlockEntity blockEntity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (blockEntity != null && blockEntity.getLevel() != null && blockEntity.getLevel().getBlockEntity(blockEntity.getBlockPos()) == blockEntity) {
                CraftBlock block = CraftBlock.at(blockEntity.getLevel(), blockEntity.getBlockPos());
                TranslatableComponent lockedMessage = Component.translatable((String)"container.isLocked", (ComponentLike[])new ComponentLike[]{PaperAdventure.asAdventure(containerName)});
                net.kyori.adventure.sound.Sound lockedSound = net.kyori.adventure.sound.Sound.sound((Sound.Type)Sound.BLOCK_CHEST_LOCKED, (Sound.Source)Sound.Source.BLOCK, (float)1.0f, (float)1.0f);
                BlockLockCheckEvent event = new BlockLockCheckEvent((Block)block, (org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (Component)lockedMessage, lockedSound);
                event.callEvent();
                if (event.getResult() == Event.Result.ALLOW) {
                    return true;
                }
                if (event.getResult() == Event.Result.DENY || !player.isSpectator() && !lock.unlocksWith(event.isUsingCustomKeyItemStack() ? CraftItemStack.asNMSCopy(event.getKeyItem()) : player.getMainHandItem())) {
                    if (event.getLockedMessage() != null) {
                        event.getPlayer().sendActionBar(event.getLockedMessage());
                    }
                    if (event.getLockedSound() != null) {
                        event.getPlayer().playSound(event.getLockedSound());
                    }
                    return false;
                }
                return true;
            }
        }
        if (!player.isSpectator() && !lock.unlocksWith(player.getMainHandItem())) {
            player.displayClientMessage(net.minecraft.network.chat.Component.translatable("container.isLocked", containerName), true);
            player.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    protected abstract NonNullList<ItemStack> getItems();

    protected abstract void setItems(NonNullList<ItemStack> var1);

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.getItems().iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public ItemStack getItem(int slot) {
        return this.getItems().get(slot);
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.getItems(), slot, amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), slot);
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    @Override
    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity(this, player);
    }

    @Override
    public void clearContent() {
        this.getItems().clear();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return this.canOpen(player) ? this.createMenu(syncId, playerInventory) : null;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.name = components.get(DataComponents.CUSTOM_NAME);
        this.lockKey = components.getOrDefault(DataComponents.LOCK, LockCode.NO_LOCK);
        components.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, this.name);
        if (!this.lockKey.equals(LockCode.NO_LOCK)) {
            builder.set(DataComponents.LOCK, this.lockKey);
        }
        builder.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(CompoundTag nbt) {
        nbt.remove("CustomName");
        nbt.remove("lock");
        nbt.remove("Items");
    }

    @Override
    public Location getLocation() {
        if (this.level == null) {
            return null;
        }
        return new Location((World)this.level.getWorld(), (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
    }
}

