/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.TargetColorParticleOption;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.creaking.CreakingTransient;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class CreakingHeartBlockEntity
extends BlockEntity {
    private static final int PLAYER_DETECTION_RANGE = 32;
    public static final int CREAKING_ROAMING_RADIUS = 32;
    private static final int DISTANCE_CREAKING_TOO_FAR = 34;
    private static final int SPAWN_RANGE_XZ = 16;
    private static final int SPAWN_RANGE_Y = 8;
    private static final int ATTEMPTS_PER_SPAWN = 5;
    private static final int UPDATE_TICKS = 20;
    private static final int HURT_CALL_TOTAL_TICKS = 100;
    private static final int NUMBER_OF_HURT_CALLS = 10;
    private static final int HURT_CALL_INTERVAL = 10;
    private static final int HURT_CALL_PARTICLE_TICKS = 50;
    @Nullable
    private CreakingTransient creaking;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3 emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.CREAKING_HEART, pos, state);
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CreakingHeartBlockEntity blockEntity) {
        ServerLevel serverLevel2;
        int i = blockEntity.computeAnalogOutputSignal();
        if (blockEntity.outputSignal != i) {
            blockEntity.outputSignal = i;
            world.updateNeighbourForOutputSignal(pos, Blocks.CREAKING_HEART);
        }
        if (blockEntity.emitter > 0) {
            if (blockEntity.emitter > 50) {
                blockEntity.emitParticles((ServerLevel)world, 1, true);
                blockEntity.emitParticles((ServerLevel)world, 1, false);
            }
            if (blockEntity.emitter % 10 == 0 && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                if (blockEntity.emitterTarget != null) {
                    if (blockEntity.creaking != null) {
                        blockEntity.emitterTarget = blockEntity.creaking.getBoundingBox().getCenter();
                    }
                    Vec3 vec3 = Vec3.atCenterOf(pos);
                    float f = 0.2f + 0.8f * (float)(100 - blockEntity.emitter) / 100.0f;
                    Vec3 vec32 = vec3.subtract(blockEntity.emitterTarget).scale(f).add(blockEntity.emitterTarget);
                    BlockPos blockPos = BlockPos.containing(vec32);
                    float g = (float)blockEntity.emitter / 2.0f / 100.0f + 0.5f;
                    serverLevel.playSound(null, blockPos, SoundEvents.CREAKING_HEART_HURT, SoundSource.BLOCKS, g, 1.0f);
                }
            }
            --blockEntity.emitter;
        }
        if (blockEntity.ticker-- >= 0) {
            return;
        }
        blockEntity.ticker = 20;
        if (blockEntity.creaking != null) {
            if (!CreakingHeartBlock.canSummonCreaking(world) || blockEntity.distanceToCreaking() > 34.0) {
                blockEntity.removeProtector(null);
                return;
            }
            if (blockEntity.creaking.isRemoved()) {
                blockEntity.creaking = null;
            }
            if (!CreakingHeartBlock.hasRequiredLogs(state, world, pos) && blockEntity.creaking == null) {
                world.setBlock(pos, (BlockState)state.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DISABLED), 3);
            }
            return;
        }
        if (!CreakingHeartBlock.hasRequiredLogs(state, world, pos)) {
            world.setBlock(pos, (BlockState)state.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DISABLED), 3);
            return;
        }
        if (!CreakingHeartBlock.canSummonCreaking(world)) {
            if (state.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.CreakingHeartState.ACTIVE) {
                world.setBlock(pos, (BlockState)state.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DORMANT), 3);
                return;
            }
        } else if (state.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.CreakingHeartState.DORMANT) {
            world.setBlock(pos, (BlockState)state.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.ACTIVE), 3);
            return;
        }
        if (state.getValue(CreakingHeartBlock.CREAKING) != CreakingHeartBlock.CreakingHeartState.ACTIVE) {
            return;
        }
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        if (world instanceof ServerLevel && !(serverLevel2 = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        Player player = world.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 32.0, false);
        if (player != null) {
            blockEntity.creaking = CreakingHeartBlockEntity.spawnProtector((ServerLevel)world, blockEntity);
            if (blockEntity.creaking != null) {
                blockEntity.creaking.makeSound(SoundEvents.CREAKING_SPAWN);
                world.playSound(null, blockEntity.getBlockPos(), SoundEvents.CREAKING_HEART_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private double distanceToCreaking() {
        if (this.creaking == null) {
            return 0.0;
        }
        return Math.sqrt(this.creaking.distanceToSqr(Vec3.atBottomCenterOf(this.getBlockPos())));
    }

    @Nullable
    private static CreakingTransient spawnProtector(ServerLevel world, CreakingHeartBlockEntity blockEntity) {
        BlockPos blockPos = blockEntity.getBlockPos();
        Optional<CreakingTransient> optional = SpawnUtil.trySpawnMob(EntityType.CREAKING_TRANSIENT, EntitySpawnReason.SPAWNER, world, blockPos, 5, 16, 8, SpawnUtil.Strategy.ON_TOP_OF_COLLIDER_NO_LEAVES);
        if (optional.isEmpty()) {
            return null;
        }
        CreakingTransient creakingTransient = optional.get();
        world.gameEvent((Entity)creakingTransient, GameEvent.ENTITY_PLACE, creakingTransient.position());
        world.broadcastEntityEvent(creakingTransient, (byte)60);
        creakingTransient.bindToCreakingHeart(blockPos);
        return creakingTransient;
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    /*
     * WARNING - void declaration
     */
    public void creakingHurt() {
        void serverLevel2;
        if (this.creaking == null) {
            return;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.emitParticles((ServerLevel)serverLevel2, 20, false);
        this.emitter = 100;
        this.emitterTarget = this.creaking.getBoundingBox().getCenter();
    }

    private void emitParticles(ServerLevel world, int count, boolean towardsPuppet) {
        if (this.creaking == null) {
            return;
        }
        int i = towardsPuppet ? 16545810 : 0x5F5F5F;
        RandomSource randomSource = world.random;
        for (double d = 0.0; d < (double)count; d += 1.0) {
            Vec3 vec3 = this.creaking.getBoundingBox().getMinPosition().add(randomSource.nextDouble() * this.creaking.getBoundingBox().getXsize(), randomSource.nextDouble() * this.creaking.getBoundingBox().getYsize(), randomSource.nextDouble() * this.creaking.getBoundingBox().getZsize());
            Vec3 vec32 = Vec3.atLowerCornerOf(this.getBlockPos()).add(randomSource.nextDouble(), randomSource.nextDouble(), randomSource.nextDouble());
            if (towardsPuppet) {
                Vec3 vec33 = vec3;
                vec3 = vec32;
                vec32 = vec33;
            }
            TargetColorParticleOption targetColorParticleOption = new TargetColorParticleOption(vec32, i);
            world.sendParticles(targetColorParticleOption, vec3.x, vec3.y, vec3.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void removeProtector(@Nullable DamageSource damageSource) {
        if (this.creaking != null) {
            this.creaking.tearDown(damageSource);
            this.creaking = null;
        }
    }

    public boolean isProtector(Creaking creaking) {
        return this.creaking == creaking;
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creaking == null) {
            return 0;
        }
        double d = this.distanceToCreaking();
        double e = Math.clamp(d, 0.0, 32.0) / 32.0;
        return 15 - (int)Math.floor(e * 15.0);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

