/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import java.util.Collections;
import java.util.SequencedSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class FuelValues {
    private final Object2IntSortedMap<Item> values;

    FuelValues(Object2IntSortedMap<Item> fuelValues) {
        this.values = fuelValues;
    }

    public boolean isFuel(ItemStack item) {
        return this.values.containsKey((Object)item.getItem());
    }

    public SequencedSet<Item> fuelItems() {
        return Collections.unmodifiableSequencedSet(this.values.keySet());
    }

    public int burnDuration(ItemStack item) {
        if (item.isEmpty()) {
            return 0;
        }
        return this.values.getInt((Object)item.getItem());
    }

    public static FuelValues vanillaBurnTimes(HolderLookup.Provider registries, FeatureFlagSet enabledFeatures) {
        return FuelValues.vanillaBurnTimes(registries, enabledFeatures, 200);
    }

    public static FuelValues vanillaBurnTimes(HolderLookup.Provider registries, FeatureFlagSet enabledFeatures, int itemSmeltTime) {
        return new Builder(registries, enabledFeatures).add(Items.LAVA_BUCKET, itemSmeltTime * 100).add(Blocks.COAL_BLOCK, itemSmeltTime * 8 * 10).add(Items.BLAZE_ROD, itemSmeltTime * 12).add(Items.COAL, itemSmeltTime * 8).add(Items.CHARCOAL, itemSmeltTime * 8).add(ItemTags.LOGS, itemSmeltTime * 3 / 2).add(ItemTags.BAMBOO_BLOCKS, itemSmeltTime * 3 / 2).add(ItemTags.PLANKS, itemSmeltTime * 3 / 2).add(Blocks.BAMBOO_MOSAIC, itemSmeltTime * 3 / 2).add(ItemTags.WOODEN_STAIRS, itemSmeltTime * 3 / 2).add(Blocks.BAMBOO_MOSAIC_STAIRS, itemSmeltTime * 3 / 2).add(ItemTags.WOODEN_SLABS, itemSmeltTime * 3 / 4).add(Blocks.BAMBOO_MOSAIC_SLAB, itemSmeltTime * 3 / 4).add(ItemTags.WOODEN_TRAPDOORS, itemSmeltTime * 3 / 2).add(ItemTags.WOODEN_PRESSURE_PLATES, itemSmeltTime * 3 / 2).add(ItemTags.WOODEN_FENCES, itemSmeltTime * 3 / 2).add(ItemTags.FENCE_GATES, itemSmeltTime * 3 / 2).add(Blocks.NOTE_BLOCK, itemSmeltTime * 3 / 2).add(Blocks.BOOKSHELF, itemSmeltTime * 3 / 2).add(Blocks.CHISELED_BOOKSHELF, itemSmeltTime * 3 / 2).add(Blocks.LECTERN, itemSmeltTime * 3 / 2).add(Blocks.JUKEBOX, itemSmeltTime * 3 / 2).add(Blocks.CHEST, itemSmeltTime * 3 / 2).add(Blocks.TRAPPED_CHEST, itemSmeltTime * 3 / 2).add(Blocks.CRAFTING_TABLE, itemSmeltTime * 3 / 2).add(Blocks.DAYLIGHT_DETECTOR, itemSmeltTime * 3 / 2).add(ItemTags.BANNERS, itemSmeltTime * 3 / 2).add(Items.BOW, itemSmeltTime * 3 / 2).add(Items.FISHING_ROD, itemSmeltTime * 3 / 2).add(Blocks.LADDER, itemSmeltTime * 3 / 2).add(ItemTags.SIGNS, itemSmeltTime).add(ItemTags.HANGING_SIGNS, itemSmeltTime * 4).add(Items.WOODEN_SHOVEL, itemSmeltTime).add(Items.WOODEN_SWORD, itemSmeltTime).add(Items.WOODEN_HOE, itemSmeltTime).add(Items.WOODEN_AXE, itemSmeltTime).add(Items.WOODEN_PICKAXE, itemSmeltTime).add(ItemTags.WOODEN_DOORS, itemSmeltTime).add(ItemTags.BOATS, itemSmeltTime * 6).add(ItemTags.WOOL, itemSmeltTime / 2).add(ItemTags.WOODEN_BUTTONS, itemSmeltTime / 2).add(Items.STICK, itemSmeltTime / 2).add(ItemTags.SAPLINGS, itemSmeltTime / 2).add(Items.BOWL, itemSmeltTime / 2).add(ItemTags.WOOL_CARPETS, 1 + itemSmeltTime / 3).add(Blocks.DRIED_KELP_BLOCK, 1 + itemSmeltTime * 20).add(Items.CROSSBOW, itemSmeltTime * 3 / 2).add(Blocks.BAMBOO, itemSmeltTime / 4).add(Blocks.DEAD_BUSH, itemSmeltTime / 2).add(Blocks.SCAFFOLDING, itemSmeltTime / 4).add(Blocks.LOOM, itemSmeltTime * 3 / 2).add(Blocks.BARREL, itemSmeltTime * 3 / 2).add(Blocks.CARTOGRAPHY_TABLE, itemSmeltTime * 3 / 2).add(Blocks.FLETCHING_TABLE, itemSmeltTime * 3 / 2).add(Blocks.SMITHING_TABLE, itemSmeltTime * 3 / 2).add(Blocks.COMPOSTER, itemSmeltTime * 3 / 2).add(Blocks.AZALEA, itemSmeltTime / 2).add(Blocks.FLOWERING_AZALEA, itemSmeltTime / 2).add(Blocks.MANGROVE_ROOTS, itemSmeltTime * 3 / 2).remove(ItemTags.NON_FLAMMABLE_WOOD).build();
    }

    public static class Builder {
        private final HolderLookup<Item> items;
        private final FeatureFlagSet enabledFeatures;
        private final Object2IntSortedMap<Item> values = new Object2IntLinkedOpenHashMap();

        public Builder(HolderLookup.Provider registries, FeatureFlagSet enabledFeatures) {
            this.items = registries.lookupOrThrow(Registries.ITEM);
            this.enabledFeatures = enabledFeatures;
        }

        public FuelValues build() {
            return new FuelValues(this.values);
        }

        public Builder remove(TagKey<Item> tag) {
            this.values.keySet().removeIf(item -> item.builtInRegistryHolder().is(tag));
            return this;
        }

        public Builder add(TagKey<Item> tag2, int value) {
            this.items.get(tag2).ifPresent(tag -> {
                for (Holder holder : tag) {
                    this.putInternal(value, (Item)holder.value());
                }
            });
            return this;
        }

        public Builder add(ItemLike item, int value) {
            Item item2 = item.asItem();
            this.putInternal(value, item2);
            return this;
        }

        private void putInternal(int value, Item item) {
            if (item.isEnabled(this.enabledFeatures)) {
                this.values.put((Object)item, value);
            }
        }
    }
}

