/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.LazyPlayerSet;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class SignBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TEXT_LINE_WIDTH = 90;
    private static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    public UUID playerWhoMayEdit;
    private SignText frontText;
    private SignText backText;
    private boolean isWaxed;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public void sendSystemMessage(net.minecraft.network.chat.Component message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return wrapper.getEntity() != null ? wrapper.getEntity().getBukkitEntity() : new CraftBlockCommandSender(wrapper, SignBlockEntity.this);
        }

        @Override
        public boolean acceptsSuccess() {
            return false;
        }

        @Override
        public boolean acceptsFailure() {
            return false;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }
    };

    public SignBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityType.SIGN, pos, state);
    }

    public SignBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.frontText = this.createDefaultSignText();
        this.backText = this.createDefaultSignText();
    }

    protected SignText createDefaultSignText() {
        return new SignText();
    }

    public boolean isFacingFrontText(Player player) {
        return this.isFacingFrontText(player.getX(), player.getZ());
    }

    public boolean isFacingFrontText(double x, double z) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof SignBlock) {
            float f1;
            SignBlock blocksign = (SignBlock)block;
            Vec3 vec3d = blocksign.getSignHitboxCenterPosition(this.getBlockState());
            double d0 = x - ((double)this.getBlockPos().getX() + vec3d.x);
            double d1 = z - ((double)this.getBlockPos().getZ() + vec3d.z);
            float f = blocksign.getYRotationDegrees(this.getBlockState());
            return Mth.degreesDifferenceAbs(f, f1 = (float)(Mth.atan2(d1, d0) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean front) {
        return front ? this.frontText : this.backText;
    }

    public SignText getFrontText() {
        return this.frontText;
    }

    public SignText getBackText() {
        return this.backText;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        RegistryOps<Tag> dynamicops = registries.createSerializationContext(NbtOps.INSTANCE);
        DataResult dataresult = SignText.DIRECT_CODEC.encodeStart(dynamicops, (Object)this.frontText);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("front_text", (Tag)nbtbase));
        dataresult = SignText.DIRECT_CODEC.encodeStart(dynamicops, (Object)this.backText);
        logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("back_text", (Tag)nbtbase));
        nbt.putBoolean("is_waxed", this.isWaxed);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        Logger logger;
        DataResult dataresult;
        super.loadAdditional(nbt, registries);
        RegistryOps<Tag> dynamicops = registries.createSerializationContext(NbtOps.INSTANCE);
        if (nbt.contains("front_text")) {
            dataresult = SignText.DIRECT_CODEC.parse(dynamicops, (Object)nbt.getCompound("front_text"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.frontText = this.loadLines((SignText)signtext);
            });
        }
        if (nbt.contains("back_text")) {
            dataresult = SignText.DIRECT_CODEC.parse(dynamicops, (Object)nbt.getCompound("back_text"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(signtext -> {
                this.backText = this.loadLines((SignText)signtext);
            });
        }
        this.isWaxed = nbt.getBoolean("is_waxed");
    }

    private SignText loadLines(SignText signText) {
        for (int i = 0; i < 4; ++i) {
            net.minecraft.network.chat.Component ichatbasecomponent = this.loadLine(signText.getMessage(i, false));
            net.minecraft.network.chat.Component ichatbasecomponent1 = this.loadLine(signText.getMessage(i, true));
            signText = signText.setMessage(i, ichatbasecomponent, ichatbasecomponent1);
        }
        return signText;
    }

    private net.minecraft.network.chat.Component loadLine(net.minecraft.network.chat.Component text) {
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            try {
                return ComponentUtils.updateForEntity(this.createCommandSourceStack(null, worldserver, this.worldPosition), text, (Entity)null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void updateSignText(Player player, boolean front, List<FilteredText> messages) {
        if (!this.isWaxed() && player.getUUID().equals(this.getPlayerWhoMayEdit()) && this.level != null) {
            this.updateText(signtext -> this.setMessages(player, messages, (SignText)signtext, front), front);
            this.setAllowedPlayerEditor(null);
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        } else {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.getName().getString());
            if (player.distanceToSqr(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ()) < 1024.0) {
                ((ServerPlayer)player).connection.send(this.getUpdatePacket());
            }
        }
    }

    public boolean updateText(UnaryOperator<SignText> textChanger, boolean front) {
        SignText signtext = this.getText(front);
        return this.setText((SignText)textChanger.apply(signtext), front);
    }

    private SignText setMessages(Player entityhuman, List<FilteredText> list, SignText signtext, boolean front) {
        SignText originalText = signtext;
        for (int i = 0; i < list.size(); ++i) {
            FilteredText filteredtext = list.get(i);
            Style chatmodifier = signtext.getMessage(i, entityhuman.isTextFilteringEnabled()).getStyle();
            signtext = entityhuman.isTextFilteringEnabled() ? signtext.setMessage(i, net.minecraft.network.chat.Component.literal(StringUtil.filterText(filteredtext.filteredOrEmpty())).setStyle(chatmodifier)) : signtext.setMessage(i, net.minecraft.network.chat.Component.literal(StringUtil.filterText(filteredtext.raw())).setStyle(chatmodifier), net.minecraft.network.chat.Component.literal(StringUtil.filterText(filteredtext.filteredOrEmpty())).setStyle(chatmodifier));
        }
        CraftPlayer player = ((ServerPlayer)entityhuman).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i = 0; i < list.size(); ++i) {
            lines.add(PaperAdventure.asAdventure(signtext.getMessage(i, entityhuman.isTextFilteringEnabled())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.level, this.worldPosition), (org.bukkit.entity.Player)player, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        entityhuman.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return originalText;
        }
        net.minecraft.network.chat.Component[] components = CraftSign.sanitizeLines(event.lines());
        for (int i = 0; i < components.length; ++i) {
            if (Objects.equals(lines.get(i), event.line(i))) continue;
            signtext = signtext.setMessage(i, components[i]);
        }
        return signtext;
    }

    public boolean setText(SignText text, boolean front) {
        return front ? this.setFrontText(text) : this.setBackText(text);
    }

    private boolean setBackText(SignText backText) {
        if (backText != this.backText) {
            this.backText = backText;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean setFrontText(SignText frontText) {
        if (frontText != this.frontText) {
            this.frontText = frontText;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean canExecuteClickCommands(boolean front, Player player) {
        return this.isWaxed() && this.getText(front).hasAnyClickCommands(player);
    }

    public boolean executeClickCommandsIfPresent(Player player, Level world, BlockPos pos, boolean front) {
        boolean flag1 = false;
        for (net.minecraft.network.chat.Component ichatbasecomponent : this.getText(front).getMessages(player.isTextFilteringEnabled())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            Style chatmodifier = ichatbasecomponent.getStyle();
            ClickEvent chatclickable = chatmodifier.getClickEvent();
            if (chatclickable == null || chatclickable.getAction() != ClickEvent.Action.RUN_COMMAND) continue;
            Object object = command = chatclickable.getValue().startsWith("/") ? chatclickable.getValue() : "/" + chatclickable.getValue();
            if (SpigotConfig.logCommands) {
                LOGGER.info("{} issued server command: {}", (Object)player.getScoreboardName(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.getServer()), (Sign)CraftBlock.at(this.level, this.worldPosition).getState(), front ? Side.FRONT : Side.BACK)).callEvent()) {
                return false;
            }
            player.getServer().getCommands().performPrefixedCommand(this.createCommandSourceStack(((CraftPlayer)event.getPlayer()).getHandle(), world, pos), event.getMessage());
            flag1 = true;
        }
        return flag1;
    }

    private CommandSourceStack createCommandSourceStack(final @Nullable Player player, Level world, BlockPos pos) {
        String s = player == null ? "Sign" : player.getName().getString();
        net.minecraft.network.chat.Component object = player == null ? net.minecraft.network.chat.Component.literal("Sign") : player.getDisplayName();
        CommandSource commandSource = this.level.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this, this.commandSource){

            @Override
            public void sendSystemMessage(net.minecraft.network.chat.Component message) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage(message);
                }
            }

            @Override
            public boolean acceptsFailure() {
                return true;
            }
        } : this.commandSource;
        return new CommandSourceStack(commandSource, Vec3.atCenterOf(pos), Vec2.ZERO, (ServerLevel)world, 2, s, object, world.getServer(), player);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void setAllowedPlayerEditor(@Nullable UUID editor) {
        this.playerWhoMayEdit = editor;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        if (this.level != null && this.playerWhoMayEdit != null) {
            this.clearInvalidPlayerWhoMayEdit(this, this.level, this.playerWhoMayEdit);
        }
        return this.playerWhoMayEdit;
    }

    private void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public boolean setWaxed(boolean waxed) {
        if (this.isWaxed != waxed) {
            this.isWaxed = waxed;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean playerIsTooFarAwayToEdit(UUID uuid) {
        Player entityhuman = this.level.getPlayerByUUID(uuid);
        return entityhuman == null || !entityhuman.canInteractWithBlock(this.getBlockPos(), 4.0);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SignBlockEntity blockEntity) {
        UUID uuid = blockEntity.getPlayerWhoMayEdit();
        if (uuid != null) {
            blockEntity.clearInvalidPlayerWhoMayEdit(blockEntity, world, uuid);
        }
    }

    private void clearInvalidPlayerWhoMayEdit(SignBlockEntity blockEntity, Level world, UUID uuid) {
        if (blockEntity.playerIsTooFarAwayToEdit(uuid)) {
            blockEntity.setAllowedPlayerEditor(null);
        }
    }

    public SoundEvent getSignInteractionFailedSoundEvent() {
        return SoundEvents.WAXED_SIGN_INTERACT_FAIL;
    }
}

