/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonBaseBlock
extends DirectionalBlock {
    public static final MapCodec<PistonBaseBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(blockpiston -> blockpiston.isSticky), PistonBaseBlock.propertiesCodec()).apply((Applicative)instance, PistonBaseBlock::new));
    public static final BooleanProperty EXTENDED = BlockStateProperties.EXTENDED;
    public static final int TRIGGER_EXTEND = 0;
    public static final int TRIGGER_CONTRACT = 1;
    public static final int TRIGGER_DROP = 2;
    public static final float PLATFORM_THICKNESS = 4.0f;
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape UP_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean isSticky;

    public MapCodec<PistonBaseBlock> codec() {
        return CODEC;
    }

    public PistonBaseBlock(boolean sticky, BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(DirectionalBlock.FACING, Direction.NORTH)).setValue(EXTENDED, false));
        this.isSticky = sticky;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.getValue(EXTENDED).booleanValue()) {
            switch (state.getValue(DirectionalBlock.FACING)) {
                case DOWN: {
                    return DOWN_AABB;
                }
                default: {
                    return UP_AABB;
                }
                case NORTH: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }
        return Shapes.block();
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide) {
            this.checkIfExtend(world, pos, state);
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        if (!world.isClientSide) {
            this.checkIfExtend(world, pos, state);
        }
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock()) && !world.isClientSide && world.getBlockEntity(pos) == null) {
            this.checkIfExtend(world, pos, state);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(DirectionalBlock.FACING, ctx.getNearestLookingDirection().getOpposite())).setValue(EXTENDED, false);
    }

    private void checkIfExtend(Level world, BlockPos pos, BlockState state) {
        Direction enumdirection = state.getValue(DirectionalBlock.FACING);
        boolean flag = this.getNeighborSignal(world, pos, enumdirection);
        if (flag && !state.getValue(EXTENDED).booleanValue()) {
            if (new PistonStructureResolver(world, pos, enumdirection, true).resolve()) {
                world.blockEvent(pos, this, 0, enumdirection.get3DDataValue());
            }
        } else if (!flag && state.getValue(EXTENDED).booleanValue()) {
            PistonMovingBlockEntity tileentitypiston;
            BlockEntity tileentity;
            BlockPos blockposition1 = pos.relative(enumdirection, 2);
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            int b0 = 1;
            if (iblockdata1.is(Blocks.MOVING_PISTON) && iblockdata1.getValue(DirectionalBlock.FACING) == enumdirection && (tileentity = world.getBlockEntity(blockposition1)) instanceof PistonMovingBlockEntity && (tileentitypiston = (PistonMovingBlockEntity)tileentity).isExtending() && (tileentitypiston.getProgress(0.0f) < 0.5f || world.getGameTime() == tileentitypiston.getLastTicked() || ((ServerLevel)world).isHandlingTick())) {
                b0 = 2;
            }
            world.blockEvent(pos, this, b0, enumdirection.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(SignalGetter world, BlockPos pos, Direction pistonFace) {
        for (Direction enumdirection1 : Direction.values()) {
            if (enumdirection1 == pistonFace || !world.hasSignal(pos.relative(enumdirection1), enumdirection1)) continue;
            return true;
        }
        if (world.hasSignal(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockposition1 = pos.above();
        for (Direction enumdirection2 : Direction.values()) {
            if (enumdirection2 == Direction.DOWN || !world.hasSignal(blockposition1.relative(enumdirection2), enumdirection2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean triggerEvent(BlockState state, Level world, BlockPos pos, int type, int data) {
        Direction enumdirection = state.getValue(DirectionalBlock.FACING);
        Direction directionQueuedAs = Direction.from3DDataValue(data & 7);
        if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && enumdirection != directionQueuedAs) {
            return false;
        }
        BlockState iblockdata1 = (BlockState)state.setValue(EXTENDED, true);
        if (!world.isClientSide) {
            boolean flag = this.getNeighborSignal(world, pos, enumdirection);
            if (flag && (type == 1 || type == 2)) {
                world.setBlock(pos, iblockdata1, 2);
                return false;
            }
            if (!flag && type == 0) {
                return false;
            }
        }
        if (type == 0) {
            if (!this.moveBlocks(world, pos, enumdirection, true)) {
                return false;
            }
            world.setBlock(pos, iblockdata1, 67);
            world.playSound((Player)null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.25f + 0.6f);
            world.gameEvent(GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of(iblockdata1));
        } else if (type == 1 || type == 2) {
            BlockEntity tileentity = world.getBlockEntity(pos.relative(enumdirection));
            if (tileentity instanceof PistonMovingBlockEntity) {
                ((PistonMovingBlockEntity)tileentity).finalTick();
            }
            BlockState iblockdata2 = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, enumdirection)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            if (!this.isSticky && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(enumdirection)).callEvent()) {
                return false;
            }
            world.setBlock(pos, iblockdata2, 20);
            world.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(pos, iblockdata2, (BlockState)this.defaultBlockState().setValue(DirectionalBlock.FACING, Direction.from3DDataValue(data & 7)), enumdirection, false, true));
            world.blockUpdated(pos, iblockdata2.getBlock());
            iblockdata2.updateNeighbourShapes(world, pos, 2);
            if (this.isSticky) {
                PistonMovingBlockEntity tileentitypiston;
                BlockEntity tileentity1;
                BlockPos blockposition1 = pos.offset(enumdirection.getStepX() * 2, enumdirection.getStepY() * 2, enumdirection.getStepZ() * 2);
                BlockState iblockdata3 = world.getBlockState(blockposition1);
                boolean flag1 = false;
                if (iblockdata3.is(Blocks.MOVING_PISTON) && (tileentity1 = world.getBlockEntity(blockposition1)) instanceof PistonMovingBlockEntity && (tileentitypiston = (PistonMovingBlockEntity)tileentity1).getDirection() == enumdirection && tileentitypiston.isExtending()) {
                    tileentitypiston.finalTick();
                    flag1 = true;
                }
                if (!flag1) {
                    if (type == 1 && !iblockdata3.isAir() && PistonBaseBlock.isPushable(iblockdata3, world, blockposition1, enumdirection.getOpposite(), false, enumdirection) && (iblockdata3.getPistonPushReaction() == PushReaction.NORMAL || iblockdata3.is(Blocks.PISTON) || iblockdata3.is(Blocks.STICKY_PISTON))) {
                        this.moveBlocks(world, pos, enumdirection, false);
                    } else {
                        if (type == 1 && iblockdata2.isAir() && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(enumdirection)).callEvent()) {
                            return false;
                        }
                        world.removeBlock(pos.relative(enumdirection), false);
                    }
                }
            } else {
                BlockPos headPos = pos.relative(enumdirection);
                if (GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || world.getBlockState(headPos) == Blocks.PISTON_HEAD.defaultBlockState().setValue(DirectionalBlock.FACING, enumdirection)) {
                    world.removeBlock(headPos, false);
                } else {
                    ((ServerLevel)world).getChunkSource().blockChanged(headPos);
                }
            }
            world.playSound((Player)null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.15f + 0.6f);
            world.gameEvent(GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of(iblockdata2));
        }
        return true;
    }

    public static boolean isPushable(BlockState state, Level world, BlockPos pos, Direction direction, boolean canBreak, Direction pistonDir) {
        if (pos.getY() >= world.getMinY() && pos.getY() <= world.getMaxY() && world.getWorldBorder().isWithinBounds(pos)) {
            if (state.isAir()) {
                return true;
            }
            if (!(state.is(Blocks.OBSIDIAN) || state.is(Blocks.CRYING_OBSIDIAN) || state.is(Blocks.RESPAWN_ANCHOR) || state.is(Blocks.REINFORCED_DEEPSLATE))) {
                if (direction == Direction.DOWN && pos.getY() == world.getMinY()) {
                    return false;
                }
                if (direction == Direction.UP && pos.getY() == world.getMaxY()) {
                    return false;
                }
                if (!state.is(Blocks.PISTON) && !state.is(Blocks.STICKY_PISTON)) {
                    if (state.getDestroySpeed(world, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.getPistonPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return canBreak;
                        }
                        case PUSH_ONLY: {
                            return direction == pistonDir;
                        }
                    }
                } else if (state.getValue(EXTENDED).booleanValue()) {
                    return false;
                }
                return !state.hasBlockEntity();
            }
            return false;
        }
        return false;
    }

    private boolean moveBlocks(Level world, BlockPos pos, Direction dir, boolean extend) {
        int k;
        BlockState iblockdata2;
        BlockState iblockdata1;
        BlockPos blockposition3;
        int j;
        PistonStructureResolver pistonextendschecker;
        BlockPos blockposition1 = pos.relative(dir);
        if (!extend && world.getBlockState(blockposition1).is(Blocks.PISTON_HEAD)) {
            world.setBlock(blockposition1, Blocks.AIR.defaultBlockState(), 20);
        }
        if (!(pistonextendschecker = new PistonStructureResolver(world, pos, dir, extend)).resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonextendschecker.getToPush();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPos blockposition2 : list) {
            BlockState iblockdata = world.getBlockState(blockposition2);
            list1.add(iblockdata);
            map.put(blockposition2, iblockdata);
        }
        List<BlockPos> list2 = pistonextendschecker.getToDestroy();
        BlockState[] aiblockdata = new BlockState[list.size() + list2.size()];
        Direction enumdirection1 = extend ? dir : dir.getOpposite();
        int i = 0;
        final org.bukkit.block.Block bblock = world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
        final List<BlockPos> moved = pistonextendschecker.getToPush();
        final List<BlockPos> broken = pistonextendschecker.getToDestroy();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPos pos = index < moved.size() ? (BlockPos)moved.get(index) : (BlockPos)broken.get(index - moved.size());
                return bblock.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            }
        };
        Object event = extend ? new BlockPistonExtendEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1)) : new BlockPistonRetractEvent(bblock, (List)blocks, CraftBlock.notchToBlockFace(enumdirection1));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockPos b : broken) {
                world.sendBlockUpdated(b, Blocks.AIR.defaultBlockState(), world.getBlockState(b), 3);
            }
            for (BlockPos b : moved) {
                world.sendBlockUpdated(b, Blocks.AIR.defaultBlockState(), world.getBlockState(b), 3);
                b = b.relative(enumdirection1);
                world.sendBlockUpdated(b, Blocks.AIR.defaultBlockState(), world.getBlockState(b), 3);
            }
            return false;
        }
        for (j = list2.size() - 1; j >= 0; --j) {
            blockposition3 = list2.get(j);
            iblockdata1 = world.getBlockState(blockposition3);
            BlockEntity tileentity = iblockdata1.hasBlockEntity() ? world.getBlockEntity(blockposition3) : null;
            PistonBaseBlock.dropResources(iblockdata1, world, blockposition3, tileentity, pos);
            world.setBlock(blockposition3, Blocks.AIR.defaultBlockState(), 18);
            world.gameEvent(GameEvent.BLOCK_DESTROY, blockposition3, GameEvent.Context.of(iblockdata1));
            if (!iblockdata1.is(BlockTags.FIRE)) {
                world.addDestroyBlockEffect(blockposition3, iblockdata1);
            }
            aiblockdata[i++] = iblockdata1;
        }
        for (j = list.size() - 1; j >= 0; --j) {
            boolean allowDesync = GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication;
            BlockPos oldPos = blockposition3 = list.get(j);
            iblockdata1 = allowDesync ? world.getBlockState(oldPos) : null;
            blockposition3 = blockposition3.relative(enumdirection1);
            map.remove(blockposition3);
            iblockdata2 = (BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(DirectionalBlock.FACING, dir);
            world.setBlock(blockposition3, iblockdata2, 68);
            if (!allowDesync) {
                iblockdata1 = world.getBlockState(oldPos);
                map.replace(oldPos, iblockdata1);
            }
            world.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockposition3, iblockdata2, allowDesync ? (BlockState)list1.get(j) : iblockdata1, dir, extend, false));
            if (!allowDesync) {
                world.setBlock(oldPos, Blocks.AIR.defaultBlockState(), 1106);
            }
            aiblockdata[i++] = iblockdata1;
        }
        if (extend) {
            PistonType blockpropertypistontype = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState iblockdata3 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(DirectionalBlock.FACING, dir)).setValue(PistonHeadBlock.TYPE, blockpropertypistontype);
            iblockdata1 = (BlockState)((BlockState)Blocks.MOVING_PISTON.defaultBlockState().setValue(MovingPistonBlock.FACING, dir)).setValue(MovingPistonBlock.TYPE, this.isSticky ? PistonType.STICKY : PistonType.DEFAULT);
            map.remove(blockposition1);
            world.setBlock(blockposition1, iblockdata1, 68);
            world.setBlockEntity(MovingPistonBlock.newMovingBlockEntity(blockposition1, iblockdata1, iblockdata3, dir, true, true));
        }
        BlockState iblockdata4 = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos : map.keySet()) {
            world.setBlock(blockPos, iblockdata4, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockposition5 = (BlockPos)entry.getKey();
            BlockState iblockdata5 = (BlockState)entry.getValue();
            iblockdata5.updateIndirectNeighbourShapes(world, blockposition5, 2);
            iblockdata4.updateNeighbourShapes(world, blockposition5, 2);
            iblockdata4.updateIndirectNeighbourShapes(world, blockposition5, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, pistonextendschecker.getPushDirection(), null);
        i = 0;
        for (k = list2.size() - 1; k >= 0; --k) {
            iblockdata2 = aiblockdata[i++];
            BlockPos blockposition6 = list2.get(k);
            iblockdata2.updateIndirectNeighbourShapes(world, blockposition6, 2);
            world.updateNeighborsAt(blockposition6, iblockdata2.getBlock(), orientation);
        }
        for (k = list.size() - 1; k >= 0; --k) {
            world.updateNeighborsAt(list.get(k), aiblockdata[i++].getBlock(), orientation);
        }
        if (extend) {
            world.updateNeighborsAt(blockposition1, Blocks.PISTON_HEAD, orientation);
        }
        return true;
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(DirectionalBlock.FACING, rotation.rotate(state.getValue(DirectionalBlock.FACING)));
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(state.getValue(DirectionalBlock.FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(DirectionalBlock.FACING, EXTENDED);
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(EXTENDED);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

