/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class StateDefinition<O, S extends StateHolder<O, S>> {
    static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private final O owner;
    private final ImmutableSortedMap<String, Property<?>> propertiesByName;
    private final ImmutableList<S> states;

    protected StateDefinition(Function<O, S> defaultStateGetter, O owner, Factory<O, S> factory, Map<String, Property<?>> propertiesMap) {
        this.owner = owner;
        this.propertiesByName = ImmutableSortedMap.copyOf(propertiesMap);
        Supplier<StateHolder> supplier = () -> (StateHolder)defaultStateGetter.apply(owner);
        MapCodec<StateHolder> mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Map.Entry entry : this.propertiesByName.entrySet()) {
            mapCodec = StateDefinition.appendPropertyCodec(mapCodec, supplier, (String)entry.getKey(), (Property)entry.getValue());
        }
        MapCodec<StateHolder> mapCodec2 = mapCodec;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList list = Lists.newArrayList();
        Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
        for (Property property : this.propertiesByName.values()) {
            stream = stream.flatMap(entries -> property.getPossibleValues().stream().map(value -> {
                ArrayList list2 = Lists.newArrayList((Iterable)entries);
                list2.add(Pair.of((Object)property, (Object)value));
                return list2;
            }));
        }
        stream.forEach(entries -> {
            Reference2ObjectArrayMap reference2ObjectArrayMap = new Reference2ObjectArrayMap(entries.size());
            for (Pair pair : entries) {
                reference2ObjectArrayMap.put((Object)((Property)pair.getFirst()), (Object)((Comparable)pair.getSecond()));
            }
            StateHolder stateHolder = (StateHolder)factory.create(owner, reference2ObjectArrayMap, mapCodec2);
            map.put(reference2ObjectArrayMap, stateHolder);
            list.add(stateHolder);
        });
        for (StateHolder stateHolder : list) {
            stateHolder.populateNeighbours(map);
        }
        this.states = ImmutableList.copyOf((Collection)list);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> appendPropertyCodec(MapCodec<S> mapCodec, Supplier<S> defaultStateGetter, String key, Property<T> property) {
        return Codec.mapPair(mapCodec, (MapCodec)property.valueCodec().fieldOf(key).orElseGet(value -> {}, () -> property.value((StateHolder)defaultStateGetter.get()))).xmap(pair -> (StateHolder)((StateHolder)pair.getFirst()).setValue(property, ((Property.Value)pair.getSecond()).value()), state -> Pair.of((Object)state, property.value((StateHolder<?, ?>)state)));
    }

    public ImmutableList<S> getPossibleStates() {
        return this.states;
    }

    public S any() {
        return (S)((StateHolder)this.states.get(0));
    }

    public O getOwner() {
        return this.owner;
    }

    public Collection<Property<?>> getProperties() {
        return this.propertiesByName.values();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.owner).add("properties", this.propertiesByName.values().stream().map(Property::getName).collect(Collectors.toList())).toString();
    }

    @Nullable
    public Property<?> getProperty(String name) {
        return (Property)this.propertiesByName.get((Object)name);
    }

    public static interface Factory<O, S> {
        public S create(O var1, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O owner;
        private final Map<String, Property<?>> properties = Maps.newHashMap();

        public Builder(O owner) {
            this.owner = owner;
        }

        public Builder<O, S> add(Property<?> ... properties) {
            for (Property<?> property : properties) {
                this.validateProperty(property);
                this.properties.put(property.getName(), property);
            }
            return this;
        }

        private <T extends Comparable<T>> void validateProperty(Property<T> property) {
            String string = property.getName();
            if (!NAME_PATTERN.matcher(string).matches()) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has invalidly named property: " + string);
            }
            List<T> collection = property.getPossibleValues();
            if (collection.size() <= 1) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " attempted use property " + string + " with <= 1 possible values");
            }
            for (Comparable comparable : collection) {
                String string2 = property.getName(comparable);
                if (NAME_PATTERN.matcher(string2).matches()) continue;
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has property: " + string + " with invalidly named value: " + string2);
            }
            if (this.properties.containsKey(string)) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has duplicate property: " + string);
            }
        }

        public StateDefinition<O, S> create(Function<O, S> defaultStateGetter, Factory<O, S> factory) {
            return new StateDefinition<O, S>(defaultStateGetter, this.owner, factory, this.properties);
        }
    }
}

