/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;

public final class BooleanProperty
extends Property<Boolean>
implements PropertyAccess<Boolean> {
    private static final List<Boolean> VALUES = List.of(Boolean.valueOf(true), Boolean.valueOf(false));
    private static final int TRUE_INDEX = 0;
    private static final int FALSE_INDEX = 1;
    private static final Boolean[] BY_ID = new Boolean[]{Boolean.FALSE, Boolean.TRUE};

    @Override
    public final int moonrise$getIdFor(Boolean value) {
        return value != false ? 1 : 0;
    }

    private BooleanProperty(String name) {
        super(name, Boolean.class);
        this.moonrise$setById(BY_ID);
    }

    @Override
    public List<Boolean> getPossibleValues() {
        return VALUES;
    }

    public static BooleanProperty create(String name) {
        return new BooleanProperty(name);
    }

    @Override
    public Optional<Boolean> getValue(String name) {
        return switch (name) {
            case "true" -> Optional.of(true);
            case "false" -> Optional.of(false);
            default -> Optional.empty();
        };
    }

    @Override
    public String getName(Boolean boolean_) {
        return boolean_.toString();
    }

    @Override
    public int getInternalIndex(Boolean boolean_) {
        return boolean_ != false ? 0 : 1;
    }
}

