/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.world.level.block.state.properties.Property;

public final class IntegerProperty
extends Property<Integer>
implements PropertyAccess<Integer> {
    private final IntImmutableList values;
    public final int min;
    public final int max;

    @Override
    public final int moonrise$getIdFor(Integer value) {
        int val = value;
        int ret = val - this.min;
        return ret | this.max - ret >> 31;
    }

    private void init() {
        int min = this.min;
        int max = this.max;
        Comparable[] byId = new Integer[max - min + 1];
        for (int i = min; i <= max; ++i) {
            byId[i - min] = Integer.valueOf(i);
        }
        this.moonrise$setById(byId);
    }

    private IntegerProperty(String name, int min, int max) {
        super(name, Integer.class);
        if (min < 0) {
            throw new IllegalArgumentException("Min value of " + name + " must be 0 or greater");
        }
        if (max <= min) {
            throw new IllegalArgumentException("Max value of " + name + " must be greater than min (" + min + ")");
        }
        this.min = min;
        this.max = max;
        this.values = IntImmutableList.toList((IntStream)IntStream.range(min, max + 1));
        this.init();
    }

    @Override
    public List<Integer> getPossibleValues() {
        return this.values;
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntegerProperty) {
            IntegerProperty integerProperty = (IntegerProperty)object;
            if (super.equals(object)) {
                return this.values.equals(integerProperty.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        return 31 * super.generateHashCode() + this.values.hashCode();
    }

    public static IntegerProperty create(String name, int min, int max) {
        return new IntegerProperty(name, min, max);
    }

    @Override
    public Optional<Integer> getValue(String name) {
        try {
            int i = Integer.parseInt(name);
            return i >= this.min && i <= this.max ? Optional.of(i) : Optional.empty();
        }
        catch (NumberFormatException var3) {
            return Optional.empty();
        }
    }

    @Override
    public String getName(Integer integer) {
        return integer.toString();
    }

    @Override
    public int getInternalIndex(Integer integer) {
        return integer <= this.max ? integer - this.min : -1;
    }
}

