/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class RegionFileVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Int2ObjectMap<RegionFileVersion> VERSIONS = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<String, RegionFileVersion> VERSIONS_BY_NAME = new Object2ObjectOpenHashMap();
    public static final RegionFileVersion VERSION_GZIP = RegionFileVersion.register(new RegionFileVersion(1, null, stream -> new FastBufferedInputStream(new GZIPInputStream((InputStream)stream)), stream -> new BufferedOutputStream(new GZIPOutputStream((OutputStream)stream))));
    public static final RegionFileVersion VERSION_DEFLATE = RegionFileVersion.register(new RegionFileVersion(2, "deflate", stream -> new FastBufferedInputStream(new InflaterInputStream((InputStream)stream)), stream -> new BufferedOutputStream(new DeflaterOutputStream((OutputStream)stream))));
    public static final RegionFileVersion VERSION_NONE = RegionFileVersion.register(new RegionFileVersion(3, "none", FastBufferedInputStream::new, BufferedOutputStream::new));
    public static final RegionFileVersion VERSION_LZ4 = RegionFileVersion.register(new RegionFileVersion(4, "lz4", stream -> new FastBufferedInputStream((InputStream)new LZ4BlockInputStream(stream)), stream -> new BufferedOutputStream((OutputStream)new LZ4BlockOutputStream(stream))));
    public static final RegionFileVersion VERSION_CUSTOM = RegionFileVersion.register(new RegionFileVersion(127, null, stream -> {
        throw new UnsupportedOperationException();
    }, stream -> {
        throw new UnsupportedOperationException();
    }));
    public static final RegionFileVersion DEFAULT;
    private static volatile RegionFileVersion selected;
    private final int id;
    @Nullable
    private final String optionName;
    private final StreamWrapper<InputStream> inputWrapper;
    private final StreamWrapper<OutputStream> outputWrapper;

    public static RegionFileVersion getCompressionFormat() {
        return switch (GlobalConfiguration.get().unsupportedSettings.compressionFormat) {
            default -> throw new MatchException(null, null);
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.GZIP -> VERSION_GZIP;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.ZLIB -> VERSION_DEFLATE;
            case GlobalConfiguration.UnsupportedSettings.CompressionFormat.NONE -> VERSION_NONE;
        };
    }

    private RegionFileVersion(int id, @Nullable String name, StreamWrapper<InputStream> inputStreamWrapper, StreamWrapper<OutputStream> outputStreamWrapper) {
        this.id = id;
        this.optionName = name;
        this.inputWrapper = inputStreamWrapper;
        this.outputWrapper = outputStreamWrapper;
    }

    private static RegionFileVersion register(RegionFileVersion version) {
        VERSIONS.put(version.id, (Object)version);
        if (version.optionName != null) {
            VERSIONS_BY_NAME.put((Object)version.optionName, (Object)version);
        }
        return version;
    }

    @Nullable
    public static RegionFileVersion fromId(int id) {
        return (RegionFileVersion)VERSIONS.get(id);
    }

    public static void configure(String name) {
        RegionFileVersion regionFileVersion = (RegionFileVersion)VERSIONS_BY_NAME.get((Object)name);
        if (regionFileVersion != null) {
            selected = regionFileVersion;
        } else {
            LOGGER.error("Invalid `region-file-compression` value `{}` in server.properties. Please use one of: {}", (Object)name, (Object)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)VERSIONS_BY_NAME.keySet()));
        }
    }

    public static RegionFileVersion getSelected() {
        return selected;
    }

    public static boolean isValidVersion(int id) {
        return VERSIONS.containsKey(id);
    }

    public int getId() {
        return this.id;
    }

    public OutputStream wrap(OutputStream outputStream) throws IOException {
        return this.outputWrapper.wrap(outputStream);
    }

    public InputStream wrap(InputStream inputStream) throws IOException {
        return this.inputWrapper.wrap(inputStream);
    }

    static {
        selected = DEFAULT = VERSION_DEFLATE;
    }

    @FunctionalInterface
    static interface StreamWrapper<O> {
        public O wrap(O var1) throws IOException;
    }
}

