/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class SectionStorage<R, P>
implements AutoCloseable,
ChunkSystemSectionStorage {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirtyChunks = new LongLinkedOpenHashSet();
    private final Codec<P> codec;
    private final Function<R, P> packer;
    private final BiFunction<P, Runnable, R> unpacker;
    private final Function<Runnable, R> factory;
    private final RegistryAccess registryAccess;
    private final ChunkIOErrorReporter errorReporter;
    protected final LevelHeightAccessor levelHeightAccessor;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final Long2ObjectMap<CompletableFuture<Optional<PackedChunk<P>>>> pendingLoads = new Long2ObjectOpenHashMap();
    private final Object loadLock = new Object();
    private final RegionFileStorage regionStorage;

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.regionStorage;
    }

    @Override
    public void moonrise$close() throws IOException {
    }

    public SectionStorage(SimpleRegionStorage storageAccess, Codec<P> codec, Function<R, P> serializer, BiFunction<P, Runnable, R> deserializer, Function<Runnable, R> factory, RegistryAccess registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world) {
        this.codec = codec;
        this.packer = serializer;
        this.unpacker = deserializer;
        this.factory = factory;
        this.registryAccess = registryManager;
        this.errorReporter = errorHandler;
        this.levelHeightAccessor = world;
        this.regionStorage = storageAccess.worker.storage;
    }

    protected void tick(BooleanSupplier shouldKeepTicking) {
        LongListIterator longIterator = this.dirtyChunks.iterator();
        while (longIterator.hasNext() && shouldKeepTicking.getAsBoolean()) {
            ChunkPos chunkPos = new ChunkPos(longIterator.nextLong());
            longIterator.remove();
            this.writeChunk(chunkPos);
        }
        this.unpackPendingLoads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackPendingLoads() {
        Object object = this.loadLock;
        synchronized (object) {
            ObjectIterator iterator = Long2ObjectMaps.fastIterator(this.pendingLoads);
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                Optional optional = ((CompletableFuture)entry.getValue()).getNow(null);
                if (optional == null) continue;
                long l = entry.getLongKey();
                this.unpackChunk(new ChunkPos(l), optional.orElse(null));
                iterator.remove();
                this.loadedChunks.add(l);
            }
        }
    }

    public void flushAll() {
        if (!this.dirtyChunks.isEmpty()) {
            this.dirtyChunks.forEach(chunkPos -> this.writeChunk(new ChunkPos(chunkPos)));
            this.dirtyChunks.clear();
        }
    }

    public boolean hasWork() {
        return !this.dirtyChunks.isEmpty();
    }

    @Nullable
    public Optional<R> get(long pos) {
        return (Optional)this.storage.get(pos);
    }

    public Optional<R> getOrLoad(long pos) {
        if (this.outsideStoredRange(pos)) {
            return Optional.empty();
        }
        Optional<R> optional = this.get(pos);
        if (optional != null) {
            return optional;
        }
        this.unpackChunk(SectionPos.of(pos).chunk());
        optional = this.get(pos);
        if (optional == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return optional;
    }

    protected boolean outsideStoredRange(long pos) {
        int i = SectionPos.sectionToBlockCoord(SectionPos.y(pos));
        return this.levelHeightAccessor.isOutsideBuildHeight(i);
    }

    protected R getOrCreate(long pos) {
        if (this.outsideStoredRange(pos)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.getOrLoad(pos);
        if (optional.isPresent()) {
            return optional.get();
        }
        R object = this.factory.apply(() -> this.setDirty(pos));
        this.storage.put(pos, Optional.of(object));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> prefetch(ChunkPos chunkPos) {
        Object object = this.loadLock;
        synchronized (object) {
            long l = chunkPos.toLong();
            return this.loadedChunks.contains(l) ? CompletableFuture.completedFuture(null) : (CompletableFuture)this.pendingLoads.computeIfAbsent(l, pos -> this.tryRead(chunkPos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackChunk(ChunkPos chunkPos) {
        CompletableFuture completableFuture;
        long l = chunkPos.toLong();
        Object object = this.loadLock;
        synchronized (object) {
            if (!this.loadedChunks.add(l)) {
                return;
            }
            completableFuture = (CompletableFuture)this.pendingLoads.computeIfAbsent(l, pos -> this.tryRead(chunkPos));
        }
        this.unpackChunk(chunkPos, ((Optional)completableFuture.join()).orElse(null));
        object = this.loadLock;
        synchronized (object) {
            this.pendingLoads.remove(l);
        }
    }

    private CompletableFuture<Optional<PackedChunk<P>>> tryRead(ChunkPos chunkPos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private void unpackChunk(ChunkPos chunkPos, @Nullable PackedChunk<P> result) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private void writeChunk(ChunkPos pos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private <T> Dynamic<T> writeChunk(ChunkPos chunkPos, DynamicOps<T> ops) {
        HashMap map = Maps.newHashMap();
        for (int i = this.levelHeightAccessor.getMinSectionY(); i <= this.levelHeightAccessor.getMaxSectionY(); ++i) {
            long l = SectionStorage.getKey(chunkPos, i);
            Optional optional = (Optional)this.storage.get(l);
            if (optional == null || optional.isEmpty()) continue;
            DataResult dataResult = this.codec.encodeStart(ops, this.packer.apply(optional.get()));
            String string = Integer.toString(i);
            dataResult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(value -> map.put(ops.createString(string), value));
        }
        return new Dynamic<Object>(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString(SECTIONS_TAG), (Object)ops.createMap((Map)map), (Object)ops.createString("DataVersion"), (Object)ops.createInt(SharedConstants.getCurrentVersion().getDataVersion().getVersion()))));
    }

    private static long getKey(ChunkPos chunkPos, int y) {
        return SectionPos.asLong(chunkPos.x, y, chunkPos.z);
    }

    protected void onSectionLoad(long pos) {
    }

    public void setDirty(long pos) {
        Optional optional = (Optional)this.storage.get(pos);
        if (optional != null && !optional.isEmpty()) {
            this.dirtyChunks.add(ChunkPos.asLong(SectionPos.x(pos), SectionPos.z(pos)));
        } else {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of(pos));
        }
    }

    static int getVersion(Dynamic<?> dynamic) {
        return dynamic.get("DataVersion").asInt(1945);
    }

    public void flush(ChunkPos pos) {
        if (this.dirtyChunks.remove(pos.toLong())) {
            this.writeChunk(pos);
        }
    }

    @Override
    public void close() throws IOException {
        this.moonrise$close();
    }

    record PackedChunk<T>(Int2ObjectMap<T> sectionsByY, boolean versionChanged) {
        public static <T> PackedChunk<T> parse(Codec<T> sectionCodec, DynamicOps<Tag> ops, Tag nbt, SimpleRegionStorage storage, LevelHeightAccessor world) {
            int j;
            Dynamic<Tag> dynamic = new Dynamic<Tag>(ops, nbt);
            int i = SectionStorage.getVersion(dynamic);
            boolean bl = i != (j = SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            Dynamic<Tag> dynamic2 = storage.upgradeChunkTag(dynamic, i);
            OptionalDynamic<Tag> optionalDynamic = dynamic2.get(SectionStorage.SECTIONS_TAG);
            Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
            for (int k = world.getMinSectionY(); k <= world.getMaxSectionY(); ++k) {
                Optional optional = optionalDynamic.get(Integer.toString(k)).result().flatMap(section -> sectionCodec.parse(section).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                if (!optional.isPresent()) continue;
                int2ObjectMap.put(k, optional.get());
            }
            return new PackedChunk<T>(int2ObjectMap, bl);
        }
    }
}

