/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import org.slf4j.Logger;

public record SerializableChunkData(Registry<Biome> biomeRegistry, ChunkPos chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.Packed blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, UpgradeData upgradeData, @Nullable long[] carvingMask, Map<Heightmap.Types, long[]> heightmaps, ChunkAccess.PackedTicks packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<SectionData> sectionData, List<CompoundTag> entities, List<CompoundTag> blockEntities, CompoundTag structureData, @Nullable Tag persistentDataContainer) {
    public static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState(), null);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";
    private static final int CURRENT_DATA_VERSION = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
    private static final boolean JUST_CORRUPT_IT = Boolean.getBoolean("Paper.ignoreWorldDataVersion");

    public static ChunkPos getChunkCoordinate(CompoundTag chunkData) {
        int dataVersion = ChunkStorage.getVersion(chunkData);
        if (dataVersion < 2842) {
            CompoundTag levelData = chunkData.getCompound("Level");
            return new ChunkPos(levelData.getInt(X_POS_TAG), levelData.getInt(Z_POS_TAG));
        }
        return new ChunkPos(chunkData.getInt(X_POS_TAG), chunkData.getInt(Z_POS_TAG));
    }

    public static long getLastWorldSaveTime(CompoundTag chunkData) {
        int dataVersion = ChunkStorage.getVersion(chunkData);
        if (dataVersion < 2842) {
            CompoundTag levelData = chunkData.getCompound("Level");
            return levelData.getLong("LastUpdate");
        }
        return chunkData.getLong("LastUpdate");
    }

    @Nullable
    public static SerializableChunkData parse(LevelHeightAccessor world, RegistryAccess registryManager, CompoundTag nbt) {
        BelowZeroRetrogen belowzeroretrogen;
        BlendingData.Packed blendingdata_d;
        Logger logger;
        DataResult dataresult;
        boolean flag;
        ServerLevel serverLevel = (ServerLevel)world;
        if (!nbt.contains("Status", 8)) {
            return null;
        }
        if (nbt.contains("DataVersion", 99)) {
            int dataVersion = nbt.getInt("DataVersion");
            if (!JUST_CORRUPT_IT && dataVersion > CURRENT_DATA_VERSION) {
                new RuntimeException("Server attempted to load chunk saved with newer version of minecraft! " + dataVersion + " > " + CURRENT_DATA_VERSION).printStackTrace();
                System.exit(1);
            }
        }
        ChunkPos chunkcoordintpair = new ChunkPos(nbt.getInt(X_POS_TAG), nbt.getInt(Z_POS_TAG));
        long i = nbt.getLong("LastUpdate");
        long j = nbt.getLong("InhabitedTime");
        ChunkStatus chunkstatus = ChunkStatus.byName(nbt.getString("Status"));
        UpgradeData chunkconverter = nbt.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(nbt.getCompound(TAG_UPGRADE_DATA), world) : UpgradeData.EMPTY;
        boolean bl = flag = chunkstatus.isOrAfter(ChunkStatus.LIGHT) && nbt.get(IS_LIGHT_ON_TAG) != null && nbt.getInt("starlight.light_version") == 9;
        if (nbt.contains("blending_data", 10)) {
            dataresult = BlendingData.Packed.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound("blending_data"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            blendingdata_d = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(null);
        } else {
            blendingdata_d = null;
        }
        if (nbt.contains("below_zero_retrogen", 10)) {
            dataresult = BelowZeroRetrogen.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound("below_zero_retrogen"));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            belowzeroretrogen = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(null);
        } else {
            belowzeroretrogen = null;
        }
        long[] along = nbt.contains("carving_mask", 12) ? nbt.getLongArray("carving_mask") : null;
        CompoundTag nbttagcompound1 = nbt.getCompound(HEIGHTMAPS_TAG);
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Heightmap.Types heightmap_type : chunkstatus.heightmapsAfter()) {
            String s = heightmap_type.getSerializationKey();
            if (!nbttagcompound1.contains(s, 12)) continue;
            map.put(heightmap_type, nbttagcompound1.getLongArray(s));
        }
        List<SavedTick<Block>> list = SavedTick.loadTickList(nbt.getList(BLOCK_TICKS_TAG, 10), s1 -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(s1)), chunkcoordintpair);
        List<SavedTick<Fluid>> list1 = SavedTick.loadTickList(nbt.getList(FLUID_TICKS_TAG, 10), s1 -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(s1)), chunkcoordintpair);
        ChunkAccess.PackedTicks ichunkaccess_a = new ChunkAccess.PackedTicks(list, list1);
        ListTag nbttaglist = nbt.getList("PostProcessing", 9);
        ShortList[] ashortlist = new ShortList[nbttaglist.size()];
        for (int k = 0; k < nbttaglist.size(); ++k) {
            ListTag nbttaglist1 = nbttaglist.getList(k);
            ShortArrayList shortarraylist = new ShortArrayList(nbttaglist1.size());
            for (int l = 0; l < nbttaglist1.size(); ++l) {
                shortarraylist.add(nbttaglist1.getShort(l));
            }
            ashortlist[k] = shortarraylist;
        }
        List list2 = Lists.transform((List)nbt.getList("entities", 10), nbtbase -> (CompoundTag)nbtbase);
        List list3 = Lists.transform((List)nbt.getList("block_entities", 10), nbtbase -> (CompoundTag)nbtbase);
        CompoundTag nbttagcompound2 = nbt.getCompound("structures");
        ListTag nbttaglist2 = nbt.getList(SECTIONS_TAG, 10);
        ArrayList<SectionData> list4 = new ArrayList<SectionData>(nbttaglist2.size());
        HolderLookup.RegistryLookup iregistry = registryManager.lookupOrThrow(Registries.BIOME);
        Codec<PalettedContainer<Holder<Biome>>> codec = SerializableChunkData.makeBiomeCodecRW((Registry<Biome>)iregistry);
        for (int i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            LevelChunkSection chunksection;
            CompoundTag nbttagcompound3;
            CompoundTag sectionData = nbttagcompound3 = nbttaglist2.getCompound(i1);
            byte b0 = nbttagcompound3.getByte("Y");
            if (b0 >= world.getMinSectionY() && b0 <= world.getMaxSectionY()) {
                PalettedContainer datapaletteblock;
                BlockState[] presetBlockStates = serverLevel.chunkPacketBlockController.getPresetBlockStates(serverLevel, chunkcoordintpair, b0);
                if (nbttagcompound3.contains("block_states", 10)) {
                    Codec<PalettedContainer<BlockState>> blockStateCodec = presetBlockStates == null ? BLOCK_STATE_CODEC : PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState(), presetBlockStates);
                    datapaletteblock = (PalettedContainer)blockStateCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)sectionData.getCompound("block_states")).promotePartial(s1 -> SerializableChunkData.logErrors(chunkcoordintpair, b0, s1)).getOrThrow(ChunkReadException::new);
                } else {
                    datapaletteblock = new PalettedContainer(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES, presetBlockStates);
                }
                PalettedContainer object = nbttagcompound3.contains("biomes", 10) ? (PalettedContainer)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbttagcompound3.getCompound("biomes")).promotePartial(s1 -> SerializableChunkData.logErrors(chunkcoordintpair, b0, s1)).getOrThrow(ChunkReadException::new) : new PalettedContainer(iregistry.asHolderIdMap(), iregistry.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES, null);
                chunksection = new LevelChunkSection(datapaletteblock, object);
            } else {
                chunksection = null;
            }
            DataLayer nibblearray = nbttagcompound3.contains(BLOCK_LIGHT_TAG, 7) ? new DataLayer(nbttagcompound3.getByteArray(BLOCK_LIGHT_TAG)) : null;
            DataLayer nibblearray1 = nbttagcompound3.contains(SKY_LIGHT_TAG, 7) ? new DataLayer(nbttagcompound3.getByteArray(SKY_LIGHT_TAG)) : null;
            SectionData serializableChunkData = new SectionData(b0, chunksection, nibblearray, nibblearray1);
            if (sectionData.contains("starlight.blocklight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setBlockLightState(sectionData.getInt("starlight.blocklight_state"));
            }
            if (sectionData.contains("starlight.skylight_state", 99)) {
                ((StarlightSectionData)serializableChunkData).starlight$setSkyLightState(sectionData.getInt("starlight.skylight_state"));
            }
            list4.add(serializableChunkData);
        }
        return new SerializableChunkData((Registry<Biome>)iregistry, chunkcoordintpair, world.getMinSectionY(), i, j, chunkstatus, blendingdata_d, belowzeroretrogen, chunkconverter, along, map, ichunkaccess_a, ashortlist, flag, list4, list2, list3, nbttagcompound2, nbt.get("ChunkBukkitValues"));
    }

    private ProtoChunk loadStarlightLightData(ServerLevel world, ProtoChunk ret) {
        boolean hasSkyLight = world.dimensionType().hasSkyLight();
        int minSection = WorldUtil.getMinLightSection(world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        if (!this.lightCorrect) {
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
            return ret;
        }
        try {
            for (SectionData sectionData : this.sectionData) {
                int y = sectionData.y();
                DataLayer blockLight = sectionData.blockLight();
                DataLayer skyLight = sectionData.skyLight();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.getData()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.getData()), skyState);
                    continue;
                }
                skyNibbles[y - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.setLightCorrect(false);
            LOGGER.error("Failed to parse light data for chunk " + String.valueOf(ret.getPos()) + " in world '" + WorldUtil.getWorldName(world) + "'", thr);
        }
        return ret;
    }

    public ProtoChunk read(ServerLevel world, PoiManager poiStorage, RegionStorageInfo key, ChunkPos expectedPos) {
        ChunkAccess object;
        if (!Objects.equals(expectedPos, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{expectedPos, expectedPos, this.chunkPos});
            world.getServer().reportMisplacedChunk(this.chunkPos, expectedPos, key);
        }
        int i = world.getSectionsCount();
        LevelChunkSection[] achunksection = new LevelChunkSection[i];
        boolean flag = world.dimensionType().hasSkyLight();
        ServerChunkCache chunkproviderserver = world.getChunkSource();
        ThreadedLevelLightEngine levellightengine = chunkproviderserver.getLightEngine();
        HolderLookup.RegistryLookup iregistry = world.registryAccess().lookupOrThrow(Registries.BIOME);
        boolean flag1 = false;
        for (SectionData serializablechunkdata_b : this.sectionData) {
            boolean flag3;
            SectionPos sectionposition = SectionPos.of(expectedPos, serializablechunkdata_b.y);
            if (serializablechunkdata_b.chunkSection != null) {
                achunksection[world.getSectionIndexFromSectionY((int)serializablechunkdata_b.y)] = serializablechunkdata_b.chunkSection;
            }
            boolean flag2 = serializablechunkdata_b.blockLight != null;
            boolean bl = flag3 = flag && serializablechunkdata_b.skyLight != null;
            if (!flag2 && !flag3) continue;
            if (!flag1) {
                ((LevelLightEngine)levellightengine).retainData(expectedPos, true);
                flag1 = true;
            }
            if (flag2) {
                ((LevelLightEngine)levellightengine).queueSectionData(LightLayer.BLOCK, sectionposition, serializablechunkdata_b.blockLight);
            }
            if (!flag3) continue;
            ((LevelLightEngine)levellightengine).queueSectionData(LightLayer.SKY, sectionposition, serializablechunkdata_b.skyLight);
        }
        ChunkType chunktype = this.chunkStatus.getChunkType();
        if (chunktype == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> levelchunkticks = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            LevelChunkTicks<Fluid> levelchunkticks1 = new LevelChunkTicks<Fluid>(this.packedTicks.fluids());
            object = new LevelChunk(world.getLevel(), expectedPos, this.upgradeData, levelchunkticks, levelchunkticks1, this.inhabitedTime, achunksection, SerializableChunkData.postLoadChunk(world, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunkTicks<Block> protochunkticklist = ProtoChunkTicks.load(this.packedTicks.blocks());
            ProtoChunkTicks<Fluid> protochunkticklist1 = ProtoChunkTicks.load(this.packedTicks.fluids());
            ProtoChunk protochunk = new ProtoChunk(expectedPos, this.upgradeData, achunksection, protochunkticklist, protochunkticklist1, world, (Registry<Biome>)iregistry, BlendingData.unpack(this.blendingData));
            object = protochunk;
            protochunk.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                protochunk.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            protochunk.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                protochunk.setLightEngine(levellightengine);
            }
        }
        if (this.persistentDataContainer instanceof CompoundTag) {
            ((ChunkAccess)object).persistentDataContainer.putAll((CompoundTag)this.persistentDataContainer);
        }
        ((ChunkAccess)object).setLightCorrect(this.lightCorrect);
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types heightmap_type : ((ChunkAccess)object).getPersistedStatus().heightmapsAfter()) {
            long[] along = this.heightmaps.get(heightmap_type);
            if (along != null) {
                ((ChunkAccess)object).setHeightmap(heightmap_type, along);
                continue;
            }
            enumset.add(heightmap_type);
        }
        Heightmap.primeHeightmaps(object, enumset);
        ((ChunkAccess)object).setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel(world), this.structureData, world.getSeed()));
        ((ChunkAccess)object).setAllReferences(SerializableChunkData.unpackStructureReferences(world.registryAccess(), expectedPos, this.structureData));
        for (int j = 0; j < this.postProcessingSections.length; ++j) {
            ((ChunkAccess)object).addPackedPostProcess(this.postProcessingSections[j], j);
        }
        if (chunktype == ChunkType.LEVELCHUNK) {
            return this.loadStarlightLightData(world, new ImposterProtoChunk((LevelChunk)object, false));
        }
        ChunkAccess protochunk1 = object;
        for (CompoundTag nbttagcompound : this.entities) {
            ((ProtoChunk)protochunk1).addEntity(nbttagcompound);
        }
        for (CompoundTag nbttagcompound : this.blockEntities) {
            BlockPos blockposition = BlockEntity.getPosFromTag(nbttagcompound);
            if (blockposition.getX() >> 4 != this.chunkPos.x || blockposition.getZ() >> 4 != this.chunkPos.z) {
                LOGGER.warn("Tile entity serialized in chunk {} in world '{}' positioned at {} is located outside of the chunk", new Object[]{this.chunkPos, world.getWorld().getName(), blockposition});
                continue;
            }
            protochunk1.setBlockEntityNbt(nbttagcompound);
        }
        if (this.carvingMask != null) {
            ((ProtoChunk)protochunk1).setCarvingMask(new CarvingMask(this.carvingMask, object.getMinY()));
        }
        return this.loadStarlightLightData(world, (ProtoChunk)protochunk1);
    }

    private static void logErrors(ChunkPos chunkPos, int y, String message) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.x, y, chunkPos.z, message});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> biomeRegistry) {
        return PalettedContainer.codecRO(biomeRegistry.asHolderIdMap(), biomeRegistry.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, biomeRegistry.getOrThrow(Biomes.PLAINS));
    }

    private static Codec<PalettedContainer<Holder<Biome>>> makeBiomeCodecRW(Registry<Biome> iregistry) {
        return PalettedContainer.codecRW(iregistry.asHolderIdMap(), iregistry.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, iregistry.getOrThrow(Biomes.PLAINS), null);
    }

    public static SerializableChunkData copyOf(ServerLevel world, ChunkAccess chunk) {
        ArrayList<SectionData> list;
        if (!chunk.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(chunk));
        }
        ChunkPos chunkcoordintpair = chunk.getPos();
        ArrayList<SectionData> sections = list = new ArrayList<SectionData>();
        LevelChunkSection[] achunksection = chunk.getSections();
        ThreadedLevelLightEngine lightenginethreaded = world.getChunkSource().getLightEngine();
        int minLightSection = WorldUtil.getMinLightSection(world);
        int maxLightSection = WorldUtil.getMaxLightSection(world);
        int minBlockSection = WorldUtil.getMinSection(world);
        LevelChunkSection[] chunkSections = chunk.getSections();
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            LevelChunkSection chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].copy() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState skyNibble = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && skyNibble == null) continue;
            SectionData sectionData = new SectionData(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new DataLayer(blockNibble.data)), skyNibble == null ? null : (skyNibble.data == null ? null : new DataLayer(skyNibble.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (skyNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(skyNibble.state);
            }
            sections.add(sectionData);
        }
        ArrayList<CompoundTag> list1 = new ArrayList<CompoundTag>(chunk.getBlockEntitiesPos().size());
        for (BlockPos blockposition : chunk.getBlockEntitiesPos()) {
            CompoundTag nbttagcompound = chunk.getBlockEntityNbtForSaving(blockposition, world.registryAccess());
            if (nbttagcompound == null) continue;
            list1.add(nbttagcompound);
        }
        ArrayList<CompoundTag> list2 = new ArrayList<CompoundTag>();
        long[] along = null;
        if (chunk.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)chunk;
            list2.addAll(protochunk.getEntities());
            CarvingMask carvingmask = protochunk.getCarvingMask();
            if (carvingmask != null) {
                along = carvingmask.toArray();
            }
        }
        EnumMap<Heightmap.Types, long[]> map = new EnumMap<Heightmap.Types, long[]>(Heightmap.Types.class);
        for (Map.Entry<Heightmap.Types, Heightmap> entry : chunk.getHeightmaps()) {
            if (!chunk.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            long[] along1 = entry.getValue().getRawData();
            map.put(entry.getKey(), (long[])along1.clone());
        }
        ChunkAccess.PackedTicks ichunkaccess_a = chunk.getTicksForSerialization(world.getGameTime());
        ShortList[] ashortlist = (ShortList[])Arrays.stream(chunk.getPostProcessing()).map(shortlist -> shortlist != null ? new ShortArrayList(shortlist) : null).toArray(ShortList[]::new);
        CompoundTag nbttagcompound1 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel(world), chunkcoordintpair, chunk.getAllStarts(), chunk.getAllReferences());
        CompoundTag persistentDataContainer = null;
        if (!chunk.persistentDataContainer.isEmpty()) {
            persistentDataContainer = chunk.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData((Registry<Biome>)world.registryAccess().lookupOrThrow(Registries.BIOME), chunkcoordintpair, chunk.getMinSectionY(), world.getGameTime(), chunk.getInhabitedTime(), chunk.getPersistedStatus(), Optionull.map(chunk.getBlendingData(), BlendingData::pack), chunk.getBelowZeroRetrogen(), chunk.getUpgradeData().copy(), along, map, ichunkaccess_a, ashortlist, chunk.isLightCorrect(), list, list2, list1, nbttagcompound1, persistentDataContainer);
    }

    public CompoundTag write() {
        Logger logger;
        DataResult dataresult;
        CompoundTag nbttagcompound = NbtUtils.addCurrentDataVersion(new CompoundTag());
        nbttagcompound.putInt(X_POS_TAG, this.chunkPos.x);
        nbttagcompound.putInt("yPos", this.minSectionY);
        nbttagcompound.putInt(Z_POS_TAG, this.chunkPos.z);
        nbttagcompound.putLong("LastUpdate", this.lastUpdateTime);
        nbttagcompound.putLong("InhabitedTime", this.inhabitedTime);
        nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        if (this.blendingData != null) {
            dataresult = BlendingData.Packed.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.blendingData);
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("blending_data", (Tag)nbtbase));
        }
        if (this.belowZeroRetrogen != null) {
            dataresult = BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.belowZeroRetrogen);
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("below_zero_retrogen", (Tag)nbtbase));
        }
        if (!this.upgradeData.isEmpty()) {
            nbttagcompound.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        ListTag nbttaglist = new ListTag();
        Codec<PalettedContainerRO<Holder<Biome>>> codec = SerializableChunkData.makeBiomeCodec(this.biomeRegistry);
        Iterator<SectionData> iterator = this.sectionData.iterator();
        while (iterator.hasNext()) {
            CompoundTag nbttagcompound1;
            SectionData serializablechunkdata_b;
            SectionData sectionData = serializablechunkdata_b = iterator.next();
            CompoundTag sectionNBT = nbttagcompound1 = new CompoundTag();
            LevelChunkSection chunksection = serializablechunkdata_b.chunkSection;
            if (chunksection != null) {
                nbttagcompound1.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, chunksection.getStates()).getOrThrow());
                nbttagcompound1.put("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, chunksection.getBiomes()).getOrThrow());
            }
            if (serializablechunkdata_b.blockLight != null) {
                nbttagcompound1.putByteArray(BLOCK_LIGHT_TAG, serializablechunkdata_b.blockLight.getData());
            }
            if (serializablechunkdata_b.skyLight != null) {
                nbttagcompound1.putByteArray(SKY_LIGHT_TAG, serializablechunkdata_b.skyLight.getData());
            }
            int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
            int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
            if (blockState > 0) {
                sectionNBT.putInt("starlight.blocklight_state", blockState);
            }
            if (skyState > 0) {
                sectionNBT.putInt("starlight.skylight_state", skyState);
            }
            if (nbttagcompound1.isEmpty()) continue;
            nbttagcompound1.putByte("Y", (byte)serializablechunkdata_b.y);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.put(SECTIONS_TAG, nbttaglist);
        if (this.lightCorrect) {
            nbttagcompound.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag nbttaglist1 = new ListTag();
        nbttaglist1.addAll(this.blockEntities);
        nbttagcompound.put("block_entities", nbttaglist1);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            ListTag nbttaglist2 = new ListTag();
            nbttaglist2.addAll(this.entities);
            nbttagcompound.put("entities", nbttaglist2);
            if (this.carvingMask != null) {
                nbttagcompound.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks(nbttagcompound, this.packedTicks);
        nbttagcompound.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        CompoundTag nbttagcompound2 = new CompoundTag();
        this.heightmaps.forEach((heightmap_type, along) -> nbttagcompound2.put(heightmap_type.getSerializationKey(), new LongArrayTag((long[])along)));
        nbttagcompound.put(HEIGHTMAPS_TAG, nbttagcompound2);
        nbttagcompound.put("structures", this.structureData);
        if (this.persistentDataContainer != null) {
            nbttagcompound.put("ChunkBukkitValues", this.persistentDataContainer);
        }
        if (this.lightCorrect && !this.chunkStatus.isBefore(ChunkStatus.LIGHT)) {
            nbttagcompound.putBoolean(IS_LIGHT_ON_TAG, false);
            nbttagcompound.putInt("starlight.light_version", 9);
        }
        return nbttagcompound;
    }

    private static void saveTicks(CompoundTag nbt, ChunkAccess.PackedTicks schedulers) {
        ListTag nbttaglist = new ListTag();
        for (SavedTick<Block> ticklistchunk : schedulers.blocks()) {
            nbttaglist.add(ticklistchunk.save(block -> BuiltInRegistries.BLOCK.getKey((Block)block).toString()));
        }
        nbt.put(BLOCK_TICKS_TAG, nbttaglist);
        ListTag nbttaglist1 = new ListTag();
        for (SavedTick<Fluid> ticklistchunk1 : schedulers.fluids()) {
            nbttaglist1.add(ticklistchunk1.save(fluidtype -> BuiltInRegistries.FLUID.getKey((Fluid)fluidtype).toString()));
        }
        nbt.put(FLUID_TICKS_TAG, nbttaglist1);
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag nbt) {
        return nbt != null ? ChunkStatus.byName(nbt.getString("Status")).getChunkType() : ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel world, List<CompoundTag> entities, List<CompoundTag> blockEntities) {
        return entities.isEmpty() && blockEntities.isEmpty() ? null : chunk -> {
            if (!entities.isEmpty()) {
                world.addLegacyChunkEntities(EntityType.loadEntitiesRecursive(entities, world, EntitySpawnReason.LOAD));
            }
            for (CompoundTag nbttagcompound : blockEntities) {
                boolean flag = nbttagcompound.getBoolean("keepPacked");
                if (flag) {
                    chunk.setBlockEntityNbt(nbttagcompound);
                    continue;
                }
                BlockPos blockposition = BlockEntity.getPosFromTag(nbttagcompound);
                ChunkPos chunkPos = chunk.getPos();
                if (blockposition.getX() >> 4 != chunkPos.x || blockposition.getZ() >> 4 != chunkPos.z) {
                    LOGGER.warn("Tile entity serialized in chunk " + String.valueOf(chunkPos) + " in world '" + world.getWorld().getName() + "' positioned at " + String.valueOf(blockposition) + " is located outside of the chunk");
                    continue;
                }
                BlockEntity tileentity = BlockEntity.loadStatic(blockposition, chunk.getBlockState(blockposition), nbttagcompound, world.registryAccess());
                if (tileentity == null) continue;
                chunk.setBlockEntity(tileentity);
            }
        };
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext context, ChunkPos pos, Map<Structure, StructureStart> starts, Map<Structure, LongSet> references) {
        CompoundTag nbttagcompound = new CompoundTag();
        CompoundTag nbttagcompound1 = new CompoundTag();
        HolderLookup.RegistryLookup iregistry = context.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> entry : starts.entrySet()) {
            ResourceLocation minecraftkey = iregistry.getKey(entry.getKey());
            nbttagcompound1.put(minecraftkey.toString(), entry.getValue().createTag(context, pos));
        }
        nbttagcompound.put("starts", nbttagcompound1);
        CompoundTag nbttagcompound2 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> entry1 : references.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            ResourceLocation minecraftkey1 = iregistry.getKey(entry1.getKey());
            nbttagcompound2.put(minecraftkey1.toString(), new LongArrayTag(entry1.getValue()));
        }
        nbttagcompound.put("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext context, CompoundTag nbt, long worldSeed) {
        HashMap map = Maps.newHashMap();
        HolderLookup.RegistryLookup iregistry = context.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        CompoundTag nbttagcompound1 = nbt.getCompound("starts");
        for (String s : nbttagcompound1.getAllKeys()) {
            ResourceLocation minecraftkey = ResourceLocation.tryParse(s);
            Structure structure = (Structure)iregistry.getValue(minecraftkey);
            if (structure == null) {
                LOGGER.error("Unknown structure start: {}", (Object)minecraftkey);
                continue;
            }
            StructureStart structurestart = StructureStart.loadStaticStart(context, nbttagcompound1.getCompound(s), worldSeed);
            if (structurestart == null) continue;
            Tag persistentBase = nbttagcompound1.getCompound(s).get("StructureBukkitValues");
            if (persistentBase instanceof CompoundTag) {
                structurestart.persistentDataContainer.putAll((CompoundTag)persistentBase);
            }
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess registryManager, ChunkPos pos, CompoundTag nbt) {
        HashMap map = Maps.newHashMap();
        HolderLookup.RegistryLookup iregistry = registryManager.lookupOrThrow(Registries.STRUCTURE);
        CompoundTag nbttagcompound1 = nbt.getCompound("References");
        for (String s : nbttagcompound1.getAllKeys()) {
            ResourceLocation minecraftkey = ResourceLocation.tryParse(s);
            Structure structure = (Structure)iregistry.getValue(minecraftkey);
            if (structure == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)minecraftkey, (Object)pos);
                continue;
            }
            long[] along = nbttagcompound1.getLongArray(s);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(i -> {
                ChunkPos chunkcoordintpair1 = new ChunkPos(i);
                if (chunkcoordintpair1.getChessboardDistance(pos) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{minecraftkey, chunkcoordintpair1, pos});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    private static ListTag packOffsets(ShortList[] lists) {
        ListTag nbttaglist = new ListTag();
        ShortList[] ashortlist1 = lists;
        int i = lists.length;
        for (int j = 0; j < i; ++j) {
            ShortList shortlist = ashortlist1[j];
            ListTag nbttaglist1 = new ListTag();
            if (shortlist != null) {
                for (int k = 0; k < shortlist.size(); ++k) {
                    nbttaglist1.add(ShortTag.valueOf(shortlist.getShort(k)));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    public static final class SectionData
    implements StarlightSectionData {
        private final int y;
        @Nullable
        private final LevelChunkSection chunkSection;
        @Nullable
        private final DataLayer blockLight;
        @Nullable
        private final DataLayer skyLight;
        private int blockLightState = -1;
        private int skyLightState = -1;

        @Override
        public final int starlight$getBlockLightState() {
            return this.blockLightState;
        }

        @Override
        public final void starlight$setBlockLightState(int state) {
            this.blockLightState = state;
        }

        @Override
        public final int starlight$getSkyLightState() {
            return this.skyLightState;
        }

        @Override
        public final void starlight$setSkyLightState(int state) {
            this.skyLightState = state;
        }

        public SectionData(int y, @Nullable LevelChunkSection chunkSection, @Nullable DataLayer blockLight, @Nullable DataLayer skyLight) {
            this.y = y;
            this.chunkSection = chunkSection;
            this.blockLight = blockLight;
            this.skyLight = skyLight;
        }

        public int y() {
            return this.y;
        }

        @Nullable
        public LevelChunkSection chunkSection() {
            return this.chunkSection;
        }

        @Nullable
        public DataLayer blockLight() {
            return this.blockLight;
        }

        @Nullable
        public DataLayer skyLight() {
            return this.skyLight;
        }
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String message) {
            super(message);
        }
    }
}

