/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;

public abstract class Column {
    public static Range around(int i, int j) {
        return new Range(i - 1, j + 1);
    }

    public static Range inside(int floor, int ceiling) {
        return new Range(floor, ceiling);
    }

    public static Column below(int ceiling) {
        return new Ray(ceiling, false);
    }

    public static Column fromHighest(int i) {
        return new Ray(i + 1, false);
    }

    public static Column above(int floor) {
        return new Ray(floor, true);
    }

    public static Column fromLowest(int i) {
        return new Ray(i - 1, true);
    }

    public static Column line() {
        return Line.INSTANCE;
    }

    public static Column create(OptionalInt ceilingHeight, OptionalInt floorHeight) {
        if (ceilingHeight.isPresent() && floorHeight.isPresent()) {
            return Column.inside(ceilingHeight.getAsInt(), floorHeight.getAsInt());
        }
        if (ceilingHeight.isPresent()) {
            return Column.above(ceilingHeight.getAsInt());
        }
        if (floorHeight.isPresent()) {
            return Column.below(floorHeight.getAsInt());
        }
        return Column.line();
    }

    public abstract OptionalInt getCeiling();

    public abstract OptionalInt getFloor();

    public abstract OptionalInt getHeight();

    public Column withFloor(OptionalInt floor) {
        return Column.create(floor, this.getCeiling());
    }

    public Column withCeiling(OptionalInt ceiling) {
        return Column.create(this.getFloor(), ceiling);
    }

    public static Optional<Column> scan(LevelSimulatedReader world, BlockPos pos, int height, Predicate<BlockState> canGenerate, Predicate<BlockState> canReplace) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        if (!world.isStateAtPosition(pos, canGenerate)) {
            return Optional.empty();
        }
        int i = pos.getY();
        OptionalInt optionalInt = Column.scanDirection(world, height, canGenerate, canReplace, mutableBlockPos, i, Direction.UP);
        OptionalInt optionalInt2 = Column.scanDirection(world, height, canGenerate, canReplace, mutableBlockPos, i, Direction.DOWN);
        return Optional.of(Column.create(optionalInt2, optionalInt));
    }

    private static OptionalInt scanDirection(LevelSimulatedReader world, int height, Predicate<BlockState> canGenerate, Predicate<BlockState> canReplace, BlockPos.MutableBlockPos mutablePos, int y, Direction direction) {
        mutablePos.setY(y);
        for (int i = 1; i < height && world.isStateAtPosition(mutablePos, canGenerate); ++i) {
            mutablePos.move(direction);
        }
        return world.isStateAtPosition(mutablePos, canReplace) ? OptionalInt.of(mutablePos.getY()) : OptionalInt.empty();
    }

    public static final class Range
    extends Column {
        private final int floor;
        private final int ceiling;

        protected Range(int floor, int ceiling) {
            this.floor = floor;
            this.ceiling = ceiling;
            if (this.height() < 0) {
                throw new IllegalArgumentException("Column of negative height: " + String.valueOf(this));
            }
        }

        @Override
        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.of(this.ceiling);
        }

        @Override
        @Override
        public OptionalInt getFloor() {
            return OptionalInt.of(this.floor);
        }

        @Override
        @Override
        public OptionalInt getHeight() {
            return OptionalInt.of(this.height());
        }

        public int ceiling() {
            return this.ceiling;
        }

        public int floor() {
            return this.floor;
        }

        public int height() {
            return this.ceiling - this.floor - 1;
        }

        @Override
        public String toString() {
            return "C(" + this.ceiling + "-" + this.floor + ")";
        }
    }

    public static final class Ray
    extends Column {
        private final int edge;
        private final boolean pointingUp;

        public Ray(int height, boolean floor) {
            this.edge = height;
            this.pointingUp = floor;
        }

        @Override
        @Override
        public OptionalInt getCeiling() {
            return this.pointingUp ? OptionalInt.empty() : OptionalInt.of(this.edge);
        }

        @Override
        @Override
        public OptionalInt getFloor() {
            return this.pointingUp ? OptionalInt.of(this.edge) : OptionalInt.empty();
        }

        @Override
        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        @Override
        public String toString() {
            return this.pointingUp ? "C(" + this.edge + "-)" : "C(-" + this.edge + ")";
        }
    }

    public static final class Line
    extends Column {
        static final Line INSTANCE = new Line();

        private Line() {
        }

        @Override
        @Override
        public OptionalInt getCeiling() {
            return OptionalInt.empty();
        }

        @Override
        @Override
        public OptionalInt getFloor() {
            return OptionalInt.empty();
        }

        @Override
        @Override
        public OptionalInt getHeight() {
            return OptionalInt.empty();
        }

        @Override
        public String toString() {
            return "C(-)";
        }
    }
}

