/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;

public class HugeBrownMushroomFeature
extends AbstractHugeMushroomFeature {
    public HugeBrownMushroomFeature(Codec<HugeMushroomFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    protected void makeCap(LevelAccessor world, RandomSource random, BlockPos start, int y, BlockPos.MutableBlockPos mutable, HugeMushroomFeatureConfiguration config) {
        int i = config.foliageRadius;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean bl6;
                boolean bl = j == -i;
                boolean bl2 = j == i;
                boolean bl3 = k == -i;
                boolean bl4 = k == i;
                boolean bl5 = bl || bl2;
                boolean bl7 = bl6 = bl3 || bl4;
                if (bl5 && bl6) continue;
                mutable.setWithOffset(start, j, y, k);
                if (world.getBlockState(mutable).isSolidRender()) continue;
                boolean bl72 = bl || bl6 && j == 1 - i;
                boolean bl8 = bl2 || bl6 && j == i - 1;
                boolean bl9 = bl3 || bl5 && k == 1 - i;
                boolean bl10 = bl4 || bl5 && k == i - 1;
                BlockState blockState = config.capProvider.getState(random, start);
                if (blockState.hasProperty(HugeMushroomBlock.WEST) && blockState.hasProperty(HugeMushroomBlock.EAST) && blockState.hasProperty(HugeMushroomBlock.NORTH) && blockState.hasProperty(HugeMushroomBlock.SOUTH)) {
                    blockState = (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue(HugeMushroomBlock.WEST, bl72)).setValue(HugeMushroomBlock.EAST, bl8)).setValue(HugeMushroomBlock.NORTH, bl9)).setValue(HugeMushroomBlock.SOUTH, bl10);
                }
                this.setBlock(world, mutable, blockState);
            }
        }
    }

    @Override
    @Override
    protected int getTreeRadiusForHeight(int i, int j, int capSize, int y) {
        return y <= 3 ? 0 : capSize;
    }
}

