/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluids;

public abstract class FoliagePlacer {
    public static final Codec<FoliagePlacer> CODEC = BuiltInRegistries.FOLIAGE_PLACER_TYPE.byNameCodec().dispatch(FoliagePlacer::type, FoliagePlacerType::codec);
    protected final IntProvider radius;
    protected final IntProvider offset;

    protected static <P extends FoliagePlacer> Products.P2<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider> foliagePlacerParts(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)IntProvider.codec(0, 16).fieldOf("radius").forGetter(placer -> placer.radius), (App)IntProvider.codec(0, 16).fieldOf("offset").forGetter(placer -> placer.offset));
    }

    public FoliagePlacer(IntProvider radius, IntProvider offset) {
        this.radius = radius;
        this.offset = offset;
    }

    protected abstract FoliagePlacerType<?> type();

    public void createFoliage(LevelSimulatedReader world, FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliageAttachment treeNode, int foliageHeight, int radius) {
        this.createFoliage(world, placer, random, config, trunkHeight, treeNode, foliageHeight, radius, this.offset(random));
    }

    protected abstract void createFoliage(LevelSimulatedReader var1, FoliageSetter var2, RandomSource var3, TreeConfiguration var4, int var5, FoliageAttachment var6, int var7, int var8, int var9);

    public abstract int foliageHeight(RandomSource var1, int var2, TreeConfiguration var3);

    public int foliageRadius(RandomSource random, int baseHeight) {
        return this.radius.sample(random);
    }

    private int offset(RandomSource random) {
        return this.offset.sample(random);
    }

    protected abstract boolean shouldSkipLocation(RandomSource var1, int var2, int var3, int var4, int var5, boolean var6);

    protected boolean shouldSkipLocationSigned(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        int l;
        int k;
        if (giantTrunk) {
            int i = Math.min(Math.abs(dx), Math.abs(dx - 1));
            int j = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            k = Math.abs(dx);
            l = Math.abs(dz);
        }
        return this.shouldSkipLocation(random, k, y, l, radius, giantTrunk);
    }

    protected void placeLeavesRow(LevelSimulatedReader world, FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.shouldSkipLocationSigned(random, j, y, k, radius, giantTrunk)) continue;
                mutableBlockPos.setWithOffset(centerPos, j, y, k);
                FoliagePlacer.tryPlaceLeaf(world, placer, random, config, mutableBlockPos);
            }
        }
    }

    protected final void placeLeavesRowWithHangingLeavesBelow(LevelSimulatedReader world, FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk, float hangingLeavesChance, float hangingLeavesExtensionChance) {
        this.placeLeavesRow(world, placer, random, config, centerPos, radius, y, giantTrunk);
        int i = giantTrunk ? 1 : 0;
        BlockPos blockPos = centerPos.below();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Direction direction2 = direction.getClockWise();
            int j = direction2.getAxisDirection() == Direction.AxisDirection.POSITIVE ? radius + i : radius;
            mutableBlockPos.setWithOffset(centerPos, 0, y - 1, 0).move(direction2, j).move(direction, -radius);
            for (int k = -radius; k < radius + i; ++k) {
                boolean bl = placer.isSet(mutableBlockPos.move(Direction.UP));
                mutableBlockPos.move(Direction.DOWN);
                if (bl && FoliagePlacer.tryPlaceExtension(world, placer, random, config, hangingLeavesChance, blockPos, mutableBlockPos)) {
                    mutableBlockPos.move(Direction.DOWN);
                    FoliagePlacer.tryPlaceExtension(world, placer, random, config, hangingLeavesExtensionChance, blockPos, mutableBlockPos);
                    mutableBlockPos.move(Direction.UP);
                }
                mutableBlockPos.move(direction);
            }
        }
    }

    private static boolean tryPlaceExtension(LevelSimulatedReader world, FoliageSetter placer, RandomSource random, TreeConfiguration config, float chance, BlockPos origin, BlockPos.MutableBlockPos pos) {
        if (pos.distManhattan(origin) >= 7) {
            return false;
        }
        if (random.nextFloat() > chance) {
            return false;
        }
        return FoliagePlacer.tryPlaceLeaf(world, placer, random, config, pos);
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader world, FoliageSetter placer, RandomSource random, TreeConfiguration config, BlockPos pos) {
        boolean bl = world.isStateAtPosition(pos, state -> state.getValueOrElse(BlockStateProperties.PERSISTENT, false));
        if (bl || !TreeFeature.validTreePos(world, pos)) {
            return false;
        }
        BlockState blockState = config.foliageProvider.getState(random, pos);
        if (blockState.hasProperty(BlockStateProperties.WATERLOGGED)) {
            blockState = (BlockState)blockState.setValue(BlockStateProperties.WATERLOGGED, world.isFluidAtPosition(pos, fluidState -> fluidState.isSourceOfType(Fluids.WATER)));
        }
        placer.set(pos, blockState);
        return true;
    }

    public static interface FoliageSetter {
        public void set(BlockPos var1, BlockState var2);

        public boolean isSet(BlockPos var1);
    }

    public static final class FoliageAttachment {
        private final BlockPos pos;
        private final int radiusOffset;
        private final boolean doubleTrunk;

        public FoliageAttachment(BlockPos center, int foliageRadius, boolean giantTrunk) {
            this.pos = center;
            this.radiusOffset = foliageRadius;
            this.doubleTrunk = giantTrunk;
        }

        public BlockPos pos() {
            return this.pos;
        }

        public int radiusOffset() {
            return this.radiusOffset;
        }

        public boolean doubleTrunk() {
            return this.doubleTrunk;
        }
    }
}

