/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.groundProbability))).apply((Applicative)instance, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PALE_MOSS;
    }

    public PaleMossDecorator(float leavesProbability, float trunkProbability, float groundProbability) {
        this.leavesProbability = leavesProbability;
        this.trunkProbability = trunkProbability;
        this.groundProbability = groundProbability;
    }

    @Override
    @Override
    public void place(TreeDecorator.Context generator) {
        RandomSource randomSource = generator.random();
        WorldGenLevel worldGenLevel = (WorldGenLevel)generator.level();
        List<BlockPos> list = Util.shuffledCopy(generator.logs(), randomSource);
        if (list.isEmpty()) {
            return;
        }
        MutableObject mutable = new MutableObject((Object)list.getFirst());
        list.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)mutable, arg_0));
        BlockPos blockPos = (BlockPos)mutable.getValue();
        if (randomSource.nextFloat() < this.groundProbability) {
            worldGenLevel.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.get(VegetationFeatures.PALE_MOSS_PATCH_BONEMEAL)).ifPresent(entry -> ((ConfiguredFeature)entry.value()).place(worldGenLevel, worldGenLevel.getLevel().getChunkSource().getGenerator(), randomSource, blockPos.above()));
        }
        generator.logs().forEach(pos -> {
            BlockPos blockPos2;
            BlockPos blockPos;
            if (randomSource.nextFloat() < this.trunkProbability && generator.isAir(blockPos = pos.below())) {
                PaleMossDecorator.addMossHanger(blockPos, generator);
            }
            if (randomSource.nextFloat() < this.trunkProbability && generator.isAir(blockPos2 = pos.above())) {
                MossyCarpetBlock.placeAt((WorldGenLevel)generator.level(), blockPos2, generator.random(), 3);
            }
        });
        generator.leaves().forEach(pos -> {
            BlockPos blockPos;
            if (randomSource.nextFloat() < this.leavesProbability && generator.isAir(blockPos = pos.below())) {
                PaleMossDecorator.addMossHanger(blockPos, generator);
            }
        });
    }

    private static void addMossHanger(BlockPos pos, TreeDecorator.Context generator) {
        while (generator.isAir(pos.below()) && !((double)generator.random().nextFloat() < 0.5)) {
            generator.setBlock(pos, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            pos = pos.below();
        }
        generator.setBlock(pos, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }

    private static /* synthetic */ void lambda$place$4(Mutable mutable, BlockPos pos) {
        if (pos.getY() < ((BlockPos)mutable.getValue()).getY()) {
            mutable.setValue((Object)pos);
        }
    }
}

