/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.StructureFeatureIndexSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class LegacyStructureDataHandler {
    private static final Map<String, String> CURRENT_TO_LEGACY_MAP = Util.make(Maps.newHashMap(), hashmap -> {
        hashmap.put("Village", "Village");
        hashmap.put("Mineshaft", "Mineshaft");
        hashmap.put("Mansion", "Mansion");
        hashmap.put("Igloo", "Temple");
        hashmap.put("Desert_Pyramid", "Temple");
        hashmap.put("Jungle_Pyramid", "Temple");
        hashmap.put("Swamp_Hut", "Temple");
        hashmap.put("Stronghold", "Stronghold");
        hashmap.put("Monument", "Monument");
        hashmap.put("Fortress", "Fortress");
        hashmap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> LEGACY_TO_CURRENT_MAP = Util.make(Maps.newHashMap(), hashmap -> {
        hashmap.put("Iglu", "Igloo");
        hashmap.put("TeDP", "Desert_Pyramid");
        hashmap.put("TeJP", "Jungle_Pyramid");
        hashmap.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> OLD_STRUCTURE_REGISTRY_KEYS = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean hasLegacyData;
    private final Map<String, Long2ObjectMap<CompoundTag>> dataMap = Maps.newHashMap();
    private final Map<String, StructureFeatureIndexSavedData> indexMap = Maps.newHashMap();
    private final List<String> legacyKeys;
    private final List<String> currentKeys;

    public LegacyStructureDataHandler(@Nullable DimensionDataStorage persistentStateManager, List<String> oldNames, List<String> newNames) {
        this.legacyKeys = oldNames;
        this.currentKeys = newNames;
        this.populateCaches(persistentStateManager);
        boolean flag = false;
        for (String s : this.currentKeys) {
            flag |= this.dataMap.get(s) != null;
        }
        this.hasLegacyData = flag;
    }

    public void removeIndex(long chunkPos) {
        for (String s : this.legacyKeys) {
            StructureFeatureIndexSavedData persistentindexed = this.indexMap.get(s);
            if (persistentindexed == null || !persistentindexed.hasUnhandledIndex(chunkPos)) continue;
            persistentindexed.removeIndex(chunkPos);
        }
    }

    public CompoundTag updateFromLegacy(CompoundTag nbt) {
        CompoundTag nbttagcompound1 = nbt.getCompound("Level");
        ChunkPos chunkcoordintpair = new ChunkPos(nbttagcompound1.getInt("xPos"), nbttagcompound1.getInt("zPos"));
        if (this.isUnhandledStructureStart(chunkcoordintpair.x, chunkcoordintpair.z)) {
            nbt = this.updateStructureStart(nbt, chunkcoordintpair);
        }
        CompoundTag nbttagcompound2 = nbttagcompound1.getCompound("Structures");
        CompoundTag nbttagcompound3 = nbttagcompound2.getCompound("References");
        for (String s : this.currentKeys) {
            boolean flag = OLD_STRUCTURE_REGISTRY_KEYS.contains(s.toLowerCase(Locale.ROOT));
            if (nbttagcompound3.contains(s, 12) || !flag) continue;
            boolean flag1 = true;
            LongArrayList longarraylist = new LongArrayList();
            for (int i = chunkcoordintpair.x - 8; i <= chunkcoordintpair.x + 8; ++i) {
                for (int j = chunkcoordintpair.z - 8; j <= chunkcoordintpair.z + 8; ++j) {
                    if (!this.hasLegacyStart(i, j, s)) continue;
                    longarraylist.add(ChunkPos.asLong(i, j));
                }
            }
            nbttagcompound3.putLongArray(s, (List<Long>)longarraylist);
        }
        nbttagcompound2.put("References", nbttagcompound3);
        nbttagcompound1.put("Structures", nbttagcompound2);
        nbt.put("Level", nbttagcompound1);
        return nbt;
    }

    private boolean hasLegacyStart(int chunkX, int chunkZ, String id) {
        return !this.hasLegacyData ? false : this.dataMap.get(id) != null && this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(id)).hasStartIndex(ChunkPos.asLong(chunkX, chunkZ));
    }

    private boolean isUnhandledStructureStart(int chunkX, int chunkZ) {
        String s;
        if (!this.hasLegacyData) {
            return false;
        }
        Iterator<String> iterator = this.currentKeys.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.dataMap.get(s = iterator.next()) == null || !this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s)).hasUnhandledIndex(ChunkPos.asLong(chunkX, chunkZ)));
        return true;
    }

    private CompoundTag updateStructureStart(CompoundTag nbt, ChunkPos pos) {
        CompoundTag nbttagcompound1 = nbt.getCompound("Level");
        CompoundTag nbttagcompound2 = nbttagcompound1.getCompound("Structures");
        CompoundTag nbttagcompound3 = nbttagcompound2.getCompound("Starts");
        for (String s : this.currentKeys) {
            CompoundTag nbttagcompound4;
            Long2ObjectMap<CompoundTag> long2objectmap = this.dataMap.get(s);
            if (long2objectmap == null) continue;
            long i = pos.toLong();
            if (!this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s)).hasUnhandledIndex(i) || (nbttagcompound4 = (CompoundTag)long2objectmap.get(i)) == null) continue;
            nbttagcompound3.put(s, nbttagcompound4);
        }
        nbttagcompound2.put("Starts", nbttagcompound3);
        nbttagcompound1.put("Structures", nbttagcompound2);
        nbt.put("Level", nbttagcompound1);
        return nbt;
    }

    private void populateCaches(@Nullable DimensionDataStorage persistentStateManager) {
        if (persistentStateManager != null) {
            for (String s : this.legacyKeys) {
                CompoundTag nbttagcompound = new CompoundTag();
                try {
                    nbttagcompound = persistentStateManager.readTagFromDisk(s, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES, 1493).getCompound("data").getCompound("Features");
                    if (nbttagcompound.isEmpty()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (String s1 : nbttagcompound.getAllKeys()) {
                    String s2;
                    String s3;
                    CompoundTag nbttagcompound1 = nbttagcompound.getCompound(s1);
                    long i = ChunkPos.asLong(nbttagcompound1.getInt("ChunkX"), nbttagcompound1.getInt("ChunkZ"));
                    ListTag nbttaglist = nbttagcompound1.getList("Children", 10);
                    if (!nbttaglist.isEmpty() && (s3 = LEGACY_TO_CURRENT_MAP.get(s2 = nbttaglist.getCompound(0).getString("id"))) != null) {
                        nbttagcompound1.putString("id", s3);
                    }
                    s2 = nbttagcompound1.getString("id");
                    this.dataMap.computeIfAbsent(s2, s4 -> new Long2ObjectOpenHashMap()).put(i, (Object)nbttagcompound1);
                }
                String s42 = s + "_index";
                StructureFeatureIndexSavedData persistentindexed = persistentStateManager.computeIfAbsent(StructureFeatureIndexSavedData.factory(), s42);
                if (persistentindexed.getAll().isEmpty()) {
                    StructureFeatureIndexSavedData persistentindexed1 = new StructureFeatureIndexSavedData();
                    this.indexMap.put(s, persistentindexed1);
                    for (String s5 : nbttagcompound.getAllKeys()) {
                        CompoundTag nbttagcompound2 = nbttagcompound.getCompound(s5);
                        persistentindexed1.addIndex(ChunkPos.asLong(nbttagcompound2.getInt("ChunkX"), nbttagcompound2.getInt("ChunkZ")));
                    }
                    continue;
                }
                this.indexMap.put(s, persistentindexed);
            }
        }
    }

    public static LegacyStructureDataHandler getLegacyStructureHandler(ResourceKey<LevelStem> world, @Nullable DimensionDataStorage persistentStateManager) {
        if (world == LevelStem.OVERWORLD) {
            return new LegacyStructureDataHandler(persistentStateManager, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (world == LevelStem.NETHER) {
            ImmutableList immutablelist = ImmutableList.of((Object)"Fortress");
            return new LegacyStructureDataHandler(persistentStateManager, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        if (world == LevelStem.END) {
            ImmutableList immutablelist = ImmutableList.of((Object)"EndCity");
            return new LegacyStructureDataHandler(persistentStateManager, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", world));
    }
}

