/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class ScatteredFeaturePiece
extends StructurePiece {
    protected final int width;
    protected final int height;
    protected final int depth;
    protected int heightPosition = -1;

    protected ScatteredFeaturePiece(StructurePieceType type, int x, int y, int z, int width, int height, int depth, Direction orientation) {
        super(type, 0, StructurePiece.makeBoundingBox(x, y, z, orientation, width, height, depth));
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.setOrientation(orientation);
    }

    protected ScatteredFeaturePiece(StructurePieceType type, CompoundTag nbt) {
        super(type, nbt);
        this.width = nbt.getInt("Width");
        this.height = nbt.getInt("Height");
        this.depth = nbt.getInt("Depth");
        this.heightPosition = nbt.getInt("HPos");
    }

    @Override
    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        nbt.putInt("Width", this.width);
        nbt.putInt("Height", this.height);
        nbt.putInt("Depth", this.depth);
        nbt.putInt("HPos", this.heightPosition);
    }

    protected boolean updateAverageGroundHeight(LevelAccessor world, BoundingBox boundingBox, int deltaY) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int k = this.boundingBox.minZ(); k <= this.boundingBox.maxZ(); ++k) {
            for (int l = this.boundingBox.minX(); l <= this.boundingBox.maxX(); ++l) {
                mutableBlockPos.set(l, 64, k);
                if (!boundingBox.isInside(mutableBlockPos)) continue;
                i += world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, mutableBlockPos).getY();
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.heightPosition = i / j;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + deltaY, 0);
        return true;
    }

    protected boolean updateHeightPositionToLowestGroundHeight(LevelAccessor world, int yOffset) {
        if (this.heightPosition >= 0) {
            return true;
        }
        int i = world.getMaxY() + 1;
        boolean bl = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int j = this.boundingBox.minZ(); j <= this.boundingBox.maxZ(); ++j) {
            for (int k = this.boundingBox.minX(); k <= this.boundingBox.maxX(); ++k) {
                mutableBlockPos.set(k, 0, j);
                i = Math.min(i, world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, mutableBlockPos).getY());
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        this.heightPosition = i;
        this.boundingBox.move(0, this.heightPosition - this.boundingBox.minY() + yOffset, 0);
        return true;
    }
}

