/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkSkyLightSources {
    private static final int SIZE = 16;
    public static final int NEGATIVE_INFINITY = Integer.MIN_VALUE;
    private final int minY;
    private final BitStorage heightmap;
    private final BlockPos.MutableBlockPos mutablePos1 = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos mutablePos2 = new BlockPos.MutableBlockPos();

    public ChunkSkyLightSources(LevelHeightAccessor heightLimitView) {
        this.minY = heightLimitView.getMinY() - 1;
        int i = heightLimitView.getMaxY() + 1;
        int j = Mth.ceillog2(i - this.minY + 1);
        this.heightmap = new SimpleBitStorage(j, 256);
    }

    public void fillFrom(ChunkAccess chunk) {
        int i = chunk.getHighestFilledSectionIndex();
        if (i == -1) {
            this.fill(this.minY);
            return;
        }
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                int l = Math.max(this.findLowestSourceY(chunk, i, k, j), this.minY);
                this.set(ChunkSkyLightSources.index(k, j), l);
            }
        }
    }

    private int findLowestSourceY(ChunkAccess chunk, int topSectionIndex, int localX, int localZ) {
        int i = SectionPos.sectionToBlockCoord(chunk.getSectionYFromSectionIndex(topSectionIndex) + 1);
        BlockPos.MutableBlockPos mutableBlockPos = this.mutablePos1.set(localX, i, localZ);
        BlockPos.MutableBlockPos mutableBlockPos2 = this.mutablePos2.setWithOffset((Vec3i)mutableBlockPos, Direction.DOWN);
        BlockState blockState = Blocks.AIR.defaultBlockState();
        for (int j = topSectionIndex; j >= 0; --j) {
            LevelChunkSection levelChunkSection = chunk.getSection(j);
            if (levelChunkSection.hasOnlyAir()) {
                blockState = Blocks.AIR.defaultBlockState();
                int k = chunk.getSectionYFromSectionIndex(j);
                mutableBlockPos.setY(SectionPos.sectionToBlockCoord(k));
                mutableBlockPos2.setY(mutableBlockPos.getY() - 1);
                continue;
            }
            for (int l = 15; l >= 0; --l) {
                BlockState blockState2 = levelChunkSection.getBlockState(localX, l, localZ);
                if (ChunkSkyLightSources.isEdgeOccluded(blockState, blockState2)) {
                    return mutableBlockPos.getY();
                }
                blockState = blockState2;
                mutableBlockPos.set(mutableBlockPos2);
                mutableBlockPos2.move(Direction.DOWN);
            }
        }
        return this.minY;
    }

    public boolean update(BlockGetter blockView, int localX, int y, int localZ) {
        BlockState blockState2;
        BlockPos.MutableBlockPos blockPos2;
        BlockState blockState;
        int i = y + 1;
        int j = ChunkSkyLightSources.index(localX, localZ);
        int k = this.get(j);
        if (i < k) {
            return false;
        }
        BlockPos.MutableBlockPos blockPos = this.mutablePos1.set(localX, y + 1, localZ);
        if (this.updateEdge(blockView, j, k, blockPos, blockState = blockView.getBlockState(blockPos), blockPos2 = this.mutablePos2.set(localX, y, localZ), blockState2 = blockView.getBlockState(blockPos2))) {
            return true;
        }
        BlockPos.MutableBlockPos blockPos3 = this.mutablePos1.set(localX, y - 1, localZ);
        BlockState blockState3 = blockView.getBlockState(blockPos3);
        return this.updateEdge(blockView, j, k, blockPos2, blockState2, blockPos3, blockState3);
    }

    private boolean updateEdge(BlockGetter blockView, int packedIndex, int value, BlockPos upperPos, BlockState upperState, BlockPos lowerPos, BlockState lowerState) {
        int i = upperPos.getY();
        if (ChunkSkyLightSources.isEdgeOccluded(upperState, lowerState)) {
            if (i > value) {
                this.set(packedIndex, i);
                return true;
            }
        } else if (i == value) {
            this.set(packedIndex, this.findLowestSourceBelow(blockView, lowerPos, lowerState));
            return true;
        }
        return false;
    }

    private int findLowestSourceBelow(BlockGetter blockView, BlockPos pos, BlockState blockState) {
        BlockPos.MutableBlockPos mutableBlockPos = this.mutablePos1.set(pos);
        BlockPos.MutableBlockPos mutableBlockPos2 = this.mutablePos2.setWithOffset((Vec3i)pos, Direction.DOWN);
        BlockState blockState2 = blockState;
        while (mutableBlockPos2.getY() >= this.minY) {
            BlockState blockState3 = blockView.getBlockState(mutableBlockPos2);
            if (ChunkSkyLightSources.isEdgeOccluded(blockState2, blockState3)) {
                return mutableBlockPos.getY();
            }
            blockState2 = blockState3;
            mutableBlockPos.set(mutableBlockPos2);
            mutableBlockPos2.move(Direction.DOWN);
        }
        return this.minY;
    }

    private static boolean isEdgeOccluded(BlockState upper, BlockState lower) {
        if (lower.getLightBlock() != 0) {
            return true;
        }
        VoxelShape voxelShape = LightEngine.getOcclusionShape(upper, Direction.DOWN);
        VoxelShape voxelShape2 = LightEngine.getOcclusionShape(lower, Direction.UP);
        return Shapes.faceShapeOccludes(voxelShape, voxelShape2);
    }

    public int getLowestSourceY(int localX, int localZ) {
        int i = this.get(ChunkSkyLightSources.index(localX, localZ));
        return this.extendSourcesBelowWorld(i);
    }

    public int getHighestLowestSourceY() {
        int i = Integer.MIN_VALUE;
        for (int j = 0; j < this.heightmap.getSize(); ++j) {
            int k = this.heightmap.get(j);
            if (k <= i) continue;
            i = k;
        }
        return this.extendSourcesBelowWorld(i + this.minY);
    }

    private void fill(int y) {
        int i = y - this.minY;
        for (int j = 0; j < this.heightmap.getSize(); ++j) {
            this.heightmap.set(j, i);
        }
    }

    private void set(int index, int y) {
        this.heightmap.set(index, y - this.minY);
    }

    private int get(int index) {
        return this.heightmap.get(index) + this.minY;
    }

    private int extendSourcesBelowWorld(int y) {
        if (y == this.minY) {
            return Integer.MIN_VALUE;
        }
        return y;
    }

    private static int index(int localX, int localZ) {
        return localX + localZ * 16;
    }
}

