/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public abstract class LavaFluid
extends FlowingFluid {
    public static final float MIN_LEVEL_CUTOFF = 0.44444445f;

    @Override
    public Fluid getFlowing() {
        return Fluids.FLOWING_LAVA;
    }

    @Override
    public Fluid getSource() {
        return Fluids.LAVA;
    }

    @Override
    public Item getBucket() {
        return Items.LAVA_BUCKET;
    }

    @Override
    public void animateTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos blockposition1 = pos.above();
        if (world.getBlockState(blockposition1).isAir() && !world.getBlockState(blockposition1).isSolidRender()) {
            if (random.nextInt(100) == 0) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + 1.0;
                double d2 = (double)pos.getZ() + random.nextDouble();
                world.addParticle(ParticleTypes.LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
                world.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                world.playLocalSound(pos.getX(), pos.getY(), pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public void randomTick(ServerLevel world, BlockPos pos, FluidState state, RandomSource random) {
        block7: {
            if (!world.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockposition1 = pos;
                for (int j = 0; j < i; ++j) {
                    if (!world.isLoaded(blockposition1 = blockposition1.offset(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState iblockdata = world.getBlockState(blockposition1);
                    if (iblockdata.isAir()) {
                        if (!this.hasFlammableNeighbours(world, blockposition1) || world.getBlockState(blockposition1).getBlock() != Blocks.FIRE && CraftEventFactory.callBlockIgniteEvent((Level)world, blockposition1, pos).isCancelled()) continue;
                        world.setBlockAndUpdate(blockposition1, BaseFireBlock.getState(world, blockposition1));
                        return;
                    }
                    if (!iblockdata.blocksMotion()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos up;
                    BlockPos blockposition2 = pos.offset(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!world.isLoaded(blockposition2)) {
                        return;
                    }
                    if (!world.isEmptyBlock(blockposition2.above()) || !this.isFlammable(world, blockposition2) || world.getBlockState(up = blockposition2.above()).getBlock() != Blocks.FIRE && CraftEventFactory.callBlockIgniteEvent((Level)world, up, pos).isCancelled()) continue;
                    world.setBlockAndUpdate(blockposition2.above(), BaseFireBlock.getState(world, blockposition2));
                }
            }
        }
    }

    private boolean hasFlammableNeighbours(LevelReader world, BlockPos pos) {
        for (Direction enumdirection : Direction.values()) {
            if (!this.isFlammable(world, pos.relative(enumdirection))) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(LevelReader world, BlockPos pos) {
        return world.isInsideBuildHeight(pos.getY()) && !world.hasChunkAt(pos) ? false : world.getBlockState(pos).ignitedByLava();
    }

    @Override
    @Nullable
    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_LAVA;
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        this.fizz(world, pos);
    }

    @Override
    public int getSlopeFindDistance(LevelReader world) {
        return world.dimensionType().ultraWarm() ? 4 : 2;
    }

    @Override
    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)Blocks.LAVA.defaultBlockState().setValue(LiquidBlock.LEVEL, LavaFluid.getLegacyLevel(state));
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid == Fluids.LAVA || fluid == Fluids.FLOWING_LAVA;
    }

    @Override
    public int getDropOff(LevelReader world) {
        return world.dimensionType().ultraWarm() ? 1 : 2;
    }

    @Override
    public boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
        return state.getHeight(world, pos) >= 0.44444445f && fluid.is(FluidTags.WATER);
    }

    @Override
    public int getTickDelay(LevelReader world) {
        return world.dimensionType().ultraWarm() ? 10 : 30;
    }

    @Override
    public int getSpreadDelay(Level world, BlockPos pos, FluidState oldState, FluidState newState) {
        int i = this.getTickDelay(world);
        if (!(oldState.isEmpty() || newState.isEmpty() || oldState.getValue(FlowingFluid.FALLING).booleanValue() || newState.getValue(FlowingFluid.FALLING).booleanValue() || !(newState.getHeight(world, pos) > oldState.getHeight(world, pos)) || world.getRandom().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    private void fizz(LevelAccessor world, BlockPos pos) {
        world.levelEvent(1501, pos, 0);
    }

    @Override
    protected boolean canConvertToSource(ServerLevel world) {
        return world.getGameRules().getBoolean(GameRules.RULE_LAVA_SOURCE_CONVERSION);
    }

    @Override
    protected void spreadTo(LevelAccessor world, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN) {
            FluidState fluid1 = world.getFluidState(pos);
            if (this.is(FluidTags.LAVA) && fluid1.is(FluidTags.WATER)) {
                if (state.getBlock() instanceof LiquidBlock && !CraftEventFactory.handleBlockFormEvent((Level)world.getMinecraftWorld(), pos, Blocks.STONE.defaultBlockState(), 3)) {
                    return;
                }
                this.fizz(world, pos);
                return;
            }
        }
        super.spreadTo(world, pos, state, direction, fluidState);
    }

    @Override
    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    protected float getExplosionResistance() {
        return Blocks.LAVA.getExplosionResistance();
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL_LAVA);
    }

    public static class Source
    extends LavaFluid {
        @Override
        public int getAmount(FluidState state) {
            return 8;
        }

        @Override
        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends LavaFluid {
        @Override
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(FlowingFluid.LEVEL);
        }

        @Override
        public int getAmount(FluidState state) {
            return state.getValue(FlowingFluid.LEVEL);
        }

        @Override
        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

