/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class ExperimentalRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    private final Deque<BlockPos> wiresToTurnOff = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> wiresToTurnOn = new ArrayDeque<BlockPos>();
    private final Object2IntMap<BlockPos> updatedWires = new Object2IntLinkedOpenHashMap();

    public ExperimentalRedstoneWireEvaluator(RedStoneWireBlock wire) {
        super(wire);
    }

    @Override
    public void updatePowerStrength(Level world, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean blockAdded) {
        Orientation orientation1 = ExperimentalRedstoneWireEvaluator.getInitialOrientation(world, orientation);
        this.calculateCurrentChanges(world, pos, orientation1);
        ObjectIterator objectiterator = this.updatedWires.object2IntEntrySet().iterator();
        boolean flag1 = true;
        while (objectiterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectiterator.next();
            BlockPos blockposition1 = (BlockPos)entry.getKey();
            int i = entry.getIntValue();
            int j = ExperimentalRedstoneWireEvaluator.unpackPower(i);
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            int oldPower = iblockdata1.getValue(RedStoneWireBlock.POWER);
            if (oldPower != j) {
                BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(world, blockposition1), oldPower, j);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                j = event.getNewCurrent();
            }
            if (iblockdata1.is(this.wireBlock) && oldPower != j) {
                int k = 2;
                if (!blockAdded || !flag1) {
                    k |= 0x80;
                }
                world.setBlock(blockposition1, (BlockState)iblockdata1.setValue(RedStoneWireBlock.POWER, j), k);
            } else {
                objectiterator.remove();
            }
            flag1 = false;
        }
        this.causeNeighborUpdates(world);
    }

    private void causeNeighborUpdates(Level world) {
        this.updatedWires.forEach((blockposition, integer) -> {
            Orientation orientation = ExperimentalRedstoneWireEvaluator.unpackOrientation(integer);
            BlockState iblockdata = world.getBlockState((BlockPos)blockposition);
            for (Direction enumdirection : orientation.getDirections()) {
                if (!ExperimentalRedstoneWireEvaluator.isConnected(iblockdata, enumdirection)) continue;
                BlockPos blockposition1 = blockposition.relative(enumdirection);
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                Orientation orientation1 = orientation.withFrontPreserveUp(enumdirection);
                world.neighborChanged(iblockdata1, blockposition1, this.wireBlock, orientation1, false);
                if (!iblockdata1.isRedstoneConductor(world, blockposition1)) continue;
                for (Direction enumdirection1 : orientation1.getDirections()) {
                    if (enumdirection1 == enumdirection.getOpposite()) continue;
                    world.neighborChanged(blockposition1.relative(enumdirection1), this.wireBlock, orientation1.withFrontPreserveUp(enumdirection1));
                }
            }
        });
    }

    private static boolean isConnected(BlockState wireState, Direction direction) {
        EnumProperty<RedstoneSide> blockstateenum = RedStoneWireBlock.PROPERTY_BY_DIRECTION.get(direction);
        return blockstateenum == null ? direction == Direction.DOWN : wireState.getValue(blockstateenum).isConnected();
    }

    private static Orientation getInitialOrientation(Level world, @Nullable Orientation orientation) {
        Orientation orientation1 = orientation != null ? orientation : Orientation.random(world.random);
        return orientation1.withUp(Direction.UP).withSideBias(Orientation.SideBias.LEFT);
    }

    private void calculateCurrentChanges(Level world, BlockPos pos, Orientation orientation) {
        int l;
        int k;
        int j;
        int i;
        BlockPos blockposition1;
        BlockState iblockdata = world.getBlockState(pos);
        if (iblockdata.is(this.wireBlock)) {
            this.setPower(pos, iblockdata.getValue(RedStoneWireBlock.POWER), orientation);
            this.wiresToTurnOff.add(pos);
        } else {
            this.propagateChangeToNeighbors(world, pos, 0, orientation, true);
        }
        while (!this.wiresToTurnOff.isEmpty()) {
            int j1;
            blockposition1 = this.wiresToTurnOff.removeFirst();
            i = this.updatedWires.getInt((Object)blockposition1);
            Orientation orientation1 = ExperimentalRedstoneWireEvaluator.unpackOrientation(i);
            j = ExperimentalRedstoneWireEvaluator.unpackPower(i);
            k = this.getBlockSignal(world, blockposition1);
            int i1 = Math.max(k, l = this.getIncomingWireSignal(world, blockposition1));
            if (i1 < j) {
                if (k > 0 && !this.wiresToTurnOn.contains(blockposition1)) {
                    this.wiresToTurnOn.add(blockposition1);
                }
                j1 = 0;
            } else {
                j1 = i1;
            }
            if (j1 != j) {
                this.setPower(blockposition1, j1, orientation1);
            }
            this.propagateChangeToNeighbors(world, blockposition1, j1, orientation1, j > i1);
        }
        while (!this.wiresToTurnOn.isEmpty()) {
            blockposition1 = this.wiresToTurnOn.removeFirst();
            i = this.updatedWires.getInt((Object)blockposition1);
            int k1 = ExperimentalRedstoneWireEvaluator.unpackPower(i);
            j = this.getBlockSignal(world, blockposition1);
            k = this.getIncomingWireSignal(world, blockposition1);
            l = Math.max(j, k);
            Orientation orientation2 = ExperimentalRedstoneWireEvaluator.unpackOrientation(i);
            if (l > k1) {
                this.setPower(blockposition1, l, orientation2);
            } else if (l < k1) {
                throw new IllegalStateException("Turning off wire while trying to turn it on. Should not happen.");
            }
            this.propagateChangeToNeighbors(world, blockposition1, l, orientation2, false);
        }
    }

    private static int packOrientationAndPower(Orientation orientation, int power) {
        return orientation.getIndex() << 4 | power;
    }

    private static Orientation unpackOrientation(int packed) {
        return Orientation.fromIndex(packed >> 4);
    }

    private static int unpackPower(int packed) {
        return packed & 0xF;
    }

    private void setPower(BlockPos pos, int power, Orientation defaultOrientation) {
        this.updatedWires.compute((Object)pos, (blockposition1, integer) -> integer == null ? ExperimentalRedstoneWireEvaluator.packOrientationAndPower(defaultOrientation, power) : ExperimentalRedstoneWireEvaluator.packOrientationAndPower(ExperimentalRedstoneWireEvaluator.unpackOrientation(integer), power));
    }

    private void propagateChangeToNeighbors(Level world, BlockPos pos, int power, Orientation orientation, boolean canIncreasePower) {
        BlockPos blockposition1;
        for (Direction enumdirection : orientation.getHorizontalDirections()) {
            blockposition1 = pos.relative(enumdirection);
            this.enqueueNeighborWire(world, blockposition1, power, orientation.withFront(enumdirection), canIncreasePower);
        }
        for (Direction enumdirection : orientation.getVerticalDirections()) {
            blockposition1 = pos.relative(enumdirection);
            boolean flag1 = world.getBlockState(blockposition1).isRedstoneConductor(world, blockposition1);
            for (Direction enumdirection1 : orientation.getHorizontalDirections()) {
                BlockPos blockposition3;
                BlockPos blockposition2 = pos.relative(enumdirection1);
                if (enumdirection == Direction.UP && !flag1) {
                    blockposition3 = blockposition1.relative(enumdirection1);
                    this.enqueueNeighborWire(world, blockposition3, power, orientation.withFront(enumdirection1), canIncreasePower);
                    continue;
                }
                if (enumdirection != Direction.DOWN || world.getBlockState(blockposition2).isRedstoneConductor(world, blockposition2)) continue;
                blockposition3 = blockposition1.relative(enumdirection1);
                this.enqueueNeighborWire(world, blockposition3, power, orientation.withFront(enumdirection1), canIncreasePower);
            }
        }
    }

    private void enqueueNeighborWire(Level world, BlockPos neighborPos, int power, Orientation orientation, boolean canIncreasePower) {
        BlockState iblockdata = world.getBlockState(neighborPos);
        if (iblockdata.is(this.wireBlock)) {
            int j = this.getWireSignal(neighborPos, iblockdata);
            if (j < power - 1 && !this.wiresToTurnOn.contains(neighborPos)) {
                this.wiresToTurnOn.add(neighborPos);
                this.setPower(neighborPos, j, orientation);
            }
            if (canIncreasePower && j > power && !this.wiresToTurnOff.contains(neighborPos)) {
                this.wiresToTurnOff.add(neighborPos);
                this.setPower(neighborPos, j, orientation);
            }
        }
    }

    @Override
    protected int getWireSignal(BlockPos world, BlockState pos) {
        int i = this.updatedWires.getOrDefault((Object)world, -1);
        return i != -1 ? ExperimentalRedstoneWireEvaluator.unpackPower(i) : super.getWireSignal(world, pos);
    }
}

