/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;

public interface NeighborUpdater {
    public static final Direction[] UPDATE_ORDER = new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};

    public void shapeUpdate(Direction var1, BlockState var2, BlockPos var3, BlockPos var4, int var5, int var6);

    public void neighborChanged(BlockPos var1, Block var2, @Nullable Orientation var3);

    public void neighborChanged(BlockState var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5);

    default public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block sourceBlock, @Nullable Direction except, @Nullable Orientation orientation) {
        for (Direction enumdirection1 : UPDATE_ORDER) {
            if (enumdirection1 == except) continue;
            this.neighborChanged(pos.relative(enumdirection1), sourceBlock, null);
        }
    }

    public static void executeShapeUpdate(LevelAccessor world, Direction direction, BlockPos pos, BlockPos neighborPos, BlockState neighborState, int flags, int maxUpdateDepth) {
        BlockState iblockdata1 = world.getBlockState(pos);
        if ((flags & 0x80) == 0 || !iblockdata1.is(Blocks.REDSTONE_WIRE)) {
            BlockState iblockdata2 = iblockdata1.updateShape(world, world, pos, direction, neighborPos, neighborState, world.getRandom());
            Block.updateOrDestroy(iblockdata1, iblockdata2, world, pos, flags, maxUpdateDepth);
        }
    }

    public static void executeUpdate(Level world, BlockState state, BlockPos pos, Block sourceBlock, @Nullable Orientation orientation, boolean notify) {
        NeighborUpdater.executeUpdate(world, state, pos, sourceBlock, orientation, notify, pos);
    }

    public static void executeUpdate(Level world, BlockState state, BlockPos pos, Block sourceBlock, @Nullable Orientation orientation, boolean notify, BlockPos sourcePos) {
        try {
            CraftWorld cworld = ((ServerLevel)world).getWorld();
            if (cworld != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), (BlockData)CraftBlockData.fromData(state), (org.bukkit.block.Block)CraftBlock.at(world, sourcePos));
                ((ServerLevel)world).getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            state.handleNeighborChanged(world, pos, sourceBlock, orientation, notify);
        }
        catch (StackOverflowError ex) {
            Level.lastPhysicsProblem = new BlockPos(pos);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception while updating neighbours");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Block being updated");
            crashreportsystemdetails.setDetail("Source block type", () -> {
                try {
                    return String.format(Locale.ROOT, "ID #%s (%s // %s)", BuiltInRegistries.BLOCK.getKey(sourceBlock), sourceBlock.getDescriptionId(), sourceBlock.getClass().getCanonicalName());
                }
                catch (Throwable throwable1) {
                    return "ID #" + String.valueOf(BuiltInRegistries.BLOCK.getKey(sourceBlock));
                }
            });
            CrashReportCategory.populateBlockDetails(crashreportsystemdetails, world, pos, state);
            throw new ReportedException(crashreport);
        }
    }
}

