/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;

public class Orientation {
    public static final StreamCodec<ByteBuf, Orientation> STREAM_CODEC = ByteBufCodecs.idMapper(Orientation::fromIndex, Orientation::getIndex);
    private static final Orientation[] ORIENTATIONS = Util.make(() -> {
        Orientation[] orientations = new Orientation[48];
        Orientation.generateContext(new Orientation(Direction.UP, Direction.NORTH, SideBias.LEFT), orientations);
        return orientations;
    });
    private final Direction up;
    private final Direction front;
    private final Direction side;
    private final SideBias sideBias;
    private final int index;
    private final List<Direction> neighbors;
    private final List<Direction> horizontalNeighbors;
    private final List<Direction> verticalNeighbors;
    private final Map<Direction, Orientation> withFront = new EnumMap<Direction, Orientation>(Direction.class);
    private final Map<Direction, Orientation> withUp = new EnumMap<Direction, Orientation>(Direction.class);
    private final Map<SideBias, Orientation> withSideBias = new EnumMap<SideBias, Orientation>(SideBias.class);

    private Orientation(Direction up, Direction front, SideBias sideBias) {
        this.up = up;
        this.front = front;
        this.sideBias = sideBias;
        this.index = Orientation.generateIndex(up, front, sideBias);
        Vec3i vec3i = front.getUnitVec3i().cross(up.getUnitVec3i());
        Direction direction2 = Direction.getNearest(vec3i, null);
        Objects.requireNonNull(direction2);
        this.side = this.sideBias == SideBias.RIGHT ? direction2 : direction2.getOpposite();
        this.neighbors = List.of(this.front.getOpposite(), this.front, this.side, this.side.getOpposite(), this.up.getOpposite(), this.up);
        this.horizontalNeighbors = this.neighbors.stream().filter(direction -> direction.getAxis() != this.up.getAxis()).toList();
        this.verticalNeighbors = this.neighbors.stream().filter(direction -> direction.getAxis() == this.up.getAxis()).toList();
    }

    public static Orientation of(Direction up, Direction front, SideBias sideBias) {
        return ORIENTATIONS[Orientation.generateIndex(up, front, sideBias)];
    }

    public Orientation withUp(Direction direction) {
        return this.withUp.get(direction);
    }

    public Orientation withFront(Direction direction) {
        return this.withFront.get(direction);
    }

    public Orientation withFrontPreserveUp(Direction direction) {
        if (direction.getAxis() == this.up.getAxis()) {
            return this;
        }
        return this.withFront.get(direction);
    }

    public Orientation withFrontAdjustSideBias(Direction direction) {
        Orientation orientation = this.withFront(direction);
        if (this.front == orientation.side) {
            return orientation.withMirror();
        }
        return orientation;
    }

    public Orientation withSideBias(SideBias sideBias) {
        return this.withSideBias.get((Object)sideBias);
    }

    public Orientation withMirror() {
        return this.withSideBias(this.sideBias.getOpposite());
    }

    public Direction getFront() {
        return this.front;
    }

    public Direction getUp() {
        return this.up;
    }

    public Direction getSide() {
        return this.side;
    }

    public SideBias getSideBias() {
        return this.sideBias;
    }

    public List<Direction> getDirections() {
        return this.neighbors;
    }

    public List<Direction> getHorizontalDirections() {
        return this.horizontalNeighbors;
    }

    public List<Direction> getVerticalDirections() {
        return this.verticalNeighbors;
    }

    @Override
    public String toString() {
        return "[up=" + String.valueOf(this.up) + ",front=" + String.valueOf(this.front) + ",sideBias=" + String.valueOf((Object)this.sideBias) + "]";
    }

    public int getIndex() {
        return this.index;
    }

    public static Orientation fromIndex(int ordinal) {
        return ORIENTATIONS[ordinal];
    }

    public static Orientation random(RandomSource random) {
        return Util.getRandom(ORIENTATIONS, random);
    }

    private static Orientation generateContext(Orientation prime, Orientation[] valuesOut) {
        if (valuesOut[prime.getIndex()] != null) {
            return valuesOut[prime.getIndex()];
        }
        valuesOut[prime.getIndex()] = prime;
        for (SideBias sideBias : SideBias.values()) {
            prime.withSideBias.put(sideBias, Orientation.generateContext(new Orientation(prime.up, prime.front, sideBias), valuesOut));
        }
        for (Enum enum_ : Direction.values()) {
            Direction direction2 = prime.up;
            if (enum_ == prime.up) {
                direction2 = prime.front.getOpposite();
            }
            if (enum_ == prime.up.getOpposite()) {
                direction2 = prime.front;
            }
            prime.withFront.put((Direction)enum_, Orientation.generateContext(new Orientation(direction2, (Direction)enum_, prime.sideBias), valuesOut));
        }
        for (Enum enum_ : Direction.values()) {
            Direction direction4 = prime.front;
            if (enum_ == prime.front) {
                direction4 = prime.up.getOpposite();
            }
            if (enum_ == prime.front.getOpposite()) {
                direction4 = prime.up;
            }
            prime.withUp.put((Direction)enum_, Orientation.generateContext(new Orientation((Direction)enum_, direction4, prime.sideBias), valuesOut));
        }
        return prime;
    }

    @VisibleForTesting
    protected static int generateIndex(Direction up, Direction front, SideBias sideBias) {
        int j;
        if (up.getAxis() == front.getAxis()) {
            throw new IllegalStateException("Up-vector and front-vector can not be on the same axis");
        }
        if (up.getAxis() == Direction.Axis.Y) {
            boolean i = front.getAxis() == Direction.Axis.X;
        } else {
            j = front.getAxis() == Direction.Axis.Y ? 1 : 0;
        }
        int k = j << 1 | front.getAxisDirection().ordinal();
        return ((up.ordinal() << 2) + k << 1) + sideBias.ordinal();
    }

    public static enum SideBias {
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private SideBias(String name) {
            this.name = name;
        }

        public SideBias getOpposite() {
            return this == LEFT ? RIGHT : LEFT;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

