/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;

public abstract class RedstoneWireEvaluator {
    protected final RedStoneWireBlock wireBlock;

    protected RedstoneWireEvaluator(RedStoneWireBlock wire) {
        this.wireBlock = wire;
    }

    public abstract void updatePowerStrength(Level var1, BlockPos var2, BlockState var3, @Nullable Orientation var4, boolean var5);

    protected int getBlockSignal(Level world, BlockPos pos) {
        return this.wireBlock.getBlockSignal(world, pos);
    }

    protected int getWireSignal(BlockPos world, BlockState pos) {
        return pos.is(this.wireBlock) ? pos.getValue(RedStoneWireBlock.POWER) : 0;
    }

    protected int getIncomingWireSignal(Level world, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            i = Math.max(i, this.getWireSignal(blockPos, blockState));
            BlockPos blockPos2 = pos.above();
            if (blockState.isRedstoneConductor(world, blockPos) && !world.getBlockState(blockPos2).isRedstoneConductor(world, blockPos2)) {
                BlockPos blockPos3 = blockPos.above();
                i = Math.max(i, this.getWireSignal(blockPos3, world.getBlockState(blockPos3)));
                continue;
            }
            if (blockState.isRedstoneConductor(world, blockPos)) continue;
            BlockPos blockPos4 = blockPos.below();
            i = Math.max(i, this.getWireSignal(blockPos4, world.getBlockState(blockPos4)));
        }
        return Math.max(0, i - 1);
    }
}

