/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<String, Optional<SavedData>> cache = new HashMap<String, Optional<SavedData>>();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(Path directory, DataFixer dataFixer, HolderLookup.Provider registries) {
        this.fixerUpper = dataFixer;
        this.dataFolder = directory;
        this.registries = registries;
    }

    private Path getDataFile(String id) {
        return this.dataFolder.resolve(id + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> type, String id) {
        T savedData = this.get(type, id);
        if (savedData != null) {
            return savedData;
        }
        SavedData savedData2 = (SavedData)type.constructor().get();
        this.set(id, savedData2);
        return (T)savedData2;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> type, String id) {
        Optional<SavedData> optional = this.cache.get(id);
        if (optional == null) {
            optional = Optional.ofNullable(this.readSavedData(type.deserializer(), type.type(), id));
            this.cache.put(id, optional);
        }
        return (T)((SavedData)optional.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> readFunction, DataFixTypes dataFixTypes, String id) {
        try {
            Path path = this.getDataFile(id);
            if (Files.exists(path, new LinkOption[0])) {
                CompoundTag compoundTag = this.readTagFromDisk(id, dataFixTypes, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)readFunction.apply(compoundTag.getCompound("data"), this.registries));
            }
        }
        catch (Exception var6) {
            LOGGER.error("Error loading saved data: {}", (Object)id, (Object)var6);
        }
        return null;
    }

    public void set(String id, SavedData state) {
        this.cache.put(id, Optional.of(state));
        state.setDirty();
    }

    public CompoundTag readTagFromDisk(String id, DataFixTypes dataFixTypes, int currentSaveVersion) throws IOException {
        CompoundTag var8;
        try (InputStream inputStream = Files.newInputStream(this.getDataFile(id), new OpenOption[0]);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(new FastBufferedInputStream(inputStream), 2);){
            CompoundTag compoundTag;
            if (this.isGzip(pushbackInputStream)) {
                compoundTag = NbtIo.readCompressed(pushbackInputStream, NbtAccounter.unlimitedHeap());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compoundTag = NbtIo.read(dataInputStream);
                }
            }
            int i = NbtUtils.getDataVersion(compoundTag, 1343);
            var8 = dataFixTypes.update(this.fixerUpper, compoundTag, i, currentSaveVersion);
        }
        return var8;
    }

    private boolean isGzip(PushbackInputStream stream) throws IOException {
        int j;
        byte[] bs = new byte[2];
        boolean bl = false;
        int i = stream.read(bs, 0, 2);
        if (i == 2 && (j = (bs[1] & 0xFF) << 8 | bs[0] & 0xFF) == 35615) {
            bl = true;
        }
        if (i != 0) {
            stream.unread(bs, 0, i);
        }
        return bl;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<Path, CompoundTag> map = this.collectDirtyTagsToSave();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.pendingWriteFuture = this.pendingWriteFuture.thenCompose(v -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DimensionDataStorage.tryWriteAsync((Path)entry.getKey(), (CompoundTag)entry.getValue())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<Path, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$4((Map)map, arg_0, arg_1));
        return map;
    }

    private static CompletableFuture<Void> tryWriteAsync(Path path, CompoundTag nbt) {
        return CompletableFuture.runAsync(() -> {
            try {
                NbtIo.writeCompressed(nbt, path);
            }
            catch (IOException var3) {
                LOGGER.error("Could not save data to {}", (Object)path.getFileName(), (Object)var3);
            }
        }, Util.DIMENSION_DATA_IO_POOL);
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$4(Map map, String id, Optional state) {
        state.filter(SavedData::isDirty).ifPresent(state2 -> map.put(this.getDataFile(id), state2.save(this.registries)));
    }
}

