/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class IntRange {
    private static final Codec<IntRange> RECORD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NumberProviders.CODEC.optionalFieldOf("min").forGetter(operator -> Optional.ofNullable(operator.min)), (App)NumberProviders.CODEC.optionalFieldOf("max").forGetter(operator -> Optional.ofNullable(operator.max))).apply((Applicative)instance, IntRange::new));
    public static final Codec<IntRange> CODEC = Codec.either((Codec)Codec.INT, RECORD_CODEC).xmap(either -> either.map(IntRange::exact, Function.identity()), operator -> {
        OptionalInt optionalInt = operator.unpackExact();
        if (optionalInt.isPresent()) {
            return Either.left(optionalInt.getAsInt());
        }
        return Either.right(operator);
    });
    @Nullable
    private final NumberProvider min;
    @Nullable
    private final NumberProvider max;
    private final IntLimiter limiter;
    private final IntChecker predicate;

    public Set<ContextKey<?>> getReferencedContextParams() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.min != null) {
            builder.addAll(this.min.getReferencedContextParams());
        }
        if (this.max != null) {
            builder.addAll(this.max.getReferencedContextParams());
        }
        return builder.build();
    }

    private IntRange(Optional<NumberProvider> min, Optional<NumberProvider> max) {
        this((NumberProvider)min.orElse(null), (NumberProvider)max.orElse(null));
    }

    private IntRange(@Nullable NumberProvider min, @Nullable NumberProvider max) {
        this.min = min;
        this.max = max;
        if (min == null) {
            if (max == null) {
                this.limiter = (context, value) -> value;
                this.predicate = (context, value) -> true;
            } else {
                this.limiter = (context, value) -> Math.min(max.getInt(context), value);
                this.predicate = (context, value) -> value <= max.getInt(context);
            }
        } else if (max == null) {
            this.limiter = (context, value) -> Math.max(min.getInt(context), value);
            this.predicate = (context, value) -> value >= min.getInt(context);
        } else {
            this.limiter = (context, value) -> Mth.clamp(value, min.getInt(context), max.getInt(context));
            this.predicate = (context, value) -> value >= min.getInt(context) && value <= max.getInt(context);
        }
    }

    public static IntRange exact(int value) {
        ConstantValue constantValue = ConstantValue.exactly(value);
        return new IntRange(Optional.of(constantValue), Optional.of(constantValue));
    }

    public static IntRange range(int min, int max) {
        return new IntRange(Optional.of(ConstantValue.exactly(min)), Optional.of(ConstantValue.exactly(max)));
    }

    public static IntRange lowerBound(int min) {
        return new IntRange(Optional.of(ConstantValue.exactly(min)), Optional.empty());
    }

    public static IntRange upperBound(int max) {
        return new IntRange(Optional.empty(), Optional.of(ConstantValue.exactly(max)));
    }

    public int clamp(LootContext context, int value) {
        return this.limiter.apply(context, value);
    }

    public boolean test(LootContext context, int value) {
        return this.predicate.test(context, value);
    }

    private OptionalInt unpackExact() {
        ConstantValue constantValue;
        NumberProvider numberProvider;
        if (Objects.equals(this.min, this.max) && (numberProvider = this.min) instanceof ConstantValue && Math.floor((constantValue = (ConstantValue)numberProvider).value()) == (double)constantValue.value()) {
            return OptionalInt.of((int)constantValue.value());
        }
        return OptionalInt.empty();
    }

    @FunctionalInterface
    static interface IntLimiter {
        public int apply(LootContext var1, int var2);
    }

    @FunctionalInterface
    static interface IntChecker {
        public boolean test(LootContext var1, int var2);
    }
}

