/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyBonusCount
extends LootItemConditionalFunction {
    private static final Map<ResourceLocation, FormulaType> FORMULAS = Stream.of(BinomialWithBonusCount.TYPE, OreDrops.TYPE, UniformBonusCount.TYPE).collect(Collectors.toMap(FormulaType::id, Function.identity()));
    private static final Codec<FormulaType> FORMULA_TYPE_CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
        FormulaType formulaType = FORMULAS.get(id);
        if (formulaType != null) {
            return DataResult.success((Object)formulaType);
        }
        return DataResult.error(() -> "No formula type with id: '" + String.valueOf(id) + "'");
    }, FormulaType::id);
    private static final MapCodec<Formula> FORMULA_CODEC = ExtraCodecs.dispatchOptionalValue("formula", "parameters", FORMULA_TYPE_CODEC, Formula::getType, FormulaType::codec);
    public static final MapCodec<ApplyBonusCount> CODEC = RecordCodecBuilder.mapCodec(instance -> ApplyBonusCount.commonFields(instance).and(instance.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(function -> function.enchantment), (App)FORMULA_CODEC.forGetter(function -> function.formula))).apply((Applicative)instance, ApplyBonusCount::new));
    private final Holder<Enchantment> enchantment;
    private final Formula formula;

    private ApplyBonusCount(List<LootItemCondition> conditions, Holder<Enchantment> enchantment, Formula formula) {
        super(conditions);
        this.enchantment = enchantment;
        this.formula = formula;
    }

    @Override
    public LootItemFunctionType<ApplyBonusCount> getType() {
        return LootItemFunctions.APPLY_BONUS;
    }

    @Override
    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.TOOL);
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        ItemStack itemStack = context.getOptionalParameter(LootContextParams.TOOL);
        if (itemStack != null) {
            int i = EnchantmentHelper.getItemEnchantmentLevel(this.enchantment, itemStack);
            int j = this.formula.calculateNewCount(context.getRandom(), stack.getCount(), i);
            stack.setCount(j);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> addBonusBinomialDistributionCount(Holder<Enchantment> enchantment, float probability, int extra) {
        return ApplyBonusCount.simpleBuilder(conditions -> new ApplyBonusCount((List<LootItemCondition>)conditions, enchantment, new BinomialWithBonusCount(extra, probability)));
    }

    public static LootItemConditionalFunction.Builder<?> addOreBonusCount(Holder<Enchantment> enchantment) {
        return ApplyBonusCount.simpleBuilder(conditions -> new ApplyBonusCount((List<LootItemCondition>)conditions, enchantment, new OreDrops()));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Holder<Enchantment> enchantment) {
        return ApplyBonusCount.simpleBuilder(conditions -> new ApplyBonusCount((List<LootItemCondition>)conditions, enchantment, new UniformBonusCount(1)));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Holder<Enchantment> enchantment, int bonusMultiplier) {
        return ApplyBonusCount.simpleBuilder(conditions -> new ApplyBonusCount((List<LootItemCondition>)conditions, enchantment, new UniformBonusCount(bonusMultiplier)));
    }

    static interface Formula {
        public int calculateNewCount(RandomSource var1, int var2, int var3);

        public FormulaType getType();
    }

    record UniformBonusCount(int bonusMultiplier) implements Formula
    {
        public static final Codec<UniformBonusCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(UniformBonusCount::bonusMultiplier)).apply((Applicative)instance, UniformBonusCount::new));
        public static final FormulaType TYPE = new FormulaType(ResourceLocation.withDefaultNamespace("uniform_bonus_count"), CODEC);

        @Override
        @Override
        public int calculateNewCount(RandomSource random, int initialCount, int enchantmentLevel) {
            return initialCount + random.nextInt(this.bonusMultiplier * enchantmentLevel + 1);
        }

        @Override
        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record OreDrops() implements Formula
    {
        public static final Codec<OreDrops> CODEC = Codec.unit(OreDrops::new);
        public static final FormulaType TYPE = new FormulaType(ResourceLocation.withDefaultNamespace("ore_drops"), CODEC);

        @Override
        @Override
        public int calculateNewCount(RandomSource random, int initialCount, int enchantmentLevel) {
            if (enchantmentLevel > 0) {
                int i = random.nextInt(enchantmentLevel + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return initialCount * (i + 1);
            }
            return initialCount;
        }

        @Override
        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record BinomialWithBonusCount(int extraRounds, float probability) implements Formula
    {
        private static final Codec<BinomialWithBonusCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("extra").forGetter(BinomialWithBonusCount::extraRounds), (App)Codec.FLOAT.fieldOf("probability").forGetter(BinomialWithBonusCount::probability)).apply((Applicative)instance, BinomialWithBonusCount::new));
        public static final FormulaType TYPE = new FormulaType(ResourceLocation.withDefaultNamespace("binomial_with_bonus_count"), CODEC);

        @Override
        @Override
        public int calculateNewCount(RandomSource random, int initialCount, int enchantmentLevel) {
            for (int i = 0; i < enchantmentLevel + this.extraRounds; ++i) {
                if (!(random.nextFloat() < this.probability)) continue;
                ++initialCount;
            }
            return initialCount;
        }

        @Override
        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record FormulaType(ResourceLocation id, Codec<? extends Formula> codec) {
    }
}

