/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import org.apache.commons.lang3.mutable.MutableObject;

public class CopyCustomDataFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyCustomDataFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyCustomDataFunction.commonFields(instance).and(instance.group((App)NbtProviders.CODEC.fieldOf("source").forGetter(function -> function.source), (App)CopyOperation.CODEC.listOf().fieldOf("ops").forGetter(function -> function.operations))).apply((Applicative)instance, CopyCustomDataFunction::new));
    private final NbtProvider source;
    private final List<CopyOperation> operations;

    CopyCustomDataFunction(List<LootItemCondition> conditions, NbtProvider source, List<CopyOperation> operations) {
        super(conditions);
        this.source = source;
        this.operations = List.copyOf(operations);
    }

    @Override
    public LootItemFunctionType<CopyCustomDataFunction> getType() {
        return LootItemFunctions.COPY_CUSTOM_DATA;
    }

    @Override
    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        Tag tag = this.source.get(context);
        if (tag == null) {
            return stack;
        }
        MutableObject mutableObject = new MutableObject();
        Supplier<Tag> supplier = () -> {
            if (mutableObject.getValue() == null) {
                mutableObject.setValue((Object)stack.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY).copyTag());
            }
            return (Tag)mutableObject.getValue();
        };
        this.operations.forEach(operation -> operation.apply(supplier, tag));
        CompoundTag compoundTag = (CompoundTag)mutableObject.getValue();
        if (compoundTag != null) {
            CustomData.set(DataComponents.CUSTOM_DATA, stack, compoundTag);
        }
        return stack;
    }

    @Deprecated
    public static Builder copyData(NbtProvider source) {
        return new Builder(source);
    }

    public static Builder copyData(LootContext.EntityTarget target) {
        return new Builder(ContextNbtProvider.forContextEntity(target));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NbtProvider source;
        private final List<CopyOperation> ops = Lists.newArrayList();

        Builder(NbtProvider source) {
            this.source = source;
        }

        public Builder copy(String source, String target, MergeStrategy operator) {
            try {
                this.ops.add(new CopyOperation(NbtPathArgument.NbtPath.of(source), NbtPathArgument.NbtPath.of(target), operator));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new IllegalArgumentException(commandSyntaxException);
            }
            return this;
        }

        public Builder copy(String source, String target) {
            return this.copy(source, target, MergeStrategy.REPLACE);
        }

        @Override
        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction build() {
            return new CopyCustomDataFunction(this.getConditions(), this.source, this.ops);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }

    record CopyOperation(NbtPathArgument.NbtPath sourcePath, NbtPathArgument.NbtPath targetPath, MergeStrategy op) {
        public static final Codec<CopyOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NbtPathArgument.NbtPath.CODEC.fieldOf("source").forGetter(CopyOperation::sourcePath), (App)NbtPathArgument.NbtPath.CODEC.fieldOf("target").forGetter(CopyOperation::targetPath), (App)MergeStrategy.CODEC.fieldOf("op").forGetter(CopyOperation::op)).apply((Applicative)instance, CopyOperation::new));

        public void apply(Supplier<Tag> itemNbtGetter, Tag sourceEntityNbt) {
            try {
                List<Tag> list = this.sourcePath.get(sourceEntityNbt);
                if (!list.isEmpty()) {
                    this.op.merge(itemNbtGetter.get(), this.targetPath, list);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public static enum MergeStrategy implements StringRepresentable
    {
        REPLACE("replace"){

            @Override
            @Override
            public void merge(Tag itemNbt, NbtPathArgument.NbtPath targetPath, List<Tag> sourceNbts) throws CommandSyntaxException {
                targetPath.set(itemNbt, (Tag)Iterables.getLast(sourceNbts));
            }
        }
        ,
        APPEND("append"){

            @Override
            @Override
            public void merge(Tag itemNbt, NbtPathArgument.NbtPath targetPath, List<Tag> sourceNbts) throws CommandSyntaxException {
                List<Tag> list = targetPath.getOrCreate(itemNbt, ListTag::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof ListTag) {
                        sourceNbts.forEach(sourceNbt -> ((ListTag)foundNbt).add(sourceNbt.copy()));
                    }
                });
            }
        }
        ,
        MERGE("merge"){

            @Override
            @Override
            public void merge(Tag itemNbt, NbtPathArgument.NbtPath targetPath, List<Tag> sourceNbts) throws CommandSyntaxException {
                List<Tag> list = targetPath.getOrCreate(itemNbt, CompoundTag::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof CompoundTag) {
                        sourceNbts.forEach(sourceNbt -> {
                            if (sourceNbt instanceof CompoundTag) {
                                ((CompoundTag)foundNbt).merge((CompoundTag)sourceNbt);
                            }
                        });
                    }
                });
            }
        };

        public static final Codec<MergeStrategy> CODEC;
        private final String name;

        public abstract void merge(Tag var1, NbtPathArgument.NbtPath var2, List<Tag> var3) throws CommandSyntaxException;

        MergeStrategy(String name) {
            this.name = name;
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(MergeStrategy::values);
        }
    }
}

