/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetItemCountFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetItemCountFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetItemCountFunction.commonFields(instance).and(instance.group((App)NumberProviders.CODEC.fieldOf("count").forGetter(function -> function.value), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(function -> function.add))).apply((Applicative)instance, SetItemCountFunction::new));
    private final NumberProvider value;
    private final boolean add;

    private SetItemCountFunction(List<LootItemCondition> conditions, NumberProvider countRange, boolean add) {
        super(conditions);
        this.value = countRange;
        this.add = add;
    }

    @Override
    public LootItemFunctionType<SetItemCountFunction> getType() {
        return LootItemFunctions.SET_COUNT;
    }

    @Override
    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        int i = this.add ? stack.getCount() : 0;
        stack.setCount(i + this.value.getInt(context));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setCount(NumberProvider countRange) {
        return SetItemCountFunction.simpleBuilder(list -> new SetItemCountFunction((List<LootItemCondition>)list, countRange, false));
    }

    public static LootItemConditionalFunction.Builder<?> setCount(NumberProvider countRange, boolean add) {
        return SetItemCountFunction.simpleBuilder(list -> new SetItemCountFunction((List<LootItemCondition>)list, countRange, add));
    }
}

